/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.kotlin;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.collect.ImmutableMap;
import dagger.internal.codegen.extension.DaggerCollectors;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.kotlin.AutoValue_KotlinMetadata;
import dagger.internal.codegen.kotlin.AutoValue_KotlinMetadata_MethodForAnnotations;
import dagger.internal.codegen.kotlin.ClassMetadata;
import dagger.internal.codegen.kotlin.PropertyMetadata;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XFieldElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;

@AutoValue
abstract class KotlinMetadata {
    private static final String DELEGATED_PROPERTY_NAME_SUFFIX = "$delegate";
    private final Map<XFieldElement, Optional<MethodForAnnotations>> elementFieldAnnotationMethodMap = new HashMap<XFieldElement, Optional<MethodForAnnotations>>();
    private final Map<XFieldElement, Optional<XMethodElement>> elementFieldGetterMethodMap = new HashMap<XFieldElement, Optional<XMethodElement>>();

    KotlinMetadata() {
    }

    abstract XTypeElement typeElement();

    abstract ClassMetadata classMetadata();

    @Memoized
    ImmutableMap<String, XMethodElement> methodDescriptors() {
        return (ImmutableMap)this.typeElement().getDeclaredMethods().stream().collect(DaggerStreams.toImmutableMap(XExecutableElement::getJvmDescriptor, Function.identity()));
    }

    Optional<XMethodElement> getSyntheticAnnotationMethod(XFieldElement fieldElement) {
        return this.getAnnotationMethod(fieldElement).map(methodForAnnotations -> {
            if (methodForAnnotations == MethodForAnnotations.MISSING) {
                throw new IllegalStateException("Method for annotations is missing for " + fieldElement);
            }
            return methodForAnnotations.method();
        });
    }

    boolean isMissingSyntheticAnnotationMethod(XFieldElement fieldElement) {
        return this.getAnnotationMethod(fieldElement).map(methodForAnnotations -> methodForAnnotations == MethodForAnnotations.MISSING).orElse(false);
    }

    private Optional<MethodForAnnotations> getAnnotationMethod(XFieldElement fieldElement) {
        return this.elementFieldAnnotationMethodMap.computeIfAbsent(fieldElement, this::getAnnotationMethodUncached);
    }

    private Optional<MethodForAnnotations> getAnnotationMethodUncached(XFieldElement fieldElement) {
        return Optional.ofNullable(this.findProperty(fieldElement).getMethodForAnnotationsSignature()).map(signature -> Optional.ofNullable((XMethodElement)this.methodDescriptors().get(signature)).map(MethodForAnnotations::create).orElse(MethodForAnnotations.MISSING));
    }

    Optional<XMethodElement> getPropertyGetter(XFieldElement fieldElement) {
        return this.elementFieldGetterMethodMap.computeIfAbsent(fieldElement, this::getPropertyGetterUncached);
    }

    private Optional<XMethodElement> getPropertyGetterUncached(XFieldElement fieldElement) {
        return Optional.ofNullable(this.findProperty(fieldElement).getGetterSignature()).flatMap(signature -> Optional.ofNullable((XMethodElement)this.methodDescriptors().get(signature)));
    }

    private PropertyMetadata findProperty(XFieldElement field) {
        String fieldDescriptor = field.getJvmDescriptor();
        if (this.classMetadata().getPropertiesBySignature().containsKey(fieldDescriptor)) {
            return this.classMetadata().getPropertiesBySignature().get(fieldDescriptor);
        }
        String propertyName = KotlinMetadata.getPropertyNameFromField(field);
        return (PropertyMetadata)this.classMetadata().getPropertiesBySignature().values().stream().filter(property -> propertyName.contentEquals(property.getName())).collect(DaggerCollectors.onlyElement());
    }

    private static String getPropertyNameFromField(XFieldElement field) {
        String name = XElements.getSimpleName((XElement)field);
        if (name.endsWith(DELEGATED_PROPERTY_NAME_SUFFIX)) {
            return name.substring(0, name.length() - DELEGATED_PROPERTY_NAME_SUFFIX.length());
        }
        return name;
    }

    static KotlinMetadata from(XTypeElement typeElement) {
        return new AutoValue_KotlinMetadata(typeElement, ClassMetadata.of(typeElement));
    }

    @AutoValue
    static abstract class MethodForAnnotations {
        static final MethodForAnnotations MISSING = MethodForAnnotations.create(null);

        MethodForAnnotations() {
        }

        static MethodForAnnotations create(XMethodElement method) {
            return new AutoValue_KotlinMetadata_MethodForAnnotations(method);
        }

        @Nullable
        abstract XMethodElement method();
    }
}

