/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import dagger.internal.codegen.base.Formatter;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableElement;
import java.util.stream.Collectors;
import javax.inject.Inject;

public final class ElementFormatter
extends Formatter<XElement> {
    @Inject
    ElementFormatter() {
    }

    @Override
    public String format(XElement element) {
        return ElementFormatter.elementToString(element);
    }

    public static String elementToString(XElement element) {
        return ElementFormatter.elementToString(element, false);
    }

    public static String elementToString(XElement element, boolean elideMethodParameterTypes) {
        if (XElements.isExecutable(element)) {
            return ElementFormatter.enclosingTypeAndMemberName(element).append(elideMethodParameterTypes ? (XElements.asExecutable(element).getParameters().isEmpty() ? "()" : "(\u2026)") : XElements.asExecutable(element).getParameters().stream().map(parameter -> XTypes.toStableString(parameter.getType())).collect(Collectors.joining(", ", "(", ")"))).toString();
        }
        if (XElementKt.isMethodParameter((XElement)element)) {
            XExecutableElement methodOrConstructor = XElements.asMethodParameter(element).getEnclosingElement();
            return ElementFormatter.enclosingTypeAndMemberName((XElement)methodOrConstructor).append('(').append(ElementFormatter.formatArgumentInList(methodOrConstructor.getParameters().indexOf(element), methodOrConstructor.getParameters().size(), XElements.getSimpleName(element))).append(')').toString();
        }
        if (XElementKt.isField((XElement)element)) {
            return ElementFormatter.enclosingTypeAndMemberName(element).toString();
        }
        if (XElementKt.isTypeElement((XElement)element)) {
            return XElements.asTypeElement(element).getQualifiedName();
        }
        throw new UnsupportedOperationException("Can't determine string for element " + element);
    }

    private static StringBuilder enclosingTypeAndMemberName(XElement element) {
        StringBuilder name = new StringBuilder(ElementFormatter.elementToString(element.getEnclosingElement()));
        if (!XElements.getSimpleName(element).contentEquals("<init>")) {
            name.append('.').append(XElements.getSimpleName(element));
        }
        return name;
    }
}

