/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.base.MapKeyAccessibility;
import dagger.internal.codegen.base.UniqueNameSet;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotation;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.Modifier;

public final class LazyClassKeyProviders {
    public static final String MAP_KEY_PROVIDER_NAME = "LazyClassKeyProvider";
    private final ClassName mapKeyProviderType;
    private final Map<Key, FieldSpec> entries = new HashMap<Key, FieldSpec>();
    private final Map<Key, FieldSpec> keepClassNamesFields = new HashMap<Key, FieldSpec>();
    private final UniqueNameSet uniqueFieldNames = new UniqueNameSet();
    private final ComponentImplementation.ShardImplementation shardImplementation;
    private boolean providerAdded = false;

    LazyClassKeyProviders(ComponentImplementation.ShardImplementation shardImplementation) {
        String name = shardImplementation.getUniqueClassName(MAP_KEY_PROVIDER_NAME);
        this.mapKeyProviderType = shardImplementation.name().nestedClass(name);
        this.shardImplementation = shardImplementation;
    }

    CodeBlock getMapKeyExpression(Key key) {
        if (!this.providerAdded) {
            this.shardImplementation.addTypeSupplier((Supplier<TypeSpec>)((Supplier)this::build));
            this.providerAdded = true;
        }
        if (!this.entries.containsKey(key)) {
            this.addField(key);
        }
        return CodeBlock.of((String)"$T.$N", (Object[])new Object[]{this.mapKeyProviderType, this.entries.get(key)});
    }

    private void addField(Key key) {
        Preconditions.checkArgument((key.multibindingContributionIdentifier().isPresent() && key.multibindingContributionIdentifier().get().bindingMethod().xprocessing().hasAnnotation(TypeNames.LAZY_CLASS_KEY) ? 1 : 0) != 0);
        XAnnotation lazyClassKeyAnnotation = key.multibindingContributionIdentifier().get().bindingMethod().xprocessing().getAnnotation(TypeNames.LAZY_CLASS_KEY);
        ClassName lazyClassKey = lazyClassKeyAnnotation.getAsType("value").getTypeElement().getClassName();
        this.entries.put(key, FieldSpec.builder((TypeName)TypeNames.STRING, (String)this.uniqueFieldNames.getUniqueName(lazyClassKey.canonicalName().replace('.', '_')), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.STATIC}).initializer("$S", new Object[]{lazyClassKey.reflectionName()}).build());
        if (MapKeyAccessibility.isMapKeyAccessibleFrom(lazyClassKeyAnnotation, this.shardImplementation.name().packageName())) {
            this.keepClassNamesFields.put(key, FieldSpec.builder((TypeName)lazyClassKey, (String)this.uniqueFieldNames.getUniqueName(lazyClassKey.canonicalName().replace('.', '_')), (Modifier[])new Modifier[0]).addAnnotation(TypeNames.KEEP_FIELD_TYPE).build());
        }
    }

    private TypeSpec build() {
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)this.mapKeyProviderType).addAnnotation(TypeNames.IDENTIFIER_NAME_STRING).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).addFields(this.entries.values()).addFields(this.keepClassNamesFields.values());
        return builder.build();
    }
}

