/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.auto.value.AutoValue;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.base.MapType;
import dagger.internal.codegen.binding.AutoValue_FrameworkField;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.KeyVariableNamer;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.model.BindingKind;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import java.util.Optional;

@AutoValue
public abstract class FrameworkField {
    public static FrameworkField create(TypeName fieldType, String fieldName) {
        Preconditions.checkState((fieldType instanceof ClassName || fieldType instanceof ParameterizedTypeName ? 1 : 0) != 0, (Object)"Can only create a field with a class name or parameterized type name");
        String suffix = ((ClassName)TypeNames.rawTypeName(fieldType)).simpleName();
        return new AutoValue_FrameworkField(fieldType, fieldName.endsWith(suffix) ? fieldName : fieldName + suffix);
    }

    public static FrameworkField forBinding(ContributionBinding binding, Optional<ClassName> frameworkClassName) {
        return FrameworkField.create(FrameworkField.fieldType(binding, frameworkClassName.orElse(binding.frameworkType().frameworkClassName())), FrameworkField.frameworkFieldName(binding));
    }

    private static TypeName fieldType(ContributionBinding binding, ClassName frameworkClassName) {
        if (binding.contributionType().isMultibinding()) {
            return ParameterizedTypeName.get((ClassName)frameworkClassName, (TypeName[])new TypeName[]{binding.contributedType().getTypeName()});
        }
        if (MapType.isMapOfProvider(binding.contributedType())) {
            return frameworkClassName;
        }
        return ParameterizedTypeName.get((ClassName)frameworkClassName, (TypeName[])new TypeName[]{binding.key().type().xprocessing().getTypeName()});
    }

    private static String frameworkFieldName(ContributionBinding binding) {
        if (binding.bindingElement().isPresent()) {
            String name = FrameworkField.bindingElementName(binding.bindingElement().get());
            return binding.kind().equals((Object)BindingKind.MEMBERS_INJECTOR) ? name + "MembersInjector" : name;
        }
        return KeyVariableNamer.name(binding.key());
    }

    private static String bindingElementName(XElement bindingElement) {
        if (XElementKt.isConstructor((XElement)bindingElement)) {
            return FrameworkField.bindingElementName(bindingElement.getEnclosingElement());
        }
        if (XElementKt.isMethod((XElement)bindingElement)) {
            return XElements.getSimpleName(bindingElement);
        }
        if (XElementKt.isTypeElement((XElement)bindingElement)) {
            return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, XElements.getSimpleName(bindingElement));
        }
        if (XElementKt.isMethodParameter((XElement)bindingElement)) {
            return XElements.getSimpleName(bindingElement);
        }
        throw new IllegalArgumentException("Unexpected binding " + bindingElement);
    }

    public abstract TypeName type();

    public abstract String name();
}

