/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import dagger.internal.codegen.base.ComponentAnnotation;
import dagger.internal.codegen.base.DaggerSuperficialValidation;
import dagger.internal.codegen.base.DiagnosticFormatting;
import dagger.internal.codegen.base.Scopes;
import dagger.internal.codegen.base.Util;
import dagger.internal.codegen.binding.ComponentCreatorDescriptor;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.ErrorMessages;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.binding.MethodSignatureFormatter;
import dagger.internal.codegen.binding.ModuleDescriptor;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.compileroption.ValidationType;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.model.Scope;
import dagger.internal.codegen.validation.ComponentHierarchyValidator;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableParameterElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.tools.Diagnostic;

public final class ComponentDescriptorValidator {
    private final CompilerOptions compilerOptions;
    private final MethodSignatureFormatter methodSignatureFormatter;
    private final ComponentHierarchyValidator componentHierarchyValidator;
    private final InjectionAnnotations injectionAnnotations;
    private final DaggerSuperficialValidation superficialValidation;

    @Inject
    ComponentDescriptorValidator(CompilerOptions compilerOptions, MethodSignatureFormatter methodSignatureFormatter, ComponentHierarchyValidator componentHierarchyValidator, InjectionAnnotations injectionAnnotations, DaggerSuperficialValidation superficialValidation) {
        this.compilerOptions = compilerOptions;
        this.methodSignatureFormatter = methodSignatureFormatter;
        this.componentHierarchyValidator = componentHierarchyValidator;
        this.injectionAnnotations = injectionAnnotations;
        this.superficialValidation = superficialValidation;
    }

    public ValidationReport validate(ComponentDescriptor component) {
        ComponentValidation validation = new ComponentValidation(component);
        validation.visitComponent(component);
        validation.report(component).addSubreport(this.componentHierarchyValidator.validate(component));
        return validation.buildReport();
    }

    private final class ComponentValidation {
        final ComponentDescriptor rootComponent;
        final Map<ComponentDescriptor, ValidationReport.Builder> reports = new LinkedHashMap<ComponentDescriptor, ValidationReport.Builder>();

        ComponentValidation(ComponentDescriptor rootComponent) {
            this.rootComponent = (ComponentDescriptor)Preconditions.checkNotNull((Object)rootComponent);
        }

        ValidationReport buildReport() {
            ValidationReport.Builder report = ValidationReport.about((XElement)this.rootComponent.typeElement());
            this.reports.values().forEach(subreport -> report.addSubreport(subreport.build()));
            return report.build();
        }

        private ValidationReport.Builder report(ComponentDescriptor component) {
            return Util.reentrantComputeIfAbsent(this.reports, component, descriptor -> ValidationReport.about((XElement)descriptor.typeElement()));
        }

        private void reportComponentItem(Diagnostic.Kind kind, ComponentDescriptor component, String message) {
            this.report(component).addItem(message, kind, (XElement)component.typeElement(), component.annotation().annotation());
        }

        private void reportComponentError(ComponentDescriptor component, String error) {
            this.reportComponentItem(Diagnostic.Kind.ERROR, component, error);
        }

        void visitComponent(ComponentDescriptor component) {
            this.validateDependencyScopes(component);
            this.validateComponentDependencyHierarchy(component);
            this.validateModules(component);
            this.validateCreators(component);
            component.childComponents().forEach(this::visitComponent);
        }

        private void validateComponentDependencyHierarchy(ComponentDescriptor component) {
            this.validateComponentDependencyHierarchy(component, component.typeElement(), new ArrayDeque<XTypeElement>());
        }

        private void validateComponentDependencyHierarchy(ComponentDescriptor component, XTypeElement dependency, Deque<XTypeElement> dependencyStack) {
            if (dependencyStack.contains(dependency)) {
                StringBuilder message = new StringBuilder();
                message.append(component.typeElement().getQualifiedName());
                message.append(" contains a cycle in its component dependencies:\n");
                dependencyStack.push(dependency);
                this.appendIndentedComponentsList(message, dependencyStack);
                dependencyStack.pop();
                this.reportComponentItem(ComponentDescriptorValidator.this.compilerOptions.scopeCycleValidationType().diagnosticKind().get(), component, message.toString());
            } else if (ComponentDescriptorValidator.this.compilerOptions.validateTransitiveComponentDependencies() || dependencyStack.isEmpty()) {
                ComponentAnnotation.rootComponentAnnotation(dependency, ComponentDescriptorValidator.this.superficialValidation).ifPresent(componentAnnotation -> {
                    dependencyStack.push(dependency);
                    for (XTypeElement nextDependency : componentAnnotation.dependencies()) {
                        this.validateComponentDependencyHierarchy(component, nextDependency, dependencyStack);
                    }
                    dependencyStack.pop();
                });
            }
        }

        private void validateDependencyScopes(ComponentDescriptor component) {
            ImmutableSet scopes = (ImmutableSet)component.scopes().stream().map(Scope::className).collect(DaggerStreams.toImmutableSet());
            ImmutableSet<XTypeElement> scopedDependencies = this.scopedTypesIn((Collection)component.dependencies().stream().map(ComponentRequirement::typeElement).collect(DaggerStreams.toImmutableSet()));
            if (!scopes.isEmpty()) {
                if (ComponentDescriptorValidator.this.compilerOptions.scopeCycleValidationType().diagnosticKind().isPresent() && (scopes.contains((Object)TypeNames.SINGLETON) || scopes.contains((Object)TypeNames.SINGLETON_JAVAX))) {
                    if (!scopedDependencies.isEmpty()) {
                        StringBuilder message = new StringBuilder("This @Singleton component cannot depend on scoped components:\n");
                        this.appendIndentedComponentsList(message, (Iterable<XTypeElement>)scopedDependencies);
                        this.reportComponentItem(ComponentDescriptorValidator.this.compilerOptions.scopeCycleValidationType().diagnosticKind().get(), component, message.toString());
                    }
                } else if (!ComponentDescriptorValidator.this.compilerOptions.scopeCycleValidationType().equals((Object)ValidationType.NONE)) {
                    this.validateDependencyScopeHierarchy(component, component.typeElement(), new ArrayDeque<ImmutableSet<Scope>>(), new ArrayDeque<XTypeElement>());
                }
            } else if (!scopedDependencies.isEmpty()) {
                StringBuilder message = new StringBuilder(component.typeElement().getQualifiedName()).append(" (unscoped) cannot depend on scoped components:\n");
                this.appendIndentedComponentsList(message, (Iterable<XTypeElement>)scopedDependencies);
                this.reportComponentError(component, message.toString());
            }
        }

        private void validateModules(ComponentDescriptor component) {
            block0: for (ModuleDescriptor module : component.modules()) {
                if (!module.moduleElement().isAbstract()) continue;
                for (ContributionBinding binding : module.bindings()) {
                    if (!binding.requiresModuleInstance()) continue;
                    this.report(component).addError(this.abstractModuleHasInstanceBindingMethodsError(module));
                    continue block0;
                }
            }
        }

        private String abstractModuleHasInstanceBindingMethodsError(ModuleDescriptor module) {
            String methodAnnotations;
            switch (module.kind()) {
                case MODULE: {
                    methodAnnotations = "@Provides";
                    break;
                }
                case PRODUCER_MODULE: {
                    methodAnnotations = "@Provides or @Produces";
                    break;
                }
                default: {
                    throw new AssertionError((Object)module.kind());
                }
            }
            return String.format("%s is abstract and has instance %s methods. Consider making the methods static or including a non-abstract subclass of the module instead.", module.moduleElement(), methodAnnotations);
        }

        private void validateCreators(ComponentDescriptor component) {
            Set mustBePassed;
            Sets.SetView missingRequirements;
            if (!component.creatorDescriptor().isPresent()) {
                return;
            }
            ComponentCreatorDescriptor creator = component.creatorDescriptor().get();
            ErrorMessages.ComponentCreatorMessages messages = ErrorMessages.creatorMessagesFor(creator.annotation());
            ImmutableSet<ComponentRequirement> creatorModuleAndDependencyRequirements = creator.moduleAndDependencyRequirements();
            ImmutableSet<ComponentRequirement> componentModuleAndDependencyRequirements = component.dependenciesAndConcreteModules();
            Sets.SetView inapplicableRequirementsOnCreator = Sets.difference(creatorModuleAndDependencyRequirements, componentModuleAndDependencyRequirements);
            XType container = creator.typeElement().getType();
            if (!inapplicableRequirementsOnCreator.isEmpty()) {
                Collection excessElements = Multimaps.filterKeys(creator.unvalidatedRequirementElements(), (Predicate)Predicates.in((Collection)inapplicableRequirementsOnCreator)).values();
                String formatted = excessElements.stream().map(element -> this.formatElement((XElement)element, container)).collect(Collectors.joining(", ", "[", "]"));
                this.report(component).addError(String.format(messages.extraSetters(), formatted), (XElement)creator.typeElement());
            }
            if (!(missingRequirements = Sets.difference((Set)(mustBePassed = Sets.filter(componentModuleAndDependencyRequirements, input -> input.nullPolicy().equals((Object)ComponentRequirement.NullPolicy.THROW))), creatorModuleAndDependencyRequirements)).isEmpty()) {
                this.report(component).addError(String.format(messages.missingSetters(), missingRequirements.stream().map(ComponentRequirement::type).map(XTypes::toStableString).collect(DaggerStreams.toImmutableList())), (XElement)creator.typeElement());
            }
            ImmutableSetMultimap declaredRequirementsByType = (ImmutableSetMultimap)Multimaps.filterKeys(creator.unvalidatedRequirementElements(), arg_0 -> creatorModuleAndDependencyRequirements.contains(arg_0)).entries().stream().collect(DaggerStreams.toImmutableSetMultimap(entry -> ((ComponentRequirement)entry.getKey()).type().getTypeName(), Map.Entry::getValue));
            declaredRequirementsByType.asMap().forEach((type, elementsForType) -> {
                if (elementsForType.size() > 1) {
                    this.report(component).addError(String.format(messages.multipleSettersForModuleOrDependencyType(), type, Collections2.transform((Collection)elementsForType, element -> this.formatElement((XElement)element, container))), (XElement)creator.typeElement());
                }
            });
        }

        private String formatElement(XElement element, XType container) {
            if (XElementKt.isMethod((XElement)element)) {
                return ComponentDescriptorValidator.this.methodSignatureFormatter.format((XExecutableElement)XElements.asMethod(element), Optional.of(container));
            }
            if (XElementKt.isMethodParameter((XElement)element)) {
                return this.formatParameter(XElements.asMethodParameter(element), container);
            }
            throw new AssertionError();
        }

        private String formatParameter(XExecutableParameterElement parameter, XType container) {
            StringJoiner joiner = new StringJoiner(" ");
            parameter.getAllAnnotations().stream().map(XAnnotation::getQualifiedName).forEach(joiner::add);
            XType parameterType = this.resolveParameterType(parameter, container);
            return joiner.add(DiagnosticFormatting.stripCommonTypePrefixes(parameterType.getTypeName().toString())).add(XElements.getSimpleName((XElement)parameter)).toString();
        }

        private XType resolveParameterType(XExecutableParameterElement parameter, XType container) {
            Preconditions.checkArgument((boolean)XElementKt.isMethod((XElement)parameter.getEnclosingElement()));
            XMethodElement method = XElements.asMethod((XElement)parameter.getEnclosingElement());
            int parameterIndex = method.getParameters().indexOf(parameter);
            XMethodType methodType = method.asMemberOf(container);
            return (XType)methodType.getParameterTypes().get(parameterIndex);
        }

        private void validateDependencyScopeHierarchy(ComponentDescriptor component, XTypeElement dependency, Deque<ImmutableSet<Scope>> scopeStack, Deque<XTypeElement> scopedDependencyStack) {
            ImmutableSet<Scope> scopes = ComponentDescriptorValidator.this.injectionAnnotations.getScopes((XElement)dependency);
            if (this.stackOverlaps(scopeStack, scopes)) {
                scopedDependencyStack.push(dependency);
                StringBuilder message = new StringBuilder();
                message.append(component.typeElement().getQualifiedName());
                message.append(" depends on scoped components in a non-hierarchical scope ordering:\n");
                this.appendIndentedComponentsList(message, scopedDependencyStack);
                if (ComponentDescriptorValidator.this.compilerOptions.scopeCycleValidationType().diagnosticKind().isPresent()) {
                    this.reportComponentItem(ComponentDescriptorValidator.this.compilerOptions.scopeCycleValidationType().diagnosticKind().get(), component, message.toString());
                }
                scopedDependencyStack.pop();
            } else if (ComponentDescriptorValidator.this.compilerOptions.validateTransitiveComponentDependencies() || scopedDependencyStack.isEmpty()) {
                ComponentAnnotation.rootComponentAnnotation(dependency, ComponentDescriptorValidator.this.superficialValidation).filter(componentAnnotation -> !componentAnnotation.isProduction()).ifPresent(componentAnnotation -> {
                    ImmutableSet<XTypeElement> scopedDependencies = this.scopedTypesIn((Collection<XTypeElement>)componentAnnotation.dependencies());
                    if (!scopedDependencies.isEmpty()) {
                        scopeStack.push(scopes);
                        scopedDependencyStack.push(dependency);
                        for (XTypeElement scopedDependency : scopedDependencies) {
                            this.validateDependencyScopeHierarchy(component, scopedDependency, scopeStack, scopedDependencyStack);
                        }
                        scopedDependencyStack.pop();
                        scopeStack.pop();
                    }
                });
            }
        }

        private <T> boolean stackOverlaps(Deque<ImmutableSet<T>> stack, ImmutableSet<T> set) {
            for (ImmutableSet<T> entry : stack) {
                if (Sets.intersection(entry, set).isEmpty()) continue;
                return true;
            }
            return false;
        }

        private void appendIndentedComponentsList(StringBuilder message, Iterable<XTypeElement> types) {
            for (XTypeElement scopedComponent : types) {
                message.append("    ");
                for (Scope scope : ComponentDescriptorValidator.this.injectionAnnotations.getScopes((XElement)scopedComponent)) {
                    message.append(Scopes.getReadableSource(scope)).append(' ');
                }
                message.append(DiagnosticFormatting.stripCommonTypePrefixes(scopedComponent.getQualifiedName().toString())).append('\n');
            }
        }

        private ImmutableSet<XTypeElement> scopedTypesIn(Collection<XTypeElement> types) {
            return (ImmutableSet)types.stream().filter(type -> !ComponentDescriptorValidator.this.injectionAnnotations.getScopes((XElement)type).isEmpty()).collect(DaggerStreams.toImmutableSet());
        }
    }
}

