/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.xprocessing;

import com.google.common.base.CaseFormat;
import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.javapoet.WildcardTypeName;
import dagger.internal.codegen.extension.DaggerCollectors;
import dagger.spi.shaded.androidx.room.compiler.processing.XArrayType;
import dagger.spi.shaded.androidx.room.compiler.processing.XConstructorType;
import dagger.spi.shaded.androidx.room.compiler.processing.XExecutableType;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodType;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeKt;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeVariableType;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.spi.shaded.auto.common.MoreElements;
import dagger.spi.shaded.auto.common.MoreTypes;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor8;

public final class XTypes {
    private static final Equivalence<XType> XTYPE_EQUIVALENCE_IGNORING_VARIANCE = new XTypeEquivalence(true);
    private static final Equivalence<XType> XTYPE_EQUIVALENCE = new XTypeEquivalence(false);

    public static TypeName stripVariances(TypeName typeName) {
        if (typeName instanceof WildcardTypeName) {
            WildcardTypeName wildcardTypeName = (WildcardTypeName)typeName;
            if (!wildcardTypeName.lowerBounds.isEmpty()) {
                return XTypes.stripVariances((TypeName)Iterables.getOnlyElement((Iterable)wildcardTypeName.lowerBounds));
            }
            if (!wildcardTypeName.upperBounds.isEmpty()) {
                return XTypes.stripVariances((TypeName)Iterables.getOnlyElement((Iterable)wildcardTypeName.upperBounds));
            }
        } else {
            if (typeName instanceof ArrayTypeName) {
                ArrayTypeName arrayTypeName = (ArrayTypeName)typeName;
                return ArrayTypeName.of((TypeName)XTypes.stripVariances(arrayTypeName.componentType));
            }
            if (typeName instanceof ParameterizedTypeName) {
                ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)typeName;
                if (parameterizedTypeName.typeArguments.isEmpty()) {
                    return parameterizedTypeName;
                }
                return ParameterizedTypeName.get((ClassName)parameterizedTypeName.rawType, (TypeName[])((TypeName[])parameterizedTypeName.typeArguments.stream().map(XTypes::stripVariances).toArray(TypeName[]::new)));
            }
        }
        return typeName;
    }

    public static Equivalence<XType> equivalenceIgnoringVariance() {
        return XTYPE_EQUIVALENCE_IGNORING_VARIANCE;
    }

    public static Equivalence<XType> equivalence() {
        return XTYPE_EQUIVALENCE;
    }

    public static XType getEnclosingType(XType type) {
        Preconditions.checkArgument((boolean)XTypes.isDeclared(type));
        XProcessingEnv.Backend backend = XConverters.getProcessingEnv((XType)type).getBackend();
        switch (backend) {
            case JAVAC: {
                return XConverters.toXProcessing((TypeMirror)MoreTypes.asDeclared((TypeMirror)XConverters.toJavac((XType)type)).getEnclosingType(), (XProcessingEnv)XConverters.getProcessingEnv((XType)type));
            }
            case KSP: {
                XTypeElement enclosingTypeElement = type.getTypeElement().getEnclosingTypeElement();
                return enclosingTypeElement == null ? null : enclosingTypeElement.getType();
            }
        }
        throw new AssertionError((Object)("Unexpected backend: " + backend));
    }

    public static boolean isAssignableTo(XType type1, XType type2) {
        return type2.isAssignableFrom(type1);
    }

    public static boolean isSubtype(XType type1, XType type2) {
        XProcessingEnv processingEnv = XConverters.getProcessingEnv((XType)type1);
        switch (processingEnv.getBackend()) {
            case JAVAC: {
                return XConverters.toJavac((XProcessingEnv)processingEnv).getTypeUtils().isSubtype(XConverters.toJavac((XType)type1), XConverters.toJavac((XType)type2));
            }
            case KSP: {
                if (XTypes.isPrimitive(type1) || XTypes.isPrimitive(type2)) {
                    return type1.isSameType(type2);
                }
                return XTypes.isAssignableTo(type1, type2);
            }
        }
        throw new AssertionError((Object)("Unexpected backend: " + processingEnv.getBackend()));
    }

    public static TypeName erasedTypeName(XType type) {
        XProcessingEnv processingEnv = XConverters.getProcessingEnv((XType)type);
        switch (processingEnv.getBackend()) {
            case JAVAC: {
                return XConverters.toXProcessing((TypeMirror)XConverters.toJavac((XProcessingEnv)processingEnv).getTypeUtils().erasure(XConverters.toJavac((XType)type)), (XProcessingEnv)processingEnv).getTypeName();
            }
            case KSP: {
                return XTypes.erasedTypeName(type.getTypeName());
            }
        }
        throw new AssertionError((Object)("Unexpected backend: " + processingEnv.getBackend()));
    }

    private static TypeName erasedTypeName(TypeName typeName) {
        if (typeName instanceof ArrayTypeName) {
            return ArrayTypeName.of((TypeName)XTypes.erasedTypeName(((ArrayTypeName)typeName).componentType));
        }
        if (typeName instanceof ParameterizedTypeName) {
            return ((ParameterizedTypeName)typeName).rawType;
        }
        if (typeName instanceof TypeVariableName) {
            return XTypes.erasedTypeName((TypeName)((TypeVariableName)typeName).bounds.get(0));
        }
        return typeName;
    }

    public static void checkTypePresent(XType type) {
        if (XTypeKt.isArray((XType)type)) {
            XTypes.checkTypePresent(XTypes.asArray(type).getComponentType());
        } else if (XTypes.isDeclared(type)) {
            type.getTypeArguments().forEach(XTypes::checkTypePresent);
        } else if (type.isError()) {
            throw new TypeNotPresentException(type.toString(), null);
        }
    }

    public static boolean isRawParameterizedType(XType type) {
        XProcessingEnv processingEnv = XConverters.getProcessingEnv((XType)type);
        switch (processingEnv.getBackend()) {
            case JAVAC: {
                return XTypes.isDeclared(type) && type.getTypeArguments().isEmpty() && !type.getTypeElement().getType().getTypeArguments().isEmpty();
            }
            case KSP: {
                return XTypes.isDeclared(type) && type.getRawType() != null && type.getTypeName().equals((Object)type.getRawType().getTypeName()) && !type.getTypeElement().getType().getTypeArguments().isEmpty();
            }
        }
        throw new AssertionError((Object)("Unexpected backend: " + processingEnv.getBackend()));
    }

    public static XArrayType asArray(XType type) {
        return (XArrayType)type;
    }

    public static XTypeVariableType asTypeVariable(XType type) {
        return (XTypeVariableType)type;
    }

    public static boolean isTypeOf(XType type, ClassName className) {
        return XTypes.isDeclared(type) && type.getTypeElement().getClassName().equals((Object)className);
    }

    public static boolean isNullType(XType type) {
        XProcessingEnv.Backend backend = XConverters.getProcessingEnv((XType)type).getBackend();
        switch (backend) {
            case JAVAC: {
                return XConverters.toJavac((XType)type).getKind().equals((Object)TypeKind.NULL);
            }
            case KSP: {
                return false;
            }
        }
        throw new AssertionError((Object)("Unexpected backend: " + backend));
    }

    public static boolean isNoType(XType type) {
        return type.isNone() || XTypeKt.isVoid((XType)type);
    }

    public static boolean isWildcard(XType type) {
        XProcessingEnv.Backend backend = XConverters.getProcessingEnv((XType)type).getBackend();
        switch (backend) {
            case JAVAC: {
                return XConverters.toJavac((XType)type).getKind().equals((Object)TypeKind.WILDCARD);
            }
            case KSP: {
                return type.getTypeName() instanceof WildcardTypeName;
            }
        }
        throw new AssertionError((Object)("Unexpected backend: " + backend));
    }

    public static boolean isDeclared(XType type) {
        return !XTypes.isWildcard(type) && !XTypeKt.isArray((XType)type) && type.getTypeElement() != null;
    }

    public static boolean isTypeVariable(XType type) {
        return type.getTypeName() instanceof TypeVariableName;
    }

    public static boolean areEquivalentTypes(XType type1, XType type2) {
        return type1.getTypeName().equals((Object)type2.getTypeName());
    }

    public static boolean isPrimitive(XType type) {
        return type.getTypeName().isPrimitive();
    }

    public static boolean hasTypeParameters(XType type) {
        return !type.getTypeArguments().isEmpty();
    }

    public static boolean isMethod(XExecutableType type) {
        return type instanceof XMethodType;
    }

    public static boolean isConstructor(XExecutableType type) {
        return type instanceof XConstructorType;
    }

    public static boolean isFloat(XType type) {
        return type.getTypeName().equals((Object)TypeName.FLOAT) || type.getTypeName().equals((Object)KnownTypeNames.BOXED_FLOAT);
    }

    public static boolean isShort(XType type) {
        return type.getTypeName().equals((Object)TypeName.SHORT) || type.getTypeName().equals((Object)KnownTypeNames.BOXED_SHORT);
    }

    public static boolean isChar(XType type) {
        return type.getTypeName().equals((Object)TypeName.CHAR) || type.getTypeName().equals((Object)KnownTypeNames.BOXED_CHAR);
    }

    public static boolean isDouble(XType type) {
        return type.getTypeName().equals((Object)TypeName.DOUBLE) || type.getTypeName().equals((Object)KnownTypeNames.BOXED_DOUBLE);
    }

    public static boolean isBoolean(XType type) {
        return type.getTypeName().equals((Object)TypeName.BOOLEAN) || type.getTypeName().equals((Object)KnownTypeNames.BOXED_BOOLEAN);
    }

    public static Optional<XType> nonObjectSuperclass(XType type) {
        return XTypes.isDeclared(type) ? (Optional)type.getSuperTypes().stream().filter(supertype -> !supertype.getTypeName().equals((Object)TypeName.OBJECT)).filter(supertype -> XTypes.isDeclared(supertype) && supertype.getTypeElement().isClass()).collect(DaggerCollectors.toOptional()) : Optional.empty();
    }

    public static XType unwrapType(XType type) {
        XType unwrapped = XTypes.unwrapTypeOrDefault(type, null);
        Preconditions.checkArgument((unwrapped != null ? 1 : 0) != 0, (String)"%s is a raw type", (Object)type);
        return unwrapped;
    }

    private static XType unwrapTypeOrDefault(XType type, XType defaultType) {
        Preconditions.checkArgument((boolean)XTypes.isDeclared(type));
        XTypeElement typeElement = type.getTypeElement();
        Preconditions.checkArgument((typeElement.getType().getTypeArguments().size() == 1 ? 1 : 0) != 0, (String)"%s does not have exactly 1 type parameter. Found: %s", (Object)typeElement.getQualifiedName(), (Object)typeElement.getType().getTypeArguments());
        return (XType)Iterables.getOnlyElement((Iterable)type.getTypeArguments(), (Object)defaultType);
    }

    public static XType rewrapType(XType type, ClassName wrappingClassName) {
        XProcessingEnv processingEnv = XConverters.getProcessingEnv((XType)type);
        XTypeElement wrappingType = processingEnv.requireTypeElement(wrappingClassName.canonicalName());
        switch (type.getTypeArguments().size()) {
            case 0: {
                return processingEnv.getDeclaredType(wrappingType, new XType[0]);
            }
            case 1: {
                return processingEnv.getDeclaredType(wrappingType, new XType[]{(XType)Iterables.getOnlyElement((Iterable)type.getTypeArguments())});
            }
        }
        throw new IllegalArgumentException(type + " has more than 1 type argument");
    }

    public static String toStableString(XType type) {
        try {
            return XTypes.toStableString(type.getTypeName());
        }
        catch (TypeNotPresentException e) {
            return e.typeName();
        }
    }

    private static String toStableString(TypeName typeName) {
        if (typeName instanceof ClassName) {
            return ((ClassName)typeName).canonicalName();
        }
        if (typeName instanceof ArrayTypeName) {
            return String.format("%s[]", XTypes.toStableString(((ArrayTypeName)typeName).componentType));
        }
        if (typeName instanceof ParameterizedTypeName) {
            ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)typeName;
            return String.format("%s<%s>", parameterizedTypeName.rawType, parameterizedTypeName.typeArguments.stream().map(XTypes::toStableString).collect(Collectors.joining(",")));
        }
        if (typeName instanceof WildcardTypeName) {
            WildcardTypeName wildcardTypeName = (WildcardTypeName)typeName;
            TypeName upperBound = (TypeName)Iterables.getOnlyElement((Iterable)wildcardTypeName.upperBounds);
            if (!upperBound.equals((Object)TypeName.OBJECT)) {
                Preconditions.checkState((boolean)wildcardTypeName.lowerBounds.isEmpty());
                return String.format("? extends %s", XTypes.toStableString(upperBound));
            }
            if (!wildcardTypeName.lowerBounds.isEmpty()) {
                TypeName lowerBound = (TypeName)Iterables.getOnlyElement((Iterable)wildcardTypeName.lowerBounds);
                return String.format("? super %s", XTypes.toStableString(lowerBound));
            }
            return "?";
        }
        if (typeName instanceof TypeVariableName) {
            return ((TypeVariableName)typeName).name;
        }
        return typeName.toString();
    }

    public static String getKindName(XType type) {
        if (XTypeKt.isArray((XType)type)) {
            return "ARRAY";
        }
        if (XTypes.isWildcard(type)) {
            return "WILDCARD";
        }
        if (XTypes.isTypeVariable(type)) {
            return "TYPEVAR";
        }
        if (XTypeKt.isVoid((XType)type)) {
            return "VOID";
        }
        if (XTypes.isNullType(type)) {
            return "NULL";
        }
        if (XTypes.isNoType(type)) {
            return "NONE";
        }
        if (XTypes.isPrimitive(type)) {
            return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, type.getTypeName().toString());
        }
        if (type.isError()) {
            return "ERROR";
        }
        if (XTypes.isDeclared(type)) {
            return "DECLARED";
        }
        return "UNKNOWN";
    }

    public static void resolveIfNeeded(XType type) {
        if (XConverters.getProcessingEnv((XType)type).getBackend() == XProcessingEnv.Backend.JAVAC) {
            XConverters.toJavac((XType)type).accept(TypeResolutionVisitor.INSTANCE, new HashSet());
        }
    }

    private XTypes() {
    }

    private static final class TypeResolutionVisitor
    extends SimpleTypeVisitor8<Void, Set<Element>> {
        static final TypeResolutionVisitor INSTANCE = new TypeResolutionVisitor();

        private TypeResolutionVisitor() {
        }

        @Override
        public Void visitDeclared(DeclaredType t, Set<Element> visited) {
            if (!visited.add(t.asElement())) {
                return null;
            }
            if (MoreElements.asType((Element)t.asElement()).getQualifiedName().toString().contains("$")) {
                t.asElement().getKind();
            }
            t.getTypeArguments().forEach(arg -> arg.accept(this, visited));
            return null;
        }

        @Override
        public Void visitError(ErrorType t, Set<Element> visited) {
            this.visitDeclared((DeclaredType)t, visited);
            return null;
        }

        @Override
        public Void visitArray(ArrayType t, Set<Element> visited) {
            t.getComponentType().accept(this, visited);
            return null;
        }

        @Override
        public Void visitWildcard(WildcardType t, Set<Element> visited) {
            if (t.getExtendsBound() != null) {
                t.getExtendsBound().accept(this, visited);
            }
            if (t.getSuperBound() != null) {
                t.getSuperBound().accept(this, visited);
            }
            return null;
        }

        @Override
        protected Void defaultAction(TypeMirror e, Set<Element> visited) {
            return null;
        }
    }

    private static class KnownTypeNames {
        static final TypeName BOXED_SHORT = TypeName.SHORT.box();
        static final TypeName BOXED_DOUBLE = TypeName.DOUBLE.box();
        static final TypeName BOXED_FLOAT = TypeName.FLOAT.box();
        static final TypeName BOXED_CHAR = TypeName.CHAR.box();
        static final TypeName BOXED_BOOLEAN = TypeName.BOOLEAN.box();

        private KnownTypeNames() {
        }
    }

    private static class XTypeEquivalence
    extends Equivalence<XType> {
        private final boolean ignoreVariance;

        XTypeEquivalence(boolean ignoreVariance) {
            this.ignoreVariance = ignoreVariance;
        }

        protected boolean doEquivalent(XType left, XType right) {
            return this.getTypeName(left).equals((Object)this.getTypeName(right));
        }

        protected int doHash(XType type) {
            return this.getTypeName(type).hashCode();
        }

        public String toString() {
            return "XTypes.equivalence()";
        }

        private TypeName getTypeName(XType type) {
            return this.ignoreVariance ? XTypes.stripVariances(type.getTypeName()) : type.getTypeName();
        }
    }
}

