/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.base.ElementFormatter;
import dagger.internal.codegen.model.BindingGraph;
import dagger.internal.codegen.model.DiagnosticReporter;
import dagger.internal.codegen.validation.DiagnosticMessageGenerator;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMessager;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import javax.inject.Inject;
import javax.tools.Diagnostic;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

final class DiagnosticReporterFactory {
    private final XMessager messager;
    private final DiagnosticMessageGenerator.Factory diagnosticMessageGeneratorFactory;

    @Inject
    DiagnosticReporterFactory(XMessager messager, DiagnosticMessageGenerator.Factory diagnosticMessageGeneratorFactory) {
        this.messager = messager;
        this.diagnosticMessageGeneratorFactory = diagnosticMessageGeneratorFactory;
    }

    DiagnosticReporterImpl reporter(BindingGraph graph, String pluginName) {
        return new DiagnosticReporterImpl(graph, pluginName, false);
    }

    DiagnosticReporterImpl reporterWithErrorAsWarnings(BindingGraph graph, String pluginName) {
        return new DiagnosticReporterImpl(graph, pluginName, true);
    }

    final class DiagnosticReporterImpl
    extends DiagnosticReporter {
        private final String plugin;
        private final XTypeElement rootComponent;
        private final boolean reportErrorsAsWarnings;
        private final ImmutableSet.Builder<Diagnostic.Kind> reportedDiagnosticKinds = ImmutableSet.builder();
        private final DiagnosticMessageGenerator diagnosticMessageGenerator;

        DiagnosticReporterImpl(BindingGraph graph, String plugin, boolean reportErrorsAsWarnings) {
            this.plugin = plugin;
            this.reportErrorsAsWarnings = reportErrorsAsWarnings;
            this.rootComponent = graph.rootComponentNode().componentPath().currentComponent().xprocessing();
            this.diagnosticMessageGenerator = DiagnosticReporterFactory.this.diagnosticMessageGeneratorFactory.create(graph);
        }

        ImmutableSet<Diagnostic.Kind> reportedDiagnosticKinds() {
            return this.reportedDiagnosticKinds.build();
        }

        @Override
        public void reportComponent(Diagnostic.Kind diagnosticKind, BindingGraph.ComponentNode componentNode, String messageFormat) {
            StringBuilder message = new StringBuilder(messageFormat);
            this.diagnosticMessageGenerator.appendComponentPathUnlessAtRoot(message, componentNode);
            this.printMessage(diagnosticKind, message, (XElement)this.rootComponent);
        }

        @Override
        public void reportBinding(Diagnostic.Kind diagnosticKind, BindingGraph.MaybeBinding binding, String message) {
            this.printMessage(diagnosticKind, message + this.diagnosticMessageGenerator.getMessage(binding), (XElement)this.rootComponent);
        }

        @Override
        public void reportDependency(Diagnostic.Kind diagnosticKind, BindingGraph.DependencyEdge dependencyEdge, String message) {
            this.printMessage(diagnosticKind, message + this.diagnosticMessageGenerator.getMessage(dependencyEdge), (XElement)this.rootComponent);
        }

        @Override
        public void reportSubcomponentFactoryMethod(Diagnostic.Kind diagnosticKind, BindingGraph.ChildFactoryMethodEdge childFactoryMethodEdge, String message) {
            this.printMessage(diagnosticKind, message, (XElement)childFactoryMethodEdge.factoryMethod().xprocessing());
        }

        private void printMessage(Diagnostic.Kind diagnosticKind, CharSequence message, @NullableDecl XElement elementToReport) {
            if (diagnosticKind.equals((Object)Diagnostic.Kind.ERROR) && this.reportErrorsAsWarnings) {
                diagnosticKind = Diagnostic.Kind.WARNING;
            }
            this.reportedDiagnosticKinds.add((Object)diagnosticKind);
            StringBuilder fullMessage = new StringBuilder();
            this.appendBracketPrefix(fullMessage, this.plugin);
            if (elementToReport == null) {
                DiagnosticReporterFactory.this.messager.printMessage(diagnosticKind, fullMessage.append(message).toString());
            } else {
                if (!XElements.transitivelyEncloses((XElement)this.rootComponent, elementToReport)) {
                    this.appendBracketPrefix(fullMessage, ElementFormatter.elementToString(elementToReport));
                    elementToReport = this.rootComponent;
                }
                DiagnosticReporterFactory.this.messager.printMessage(diagnosticKind, fullMessage.append(message).toString(), elementToReport);
            }
        }

        private void appendBracketPrefix(StringBuilder message, String prefix) {
            message.append(String.format("[%s] ", prefix));
        }
    }
}

