/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.base.ClearableCache;
import dagger.internal.codegen.base.DaggerSuperficialValidation;
import dagger.internal.codegen.base.Util;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.binding.MethodSignatureFormatter;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.model.Scope;
import dagger.internal.codegen.validation.DependencyRequestValidator;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XMethodElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotated;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.shaded.androidx.room.compiler.processing.XConstructorElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XExecutableParameterElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XFieldElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XVariableElement;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.tools.Diagnostic;

@Singleton
public final class InjectValidator
implements ClearableCache {
    private final XProcessingEnv processingEnv;
    private final CompilerOptions compilerOptions;
    private final DependencyRequestValidator dependencyRequestValidator;
    private final Optional<Diagnostic.Kind> privateAndStaticInjectionDiagnosticKind;
    private final InjectionAnnotations injectionAnnotations;
    private final DaggerSuperficialValidation superficialValidation;
    private final Map<XTypeElement, ValidationReport> provisionReports = new HashMap<XTypeElement, ValidationReport>();
    private final Map<XTypeElement, ValidationReport> membersInjectionReports = new HashMap<XTypeElement, ValidationReport>();
    private final MethodSignatureFormatter methodSignatureFormatter;

    @Inject
    InjectValidator(XProcessingEnv processingEnv, DependencyRequestValidator dependencyRequestValidator, CompilerOptions compilerOptions, InjectionAnnotations injectionAnnotations, DaggerSuperficialValidation superficialValidation, MethodSignatureFormatter methodSignatureFormatter) {
        this(processingEnv, compilerOptions, dependencyRequestValidator, Optional.empty(), injectionAnnotations, superficialValidation, methodSignatureFormatter);
    }

    private InjectValidator(XProcessingEnv processingEnv, CompilerOptions compilerOptions, DependencyRequestValidator dependencyRequestValidator, Optional<Diagnostic.Kind> privateAndStaticInjectionDiagnosticKind, InjectionAnnotations injectionAnnotations, DaggerSuperficialValidation superficialValidation, MethodSignatureFormatter methodSignatureFormatter) {
        this.processingEnv = processingEnv;
        this.compilerOptions = compilerOptions;
        this.dependencyRequestValidator = dependencyRequestValidator;
        this.privateAndStaticInjectionDiagnosticKind = privateAndStaticInjectionDiagnosticKind;
        this.injectionAnnotations = injectionAnnotations;
        this.superficialValidation = superficialValidation;
        this.methodSignatureFormatter = methodSignatureFormatter;
    }

    @Override
    public void clearCache() {
        this.provisionReports.clear();
        this.membersInjectionReports.clear();
    }

    public InjectValidator whenGeneratingCode() {
        return this.compilerOptions.ignorePrivateAndStaticInjectionForComponent() ? this : new InjectValidator(this.processingEnv, this.compilerOptions, this.dependencyRequestValidator, Optional.of(Diagnostic.Kind.ERROR), this.injectionAnnotations, this.superficialValidation, this.methodSignatureFormatter);
    }

    public ValidationReport validate(XTypeElement typeElement) {
        return Util.reentrantComputeIfAbsent(this.provisionReports, typeElement, this::validateUncached);
    }

    private ValidationReport validateUncached(XTypeElement typeElement) {
        ValidationReport.Builder builder = ValidationReport.about((XElement)typeElement);
        builder.addSubreport(this.validateForMembersInjectionInternal(typeElement));
        ImmutableSet injectConstructors = ImmutableSet.builder().addAll(InjectionAnnotations.injectedConstructors(typeElement)).addAll(AssistedInjectionAnnotations.assistedInjectedConstructors(typeElement)).build();
        switch (injectConstructors.size()) {
            case 0: {
                break;
            }
            case 1: {
                builder.addSubreport(this.validateConstructor((XConstructorElement)Iterables.getOnlyElement((Iterable)injectConstructors)));
                break;
            }
            default: {
                Object[] objectArray = new Object[2];
                objectArray[0] = typeElement.getQualifiedName();
                objectArray[1] = injectConstructors.stream().map(this.methodSignatureFormatter::format).collect(DaggerStreams.toImmutableList());
                builder.addError(String.format("Type %s may only contain one injected constructor. Found: %s", objectArray), (XElement)typeElement);
            }
        }
        return builder.build();
    }

    private ValidationReport validateConstructor(XConstructorElement constructorElement) {
        ValidationReport.Builder builder;
        block13: {
            ImmutableSet<Scope> scopes;
            XTypeElement enclosingElement;
            block12: {
                this.superficialValidation.validateTypeOf((XElement)constructorElement);
                builder = ValidationReport.about((XElement)constructorElement.getEnclosingElement());
                if (InjectionAnnotations.hasInjectAnnotation((XElement)constructorElement) && constructorElement.hasAnnotation(TypeNames.ASSISTED_INJECT)) {
                    builder.addError("Constructors cannot be annotated with both @Inject and @AssistedInject");
                }
                ClassName injectAnnotation = XElements.getAnyAnnotation((XAnnotated)constructorElement, TypeNames.INJECT, TypeNames.INJECT_JAVAX, TypeNames.ASSISTED_INJECT).map(XAnnotations::getClassName).get();
                if (constructorElement.isPrivate()) {
                    builder.addError("Dagger does not support injection into private constructors", (XElement)constructorElement);
                }
                if (!this.processedInPreviousRoundOrCompilationUnit(constructorElement)) {
                    this.superficialValidation.validateAnnotationsOf((XElement)constructorElement);
                    for (XAnnotation qualifier : this.injectionAnnotations.getQualifiers((XElement)constructorElement)) {
                        builder.addError(String.format("@Qualifier annotations are not allowed on @%s constructors", injectAnnotation.simpleName()), (XElement)constructorElement, qualifier);
                    }
                    Object scopeErrorMsg = String.format("@Scope annotations are not allowed on @%s constructors", injectAnnotation.simpleName());
                    if (injectAnnotation.equals((Object)TypeNames.INJECT) || injectAnnotation.equals((Object)TypeNames.INJECT_JAVAX)) {
                        scopeErrorMsg = (String)scopeErrorMsg + "; annotate the class instead";
                    }
                    for (Scope scope : this.injectionAnnotations.getScopes((XElement)constructorElement)) {
                        builder.addError((String)scopeErrorMsg, (XElement)constructorElement, scope.scopeAnnotation().xprocessing());
                    }
                }
                for (XExecutableParameterElement parameter : constructorElement.getParameters()) {
                    this.superficialValidation.validateTypeOf((XElement)parameter);
                    this.validateDependencyRequest(builder, (XVariableElement)parameter);
                }
                if (this.throwsCheckedExceptions(constructorElement)) {
                    builder.addItem(String.format("Dagger does not support checked exceptions on @%s constructors", injectAnnotation.simpleName()), this.privateMemberDiagnosticKind(), (XElement)constructorElement);
                }
                this.checkInjectIntoPrivateClass((XElement)constructorElement, builder);
                enclosingElement = constructorElement.getEnclosingElement();
                if (enclosingElement.isAbstract()) {
                    builder.addError(String.format("@%s is nonsense on the constructor of an abstract class", injectAnnotation.simpleName()), (XElement)constructorElement);
                }
                if (enclosingElement.isNested() && !enclosingElement.isStatic()) {
                    builder.addError(String.format("@%s constructors are invalid on inner classes. Did you mean to make the class static?", injectAnnotation.simpleName()), (XElement)constructorElement);
                }
                scopes = this.injectionAnnotations.getScopes((XElement)constructorElement.getEnclosingElement());
                if (!injectAnnotation.equals((Object)TypeNames.ASSISTED_INJECT)) break block12;
                for (Scope scope : scopes) {
                    builder.addError("A type with an @AssistedInject-annotated constructor cannot be scoped", (XElement)enclosingElement, scope.scopeAnnotation().xprocessing());
                }
                break block13;
            }
            if (scopes.size() <= 1) break block13;
            for (Scope scope : scopes) {
                builder.addError("A single binding may not declare more than one @Scope", (XElement)enclosingElement, scope.scopeAnnotation().xprocessing());
            }
        }
        return builder.build();
    }

    private ValidationReport validateField(XFieldElement fieldElement) {
        this.superficialValidation.validateTypeOf((XElement)fieldElement);
        ValidationReport.Builder builder = ValidationReport.about((XElement)fieldElement);
        if (fieldElement.isFinal()) {
            builder.addError("@Inject fields may not be final", (XElement)fieldElement);
        }
        if (fieldElement.isPrivate()) {
            builder.addItem("Dagger does not support injection into private fields", this.privateMemberDiagnosticKind(), (XElement)fieldElement);
        }
        if (fieldElement.isStatic()) {
            builder.addItem("Dagger does not support injection into static fields", this.staticMemberDiagnosticKind(), (XElement)fieldElement);
        }
        this.validateDependencyRequest(builder, (XVariableElement)fieldElement);
        return builder.build();
    }

    private ValidationReport validateMethod(XMethodElement methodElement) {
        this.superficialValidation.validateTypeOf((XElement)methodElement);
        ValidationReport.Builder builder = ValidationReport.about((XElement)methodElement);
        if (methodElement.isAbstract()) {
            builder.addError("Methods with @Inject may not be abstract", (XElement)methodElement);
        }
        if (methodElement.isPrivate()) {
            builder.addItem("Dagger does not support injection into private methods", this.privateMemberDiagnosticKind(), (XElement)methodElement);
        }
        if (methodElement.isStatic()) {
            builder.addItem("Dagger does not support injection into static methods", this.staticMemberDiagnosticKind(), (XElement)methodElement);
        }
        if (XMethodElements.hasTypeParameters(methodElement)) {
            builder.addError("Methods with @Inject may not declare type parameters", (XElement)methodElement);
        }
        if (!methodElement.getThrownTypes().isEmpty()) {
            builder.addError("Methods with @Inject may not throw checked exceptions. Please wrap your exceptions in a RuntimeException instead.", (XElement)methodElement);
        }
        for (XExecutableParameterElement parameter : methodElement.getParameters()) {
            this.superficialValidation.validateTypeOf((XElement)parameter);
            this.validateDependencyRequest(builder, (XVariableElement)parameter);
        }
        return builder.build();
    }

    private void validateDependencyRequest(ValidationReport.Builder builder, XVariableElement parameter) {
        this.dependencyRequestValidator.validateDependencyRequest(builder, (XElement)parameter, parameter.getType());
        this.dependencyRequestValidator.checkNotProducer(builder, parameter);
    }

    public ValidationReport validateForMembersInjection(XTypeElement typeElement) {
        return !this.processedInPreviousRoundOrCompilationUnit(typeElement) ? this.validate(typeElement) : this.validateForMembersInjectionInternal(typeElement);
    }

    private ValidationReport validateForMembersInjectionInternal(XTypeElement typeElement) {
        return Util.reentrantComputeIfAbsent(this.membersInjectionReports, typeElement, this::validateForMembersInjectionInternalUncached);
    }

    private ValidationReport validateForMembersInjectionInternalUncached(XTypeElement typeElement) {
        ValidationReport report;
        this.superficialValidation.validateTypeOf((XElement)typeElement);
        ValidationReport.Builder builder = ValidationReport.about((XElement)typeElement);
        boolean hasInjectedMembers = false;
        for (XFieldElement field : typeElement.getDeclaredFields()) {
            if (!InjectionAnnotations.hasInjectAnnotation((XElement)field)) continue;
            hasInjectedMembers = true;
            report = this.validateField(field);
            if (report.isClean()) continue;
            builder.addSubreport(report);
        }
        for (XMethodElement method : typeElement.getDeclaredMethods()) {
            if (!InjectionAnnotations.hasInjectAnnotation((XElement)method)) continue;
            hasInjectedMembers = true;
            report = this.validateMethod(method);
            if (report.isClean()) continue;
            builder.addSubreport(report);
        }
        if (hasInjectedMembers) {
            this.checkInjectIntoPrivateClass((XElement)typeElement, builder);
            this.checkInjectIntoKotlinObject(typeElement, builder);
        }
        Optional.ofNullable(typeElement.getSuperType()).filter(supertype -> !supertype.getTypeName().equals((Object)TypeName.OBJECT)).ifPresent(supertype -> {
            this.superficialValidation.validateSuperTypeOf(typeElement);
            ValidationReport report = this.validateForMembersInjection(supertype.getTypeElement());
            if (!report.isClean()) {
                builder.addSubreport(report);
            }
        });
        return builder.build();
    }

    private boolean throwsCheckedExceptions(XConstructorElement constructorElement) {
        XType runtimeException = this.processingEnv.findType((TypeName)TypeNames.RUNTIME_EXCEPTION);
        XType error = this.processingEnv.findType((TypeName)TypeNames.ERROR);
        this.superficialValidation.validateThrownTypesOf((XExecutableElement)constructorElement);
        return !constructorElement.getThrownTypes().stream().allMatch(type -> XTypes.isSubtype(type, runtimeException) || XTypes.isSubtype(type, error));
    }

    private void checkInjectIntoPrivateClass(XElement element, ValidationReport.Builder builder) {
        if (!Accessibility.isElementAccessibleFromOwnPackage((XElement)XElements.closestEnclosingTypeElement(element))) {
            builder.addItem("Dagger does not support injection into private classes", this.privateMemberDiagnosticKind(), element);
        }
    }

    private void checkInjectIntoKotlinObject(XTypeElement element, ValidationReport.Builder builder) {
        if (element.isKotlinObject() || element.isCompanionObject()) {
            builder.addError("Dagger does not support injection into Kotlin objects", (XElement)element);
        }
    }

    private Diagnostic.Kind privateMemberDiagnosticKind() {
        return this.privateAndStaticInjectionDiagnosticKind.orElse(this.compilerOptions.privateMemberValidationKind());
    }

    private Diagnostic.Kind staticMemberDiagnosticKind() {
        return this.privateAndStaticInjectionDiagnosticKind.orElse(this.compilerOptions.staticMemberValidationKind());
    }

    private boolean processedInPreviousRoundOrCompilationUnit(XConstructorElement injectConstructor) {
        return this.processingEnv.findTypeElement((TypeName)SourceFiles.factoryNameForElement((XExecutableElement)injectConstructor)) != null;
    }

    private boolean processedInPreviousRoundOrCompilationUnit(XTypeElement membersInjectedType) {
        return this.processingEnv.findTypeElement((TypeName)SourceFiles.membersInjectorNameForType(membersInjectedType)) != null;
    }
}

