/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.javapoet;

import com.squareup.javapoet.CodeBlock;
import dagger.internal.codegen.javapoet.ExpressionType;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.shaded.androidx.room.compiler.processing.XRawType;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;

public final class Expression {
    private final ExpressionType type;
    private final CodeBlock codeBlock;

    private Expression(ExpressionType type, CodeBlock codeBlock) {
        this.type = type;
        this.codeBlock = codeBlock;
    }

    public static Expression create(XType type, CodeBlock expression) {
        return new Expression(ExpressionType.create(type), expression);
    }

    public static Expression create(ExpressionType type, CodeBlock expression) {
        return new Expression(type, expression);
    }

    public static Expression create(XType type, String format, Object ... args) {
        return Expression.create(type, CodeBlock.of((String)format, (Object[])args));
    }

    public Expression castTo(XType newType) {
        return Expression.create(newType, CodeBlock.of((String)"($T) $L", (Object[])new Object[]{newType.getTypeName(), this.codeBlock}));
    }

    public Expression castTo(XRawType newRawType) {
        return Expression.create(ExpressionType.create(newRawType, this.type.getProcessingEnv()), CodeBlock.of((String)"($T) $L", (Object[])new Object[]{newRawType.getTypeName(), this.codeBlock}));
    }

    public Expression box() {
        return this.type.asType().isPresent() && XTypes.isPrimitive((XType)this.type.asType().get()) ? this.castTo(this.type.asType().get().boxed()) : this;
    }

    public ExpressionType type() {
        return this.type;
    }

    public CodeBlock codeBlock() {
        return this.codeBlock;
    }

    public String toString() {
        return String.format("[%s] %s", this.type.getTypeName(), this.codeBlock);
    }
}

