/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.base.ContributionType;
import dagger.internal.codegen.extension.DaggerCollectors;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XProcessingEnvs;
import dagger.internal.codegen.xprocessing.XTypeElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.Collection;
import javax.inject.Inject;

public final class BindsTypeChecker {
    private final XProcessingEnv processingEnv;

    @Inject
    BindsTypeChecker(XProcessingEnv processingEnv) {
        this.processingEnv = processingEnv;
    }

    public boolean isAssignable(XType rightHandSide, XType leftHandSide, ContributionType contributionType) {
        return XTypes.isAssignableTo((XType)rightHandSide, (XType)this.desiredAssignableType(leftHandSide, contributionType));
    }

    private XType desiredAssignableType(XType leftHandSide, ContributionType contributionType) {
        switch (contributionType) {
            case UNIQUE: {
                return leftHandSide;
            }
            case SET: {
                XType parameterizedSetType = this.processingEnv.getDeclaredType(this.setElement(), new XType[]{leftHandSide});
                return this.methodParameterType(parameterizedSetType, "add");
            }
            case SET_VALUES: {
                return this.methodParameterType(leftHandSide, "addAll");
            }
            case MAP: {
                XType parameterizedMapType = this.processingEnv.getDeclaredType(this.mapElement(), new XType[]{this.unboundedWildcard(), leftHandSide});
                return (XType)this.methodParameterTypes(parameterizedMapType, "put").get(1);
            }
        }
        throw new AssertionError((Object)("Unknown contribution type: " + (Object)((Object)contributionType)));
    }

    private ImmutableList<XType> methodParameterTypes(XType type, String methodName) {
        return ImmutableList.copyOf((Collection)((XMethodElement)XTypeElements.getAllMethods((XTypeElement)type.getTypeElement()).stream().filter(method -> methodName.contentEquals(XElements.getSimpleName((XElement)method))).collect(DaggerCollectors.onlyElement())).asMemberOf(type).getParameterTypes());
    }

    private XType methodParameterType(XType type, String methodName) {
        return (XType)Iterables.getOnlyElement(this.methodParameterTypes(type, methodName));
    }

    private XTypeElement setElement() {
        return this.processingEnv.requireTypeElement((TypeName)TypeNames.SET);
    }

    private XTypeElement mapElement() {
        return this.processingEnv.requireTypeElement((TypeName)TypeNames.MAP);
    }

    private XType unboundedWildcard() {
        return XProcessingEnvs.getUnboundedWildcardType((XProcessingEnv)this.processingEnv);
    }
}

