/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import dagger.Module;
import dagger.Provides;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.binding.ProductionBinding;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.writing.FactoryGenerator;
import dagger.internal.codegen.writing.HjarSourceFileGenerator;
import dagger.internal.codegen.writing.MembersInjectorGenerator;
import dagger.internal.codegen.writing.ModuleGenerator;
import dagger.internal.codegen.writing.ModuleProxies;
import dagger.internal.codegen.writing.ProducerFactoryGenerator;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;

@Module
abstract class SourceFileGeneratorsModule {
    SourceFileGeneratorsModule() {
    }

    @Provides
    static SourceFileGenerator<ProvisionBinding> factoryGenerator(FactoryGenerator generator, CompilerOptions compilerOptions) {
        return SourceFileGeneratorsModule.hjarWrapper(generator, compilerOptions);
    }

    @Provides
    static SourceFileGenerator<ProductionBinding> producerFactoryGenerator(ProducerFactoryGenerator generator, CompilerOptions compilerOptions) {
        return SourceFileGeneratorsModule.hjarWrapper(generator, compilerOptions);
    }

    @Provides
    static SourceFileGenerator<MembersInjectionBinding> membersInjectorGenerator(MembersInjectorGenerator generator, CompilerOptions compilerOptions) {
        return SourceFileGeneratorsModule.hjarWrapper(generator, compilerOptions);
    }

    @Provides
    @ModuleGenerator
    static SourceFileGenerator<XTypeElement> moduleConstructorProxyGenerator(ModuleProxies.ModuleConstructorProxyGenerator generator, CompilerOptions compilerOptions) {
        return SourceFileGeneratorsModule.hjarWrapper(generator, compilerOptions);
    }

    private static <T> SourceFileGenerator<T> hjarWrapper(SourceFileGenerator<T> generator, CompilerOptions compilerOptions) {
        return compilerOptions.headerCompilation() ? HjarSourceFileGenerator.wrap(generator) : generator;
    }
}

