/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.bindinggraphvalidation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.FormatMethod;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.base.ElementFormatter;
import dagger.internal.codegen.bindinggraphvalidation.PackageNameCompressor;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.validation.DiagnosticMessageGenerator;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.model.BindingGraph;
import dagger.spi.model.BindingGraphPlugin;
import dagger.spi.model.DaggerProcessingEnv;
import dagger.spi.model.DiagnosticReporter;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.tools.Diagnostic;

final class CompositeBindingGraphPlugin
implements BindingGraphPlugin {
    private final ImmutableSet<BindingGraphPlugin> plugins;
    private final DiagnosticMessageGenerator.Factory messageGeneratorFactory;

    @AssistedInject
    CompositeBindingGraphPlugin(@Assisted ImmutableSet<BindingGraphPlugin> plugins, DiagnosticMessageGenerator.Factory messageGeneratorFactory) {
        this.plugins = plugins;
        this.messageGeneratorFactory = messageGeneratorFactory;
    }

    public void visitGraph(BindingGraph bindingGraph, DiagnosticReporter diagnosticReporter) {
        AggregatingDiagnosticReporter aggregatingDiagnosticReporter = new AggregatingDiagnosticReporter(bindingGraph, diagnosticReporter, this.messageGeneratorFactory.create(bindingGraph));
        this.plugins.forEach(plugin -> {
            aggregatingDiagnosticReporter.setCurrentPlugin(plugin.pluginName());
            plugin.visitGraph(bindingGraph, (DiagnosticReporter)aggregatingDiagnosticReporter);
        });
        aggregatingDiagnosticReporter.report();
    }

    public void init(DaggerProcessingEnv processingEnv, Map<String, String> options) {
        this.plugins.forEach(plugin -> plugin.init(processingEnv, options));
    }

    public void onPluginEnd() {
        this.plugins.forEach(BindingGraphPlugin::onPluginEnd);
    }

    public Set<String> supportedOptions() {
        return (Set)this.plugins.stream().flatMap(plugin -> plugin.supportedOptions().stream()).collect(DaggerStreams.toImmutableSet());
    }

    public String pluginName() {
        return "Dagger/Validation";
    }

    private static final class AggregatingDiagnosticReporter
    implements DiagnosticReporter {
        private final DiagnosticReporter delegate;
        private final BindingGraph graph;
        private final StringBuilder messageBuilder = new StringBuilder("\n");
        private final DiagnosticMessageGenerator messageGenerator;
        private Optional<Diagnostic.Kind> mergedDiagnosticKind = Optional.empty();
        private String currentPluginName = null;

        AggregatingDiagnosticReporter(BindingGraph graph, DiagnosticReporter delegate, DiagnosticMessageGenerator messageGenerator) {
            this.graph = graph;
            this.delegate = delegate;
            this.messageGenerator = messageGenerator;
        }

        void setCurrentPlugin(String pluginName) {
            this.currentPluginName = pluginName;
        }

        void report() {
            if (this.mergedDiagnosticKind.isPresent()) {
                this.delegate.reportComponent(this.mergedDiagnosticKind.get(), this.graph.rootComponentNode(), PackageNameCompressor.compressPackagesInMessage(this.messageBuilder.toString()));
            }
        }

        public void reportComponent(Diagnostic.Kind diagnosticKind, BindingGraph.ComponentNode componentNode, String message) {
            this.addMessage(diagnosticKind, message);
            this.messageGenerator.appendComponentPathUnlessAtRoot(this.messageBuilder, (BindingGraph.Node)componentNode);
        }

        @FormatMethod
        public void reportComponent(Diagnostic.Kind diagnosticKind, BindingGraph.ComponentNode componentNode, String messageFormat, Object firstArg, Object ... moreArgs) {
            this.reportComponent(diagnosticKind, componentNode, AggregatingDiagnosticReporter.formatMessage(messageFormat, firstArg, moreArgs));
        }

        public void reportBinding(Diagnostic.Kind diagnosticKind, BindingGraph.MaybeBinding binding, String message) {
            this.addMessage(diagnosticKind, String.format("%s%s", message, this.messageGenerator.getMessage(binding)));
        }

        @FormatMethod
        public void reportBinding(Diagnostic.Kind diagnosticKind, BindingGraph.MaybeBinding binding, String messageFormat, Object firstArg, Object ... moreArgs) {
            this.reportBinding(diagnosticKind, binding, AggregatingDiagnosticReporter.formatMessage(messageFormat, firstArg, moreArgs));
        }

        public void reportDependency(Diagnostic.Kind diagnosticKind, BindingGraph.DependencyEdge dependencyEdge, String message) {
            this.addMessage(diagnosticKind, String.format("%s%s", message, this.messageGenerator.getMessage(dependencyEdge)));
        }

        @FormatMethod
        public void reportDependency(Diagnostic.Kind diagnosticKind, BindingGraph.DependencyEdge dependencyEdge, String messageFormat, Object firstArg, Object ... moreArgs) {
            this.reportDependency(diagnosticKind, dependencyEdge, AggregatingDiagnosticReporter.formatMessage(messageFormat, firstArg, moreArgs));
        }

        public void reportSubcomponentFactoryMethod(Diagnostic.Kind diagnosticKind, BindingGraph.ChildFactoryMethodEdge childFactoryMethodEdge, String message) {
            if (XElements.transitivelyEncloses((XElement)this.graph.rootComponentNode().componentPath().currentComponent().xprocessing(), (XElement)childFactoryMethodEdge.factoryMethod().xprocessing())) {
                this.delegate.reportSubcomponentFactoryMethod(diagnosticKind, childFactoryMethodEdge, message);
            } else {
                this.addMessage(diagnosticKind, String.format("[%s] %s", ElementFormatter.elementToString((XElement)childFactoryMethodEdge.factoryMethod().xprocessing()), message));
            }
        }

        @FormatMethod
        public void reportSubcomponentFactoryMethod(Diagnostic.Kind diagnosticKind, BindingGraph.ChildFactoryMethodEdge childFactoryMethodEdge, String messageFormat, Object firstArg, Object ... moreArgs) {
            this.reportSubcomponentFactoryMethod(diagnosticKind, childFactoryMethodEdge, AggregatingDiagnosticReporter.formatMessage(messageFormat, firstArg, moreArgs));
        }

        private void addMessage(Diagnostic.Kind diagnosticKind, String message) {
            Preconditions.checkNotNull((Object)((Object)diagnosticKind));
            Preconditions.checkNotNull((Object)message);
            Preconditions.checkState((this.currentPluginName != null ? 1 : 0) != 0);
            if (this.mergedDiagnosticKind.isPresent()) {
                this.messageBuilder.append("\n\n");
            }
            this.mergeDiagnosticKind(diagnosticKind);
            this.messageBuilder.append(String.format("\u001b[1;31m[%s]\u001b[0m ", this.currentPluginName));
            this.messageBuilder.append(message);
        }

        private static String formatMessage(String messageFormat, Object firstArg, Object[] moreArgs) {
            return String.format(messageFormat, Lists.asList((Object)firstArg, (Object[])moreArgs).toArray());
        }

        private void mergeDiagnosticKind(Diagnostic.Kind diagnosticKind) {
            Preconditions.checkArgument((diagnosticKind != Diagnostic.Kind.MANDATORY_WARNING ? 1 : 0) != 0, (Object)"Dagger plugins should not be issuing mandatory warnings");
            if (!this.mergedDiagnosticKind.isPresent()) {
                this.mergedDiagnosticKind = Optional.of(diagnosticKind);
                return;
            }
            Diagnostic.Kind current = this.mergedDiagnosticKind.get();
            this.mergedDiagnosticKind = current == Diagnostic.Kind.ERROR || diagnosticKind == Diagnostic.Kind.ERROR ? Optional.of(Diagnostic.Kind.ERROR) : (current == Diagnostic.Kind.WARNING || diagnosticKind == Diagnostic.Kind.WARNING ? Optional.of(Diagnostic.Kind.WARNING) : (current == Diagnostic.Kind.NOTE || diagnosticKind == Diagnostic.Kind.NOTE ? Optional.of(Diagnostic.Kind.NOTE) : Optional.of(Diagnostic.Kind.OTHER)));
        }
    }

    @AssistedFactory
    static interface Factory {
        public CompositeBindingGraphPlugin create(ImmutableSet<BindingGraphPlugin> var1);
    }
}

