/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.kotlin;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.kotlin.KotlinMetadata;
import dagger.internal.codegen.kotlin.KotlinMetadataFactory;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XFieldElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.Optional;
import javax.inject.Inject;

public final class KotlinMetadataUtil {
    private final KotlinMetadataFactory metadataFactory;

    @Inject
    KotlinMetadataUtil(KotlinMetadataFactory metadataFactory) {
        this.metadataFactory = metadataFactory;
    }

    public boolean hasMetadata(XElement element) {
        return XElements.closestEnclosingTypeElement((XElement)element).hasAnnotation(TypeNames.KOTLIN_METADATA);
    }

    public ImmutableSet<XAnnotation> getSyntheticPropertyAnnotations(XFieldElement fieldElement, ClassName annotationType) {
        return this.metadataFactory.create((XElement)fieldElement).getSyntheticAnnotationMethod(fieldElement).map(methodElement -> methodElement.getAnnotationsAnnotatedWith(annotationType)).map(ImmutableSet::copyOf).orElse(ImmutableSet.of());
    }

    public boolean isMissingSyntheticPropertyForAnnotations(XFieldElement fieldElement) {
        return this.metadataFactory.create((XElement)fieldElement).isMissingSyntheticAnnotationMethod(fieldElement);
    }

    public Optional<XMethodElement> getPropertyGetter(XFieldElement fieldElement) {
        return this.metadataFactory.create((XElement)fieldElement).getPropertyGetter(fieldElement);
    }

    public ImmutableMap<String, String> getAllMethodNamesBySignature(XTypeElement element) {
        Preconditions.checkState((boolean)this.hasMetadata((XElement)element), (Object)"Can not call getAllMethodNamesBySignature for non-Kotlin class");
        return (ImmutableMap)this.metadataFactory.create((XElement)element).classMetadata().functionsBySignature().values().stream().collect(DaggerStreams.toImmutableMap(KotlinMetadata.FunctionMetadata::signature, KotlinMetadata.BaseMetadata::name));
    }
}

