/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.auto.service.AutoService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.DelegateComponentProcessor;
import dagger.internal.codegen.ServiceLoaders;
import dagger.internal.codegen.compileroption.ProcessingEnvironmentCompilerOptions;
import dagger.spi.BindingGraphPlugin;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingStep;
import dagger.spi.shaded.androidx.room.compiler.processing.XRoundEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.javac.JavacBasicAnnotationProcessor;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.processing.Processor;
import javax.lang.model.SourceVersion;

@AutoService(value={Processor.class})
public final class ComponentProcessor
extends JavacBasicAnnotationProcessor {
    private final DelegateComponentProcessor delegate = new DelegateComponentProcessor();
    private final Optional<ImmutableSet<BindingGraphPlugin>> testingPlugins;

    @VisibleForTesting
    public static ComponentProcessor forTesting(BindingGraphPlugin ... testingPlugins) {
        return ComponentProcessor.forTesting(Arrays.asList(testingPlugins));
    }

    @VisibleForTesting
    public static ComponentProcessor forTesting(Iterable<BindingGraphPlugin> testingPlugins) {
        return new ComponentProcessor(Optional.of(ImmutableSet.copyOf(testingPlugins)));
    }

    public ComponentProcessor() {
        this(Optional.empty());
    }

    private ComponentProcessor(Optional<ImmutableSet<BindingGraphPlugin>> testingPlugins) {
        super(options -> DelegateComponentProcessor.PROCESSING_ENV_CONFIG);
        this.testingPlugins = testingPlugins;
    }

    public void initialize(XProcessingEnv env) {
        this.delegate.initialize(env, (ImmutableSet<BindingGraphPlugin>)this.testingPlugins.orElseGet(() -> ComponentProcessor.loadExternalPlugins(env)));
    }

    private static ImmutableSet<BindingGraphPlugin> loadExternalPlugins(XProcessingEnv env) {
        return ServiceLoaders.loadServices(env, BindingGraphPlugin.class);
    }

    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    public ImmutableSet<String> getSupportedOptions() {
        return ImmutableSet.builder().addAll(ProcessingEnvironmentCompilerOptions.supportedOptions()).addAll(this.delegate.validationBindingGraphPlugins.allSupportedOptions()).addAll(this.delegate.externalBindingGraphPlugins.allSupportedOptions()).build();
    }

    public Iterable<XProcessingStep> processingSteps() {
        return this.delegate.processingSteps();
    }

    public void postRound(XProcessingEnv env, XRoundEnv roundEnv) {
        this.delegate.postRound(env, roundEnv);
    }
}

