/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.MapBuilder;
import dagger.internal.codegen.base.MapType;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.MapKeys;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ComponentRequestRepresentations;
import dagger.internal.codegen.writing.RequestRepresentation;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.model.BindingKind;
import dagger.spi.model.DependencyRequest;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import java.util.Collections;

final class MapRequestRepresentation
extends RequestRepresentation {
    private static final int MAX_IMMUTABLE_MAP_OF_KEY_VALUE_PAIRS = 5;
    private final XProcessingEnv processingEnv;
    private final ProvisionBinding binding;
    private final ImmutableMap<DependencyRequest, ContributionBinding> dependencies;
    private final ComponentRequestRepresentations componentRequestRepresentations;
    private final boolean isExperimentalMergedMode;

    @AssistedInject
    MapRequestRepresentation(@Assisted ProvisionBinding binding, XProcessingEnv processingEnv, BindingGraph graph, ComponentImplementation componentImplementation, ComponentRequestRepresentations componentRequestRepresentations) {
        this.binding = binding;
        this.processingEnv = processingEnv;
        BindingKind bindingKind = this.binding.kind();
        Preconditions.checkArgument((boolean)bindingKind.equals((Object)BindingKind.MULTIBOUND_MAP), (Object)bindingKind);
        this.componentRequestRepresentations = componentRequestRepresentations;
        this.dependencies = Maps.toMap(binding.dependencies(), dep -> graph.contributionBinding(dep.key()));
        this.isExperimentalMergedMode = componentImplementation.compilerMode().isExperimentalMergedMode();
    }

    @Override
    Expression getDependencyExpression(ClassName requestingClass) {
        boolean isImmutableMapAvailable = this.isImmutableMapAvailable();
        if (isImmutableMapAvailable && this.dependencies.size() <= 5) {
            return Expression.create(this.immutableMapType(), CodeBlock.builder().add("$T.", new Object[]{ImmutableMap.class}).add(this.maybeTypeParameters(requestingClass)).add("of($L)", new Object[]{this.dependencies.keySet().stream().map(dependency -> this.keyAndValueExpression((DependencyRequest)dependency, requestingClass)).collect(CodeBlocks.toParametersCodeBlock())}).build());
        }
        switch (this.dependencies.size()) {
            case 0: {
                return this.collectionsStaticFactoryInvocation(requestingClass, CodeBlock.of((String)"emptyMap()", (Object[])new Object[0]));
            }
            case 1: {
                return this.collectionsStaticFactoryInvocation(requestingClass, CodeBlock.of((String)"singletonMap($L)", (Object[])new Object[]{this.keyAndValueExpression((DependencyRequest)Iterables.getOnlyElement((Iterable)this.dependencies.keySet()), requestingClass)}));
            }
        }
        CodeBlock.Builder instantiation = CodeBlock.builder();
        instantiation.add("$T.", new Object[]{isImmutableMapAvailable ? ImmutableMap.class : MapBuilder.class}).add(this.maybeTypeParameters(requestingClass));
        if (this.isImmutableMapBuilderWithExpectedSizeAvailable()) {
            instantiation.add("builderWithExpectedSize($L)", new Object[]{this.dependencies.size()});
        } else if (isImmutableMapAvailable) {
            instantiation.add("builder()", new Object[0]);
        } else {
            instantiation.add("newMapBuilder($L)", new Object[]{this.dependencies.size()});
        }
        for (DependencyRequest dependency2 : this.dependencies.keySet()) {
            instantiation.add(".put($L)", new Object[]{this.keyAndValueExpression(dependency2, requestingClass)});
        }
        return Expression.create(isImmutableMapAvailable ? this.immutableMapType() : this.binding.key().type().xprocessing(), instantiation.add(".build()", new Object[0]).build());
    }

    private XType immutableMapType() {
        MapType mapType = MapType.from(this.binding.key());
        return this.processingEnv.getDeclaredType(this.processingEnv.requireTypeElement((TypeName)TypeNames.IMMUTABLE_MAP), new XType[]{mapType.keyType(), mapType.valueType()});
    }

    private CodeBlock keyAndValueExpression(DependencyRequest dependency, ClassName requestingClass) {
        return CodeBlock.of((String)"$L, $L", (Object[])new Object[]{MapKeys.getMapKeyExpression((ContributionBinding)this.dependencies.get((Object)dependency), requestingClass, this.processingEnv), this.isExperimentalMergedMode ? this.componentRequestRepresentations.getExperimentalSwitchingProviderDependencyRepresentation(BindingRequest.bindingRequest(dependency)).getDependencyExpression(dependency.kind(), this.binding).codeBlock() : this.componentRequestRepresentations.getDependencyExpression(BindingRequest.bindingRequest(dependency), requestingClass).codeBlock()});
    }

    private Expression collectionsStaticFactoryInvocation(ClassName requestingClass, CodeBlock methodInvocation) {
        return Expression.create(this.binding.key().type().xprocessing(), CodeBlock.builder().add("$T.", new Object[]{Collections.class}).add(this.maybeTypeParameters(requestingClass)).add(methodInvocation).build());
    }

    private CodeBlock maybeTypeParameters(ClassName requestingClass) {
        XType bindingKeyType = this.binding.key().type().xprocessing();
        MapType mapType = MapType.from(this.binding.key());
        return Accessibility.isTypeAccessibleFrom(bindingKeyType, requestingClass.packageName()) ? CodeBlock.of((String)"<$T, $T>", (Object[])new Object[]{mapType.keyType().getTypeName(), mapType.valueType().getTypeName()}) : CodeBlock.of((String)"", (Object[])new Object[0]);
    }

    private boolean isImmutableMapBuilderWithExpectedSizeAvailable() {
        return this.isImmutableMapAvailable() && this.processingEnv.requireTypeElement((TypeName)TypeNames.IMMUTABLE_MAP).getDeclaredMethods().stream().anyMatch(method -> XElements.getSimpleName((XElement)method).contentEquals("builderWithExpectedSize"));
    }

    private boolean isImmutableMapAvailable() {
        return this.processingEnv.findTypeElement((TypeName)TypeNames.IMMUTABLE_MAP) != null;
    }

    @AssistedFactory
    static interface Factory {
        public MapRequestRepresentation create(ProvisionBinding var1);
    }
}

