/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.base.Util;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.FrameworkType;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.DelegateRequestRepresentation;
import dagger.internal.codegen.writing.DerivedFromFrameworkInstanceRequestRepresentation;
import dagger.internal.codegen.writing.FrameworkFieldInitializer;
import dagger.internal.codegen.writing.FrameworkInstanceSupplier;
import dagger.internal.codegen.writing.ImmediateFutureRequestRepresentation;
import dagger.internal.codegen.writing.ProducerFromProviderCreationExpression;
import dagger.internal.codegen.writing.ProducerNodeInstanceRequestRepresentation;
import dagger.internal.codegen.writing.ProviderInstanceRequestRepresentation;
import dagger.internal.codegen.writing.ProvisionBindingRepresentation;
import dagger.internal.codegen.writing.RequestRepresentation;
import dagger.spi.model.BindingKind;
import dagger.spi.model.RequestKind;
import java.util.HashMap;
import java.util.Map;

final class FrameworkInstanceBindingRepresentation {
    private final ProvisionBinding binding;
    private final DerivedFromFrameworkInstanceRequestRepresentation.Factory derivedFromFrameworkInstanceRequestRepresentationFactory;
    private final ImmediateFutureRequestRepresentation.Factory immediateFutureRequestRepresentationFactory;
    private final Map<BindingRequest, RequestRepresentation> requestRepresentations = new HashMap<BindingRequest, RequestRepresentation>();
    private final RequestRepresentation providerRequestRepresentation;
    private final RequestRepresentation producerFromProviderRepresentation;

    @AssistedInject
    FrameworkInstanceBindingRepresentation(@Assisted ProvisionBinding binding, BindingGraph graph, @Assisted FrameworkInstanceSupplier providerField, ComponentImplementation componentImplementation, DelegateRequestRepresentation.Factory delegateRequestRepresentationFactory, DerivedFromFrameworkInstanceRequestRepresentation.Factory derivedFromFrameworkInstanceRequestRepresentationFactory, ImmediateFutureRequestRepresentation.Factory immediateFutureRequestRepresentationFactory, ProducerNodeInstanceRequestRepresentation.Factory producerNodeInstanceRequestRepresentationFactory, ProviderInstanceRequestRepresentation.Factory providerInstanceRequestRepresentationFactory, ProducerFromProviderCreationExpression.Factory producerFromProviderCreationExpressionFactory) {
        this.binding = binding;
        this.derivedFromFrameworkInstanceRequestRepresentationFactory = derivedFromFrameworkInstanceRequestRepresentationFactory;
        this.immediateFutureRequestRepresentationFactory = immediateFutureRequestRepresentationFactory;
        this.providerRequestRepresentation = binding.kind().equals((Object)BindingKind.DELEGATE) && !ProvisionBindingRepresentation.needsCaching(binding, graph) ? delegateRequestRepresentationFactory.create(binding, RequestKind.PROVIDER) : providerInstanceRequestRepresentationFactory.create(binding, providerField);
        this.producerFromProviderRepresentation = producerNodeInstanceRequestRepresentationFactory.create(binding, new FrameworkFieldInitializer(componentImplementation, binding, producerFromProviderCreationExpressionFactory.create(this.providerRequestRepresentation, componentImplementation.shardImplementation(binding).name())));
    }

    public RequestRepresentation getRequestRepresentation(BindingRequest request) {
        return Util.reentrantComputeIfAbsent(this.requestRepresentations, request, this::getRequestRepresentationUncached);
    }

    private RequestRepresentation getRequestRepresentationUncached(BindingRequest request) {
        switch (request.requestKind()) {
            case INSTANCE: 
            case LAZY: 
            case PRODUCED: 
            case PROVIDER_OF_LAZY: {
                return this.derivedFromFrameworkInstanceRequestRepresentationFactory.create(this.binding, this.providerRequestRepresentation, request.requestKind(), FrameworkType.PROVIDER);
            }
            case PROVIDER: {
                return this.providerRequestRepresentation;
            }
            case PRODUCER: {
                return this.producerFromProviderRepresentation;
            }
            case FUTURE: {
                return this.immediateFutureRequestRepresentationFactory.create(this.getRequestRepresentation(BindingRequest.bindingRequest(this.binding.key(), RequestKind.INSTANCE)), this.binding.key().type().xprocessing());
            }
        }
        throw new AssertionError((Object)String.format("Invalid binding request kind: %s", request.requestKind()));
    }

    @AssistedFactory
    static interface Factory {
        public FrameworkInstanceBindingRepresentation create(ProvisionBinding var1, FrameworkInstanceSupplier var2);
    }
}

