/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ComponentRequirementExpression;
import dagger.internal.codegen.writing.MemberSelect;
import dagger.internal.codegen.writing.ModuleProxies;
import dagger.internal.codegen.writing.ParentComponent;
import dagger.internal.codegen.writing.PerComponentImplementation;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;

@PerComponentImplementation
public final class ComponentRequirementExpressions {
    private final Optional<ComponentRequirementExpressions> parent;
    private final Map<ComponentRequirement, ComponentRequirementExpression> componentRequirementExpressions = new HashMap<ComponentRequirement, ComponentRequirementExpression>();
    private final BindingGraph graph;
    private final ComponentImplementation.ShardImplementation componentShard;

    @Inject
    ComponentRequirementExpressions(@ParentComponent Optional<ComponentRequirementExpressions> parent, BindingGraph graph, ComponentImplementation componentImplementation) {
        this.parent = parent;
        this.graph = graph;
        this.componentShard = componentImplementation.getComponentShard();
    }

    CodeBlock getExpression(ComponentRequirement componentRequirement, ClassName requestingClass) {
        return this.getExpression(componentRequirement).getExpression(requestingClass);
    }

    private ComponentRequirementExpression getExpression(ComponentRequirement componentRequirement) {
        if (this.graph.componentRequirements().contains((Object)componentRequirement)) {
            return this.componentRequirementExpressions.computeIfAbsent(componentRequirement, this::createExpression);
        }
        if (this.parent.isPresent()) {
            return this.parent.get().getExpression(componentRequirement);
        }
        throw new IllegalStateException("no component requirement expression found for " + componentRequirement);
    }

    CodeBlock getExpressionDuringInitialization(ComponentRequirement componentRequirement, ClassName requestingClass) {
        return this.getExpression(componentRequirement).getExpressionDuringInitialization(requestingClass);
    }

    private ComponentRequirementExpression createExpression(ComponentRequirement requirement) {
        if (this.componentShard.componentDescriptor().hasCreator() || this.graph.factoryMethod().isPresent() && this.graph.factoryMethodParameters().containsKey((Object)requirement)) {
            return new ComponentParameterField(requirement);
        }
        if (requirement.kind().isModule()) {
            return new InstantiableModuleField(requirement);
        }
        throw new AssertionError((Object)String.format("Can't create %s in %s", requirement, this.componentShard.name()));
    }

    private final class ComponentParameterField
    extends AbstractField {
        private final String parameterName;

        ComponentParameterField(ComponentRequirement module) {
            super(module);
            this.parameterName = ComponentRequirementExpressions.this.componentShard.getParameterName(this.componentRequirement);
        }

        @Override
        public CodeBlock getExpressionDuringInitialization(ClassName requestingClass) {
            if (ComponentRequirementExpressions.this.componentShard.name().equals((Object)requestingClass)) {
                return CodeBlock.of((String)"$L", (Object[])new Object[]{this.parameterName});
            }
            return this.getExpression(requestingClass);
        }

        @Override
        CodeBlock fieldInitialization(FieldSpec componentField) {
            return CodeBlock.of((String)"this.$N = $L;", (Object[])new Object[]{componentField, this.parameterName});
        }
    }

    private final class InstantiableModuleField
    extends AbstractField {
        private final XTypeElement moduleElement;

        InstantiableModuleField(ComponentRequirement module) {
            super(module);
            Preconditions.checkArgument((boolean)module.kind().isModule());
            this.moduleElement = module.typeElement();
        }

        @Override
        CodeBlock fieldInitialization(FieldSpec componentField) {
            return CodeBlock.of((String)"this.$N = $L;", (Object[])new Object[]{componentField, ModuleProxies.newModuleInstance(this.moduleElement, ComponentRequirementExpressions.this.componentShard.name())});
        }
    }

    private abstract class AbstractField
    implements ComponentRequirementExpression {
        final ComponentRequirement componentRequirement;
        private final Supplier<MemberSelect> field = Suppliers.memoize(this::createField);

        private AbstractField(ComponentRequirement componentRequirement) {
            this.componentRequirement = (ComponentRequirement)Preconditions.checkNotNull((Object)componentRequirement);
        }

        @Override
        public CodeBlock getExpression(ClassName requestingClass) {
            return ((MemberSelect)this.field.get()).getExpressionFor(requestingClass);
        }

        private MemberSelect createField() {
            String fieldName = ComponentRequirementExpressions.this.componentShard.getUniqueFieldName(this.componentRequirement.variableName());
            TypeName fieldType = this.componentRequirement.type().getTypeName();
            FieldSpec field = FieldSpec.builder((TypeName)fieldType, (String)fieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
            ComponentRequirementExpressions.this.componentShard.addField(ComponentImplementation.FieldSpecKind.COMPONENT_REQUIREMENT_FIELD, field);
            ComponentRequirementExpressions.this.componentShard.addComponentRequirementInitialization(this.fieldInitialization(field));
            return MemberSelect.localField(ComponentRequirementExpressions.this.componentShard, fieldName);
        }

        abstract CodeBlock fieldInitialization(FieldSpec var1);
    }
}

