/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.base.Keys;
import dagger.internal.codegen.base.SourceFileGenerationException;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.BindingDeclaration;
import dagger.internal.codegen.binding.BindingFactory;
import dagger.internal.codegen.binding.InjectBindingRegistry;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.binding.KeyFactory;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.extension.DaggerCollectors;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.validation.InjectValidator;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XProcessingEnvs;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.model.Key;
import dagger.spi.shaded.androidx.room.compiler.processing.XConstructorElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.shaded.androidx.room.compiler.processing.XFieldElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMessager;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.tools.Diagnostic;

@Singleton
final class InjectBindingRegistryImpl
implements InjectBindingRegistry {
    private final XProcessingEnv processingEnv;
    private final XMessager messager;
    private final InjectValidator injectValidator;
    private final InjectValidator injectValidatorWhenGeneratingCode;
    private final KeyFactory keyFactory;
    private final BindingFactory bindingFactory;
    private final CompilerOptions compilerOptions;
    private final BindingsCollection<ProvisionBinding> provisionBindings = new BindingsCollection(TypeNames.PROVIDER);
    private final BindingsCollection<MembersInjectionBinding> membersInjectionBindings = new BindingsCollection(TypeNames.MEMBERS_INJECTOR);

    @Inject
    InjectBindingRegistryImpl(XProcessingEnv processingEnv, XMessager messager, InjectValidator injectValidator, KeyFactory keyFactory, BindingFactory bindingFactory, CompilerOptions compilerOptions) {
        this.processingEnv = processingEnv;
        this.messager = messager;
        this.injectValidator = injectValidator;
        this.injectValidatorWhenGeneratingCode = injectValidator.whenGeneratingCode();
        this.keyFactory = keyFactory;
        this.bindingFactory = bindingFactory;
        this.compilerOptions = compilerOptions;
    }

    @Override
    public void generateSourcesForRequiredBindings(SourceFileGenerator<ProvisionBinding> factoryGenerator, SourceFileGenerator<MembersInjectionBinding> membersInjectorGenerator) throws SourceFileGenerationException {
        this.provisionBindings.generateBindings(factoryGenerator);
        this.membersInjectionBindings.generateBindings(membersInjectorGenerator);
    }

    private void registerBinding(ProvisionBinding binding, boolean warnIfNotAlreadyGenerated) {
        this.provisionBindings.tryRegisterBinding(binding, warnIfNotAlreadyGenerated);
    }

    private void registerBinding(MembersInjectionBinding binding, boolean warnIfNotAlreadyGenerated) {
        if (warnIfNotAlreadyGenerated) {
            boolean hasInjectConstructor;
            boolean bl = hasInjectConstructor = !InjectionAnnotations.injectedConstructors(binding.membersInjectedType()).isEmpty() || !AssistedInjectionAnnotations.assistedInjectedConstructors(binding.membersInjectedType()).isEmpty();
            warnIfNotAlreadyGenerated = hasInjectConstructor ? !binding.injectionSites().isEmpty() : binding.hasLocalInjectionSites();
        }
        this.membersInjectionBindings.tryRegisterBinding(binding, warnIfNotAlreadyGenerated);
    }

    @Override
    public Optional<ProvisionBinding> tryRegisterInjectConstructor(XConstructorElement constructorElement) {
        return this.tryRegisterConstructor(constructorElement, Optional.empty(), false);
    }

    @CanIgnoreReturnValue
    private Optional<ProvisionBinding> tryRegisterConstructor(XConstructorElement constructorElement, Optional<XType> resolvedType, boolean warnIfNotAlreadyGenerated) {
        XTypeElement typeElement = constructorElement.getEnclosingElement();
        ValidationReport report = this.injectValidator.validate(typeElement);
        report.printMessagesTo(this.messager);
        if (!report.isClean()) {
            return Optional.empty();
        }
        XType type = typeElement.getType();
        Key key = this.keyFactory.forInjectConstructorWithResolvedType(type);
        ProvisionBinding cachedBinding = this.provisionBindings.getBinding(key);
        if (cachedBinding != null) {
            return Optional.of(cachedBinding);
        }
        ProvisionBinding binding = this.bindingFactory.injectionBinding(constructorElement, resolvedType);
        this.registerBinding(binding, warnIfNotAlreadyGenerated);
        if (!binding.injectionSites().isEmpty()) {
            this.tryRegisterMembersInjectedType(typeElement, resolvedType, warnIfNotAlreadyGenerated);
        }
        return Optional.of(binding);
    }

    @Override
    public Optional<MembersInjectionBinding> tryRegisterInjectField(XFieldElement fieldElement) {
        if (!XElementKt.isTypeElement((XElement)fieldElement.getEnclosingElement())) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "@Inject fields must be enclosed in a type.", (XElement)fieldElement);
        }
        return this.tryRegisterMembersInjectedType(XElements.asTypeElement((XElement)fieldElement.getEnclosingElement()), Optional.empty(), false);
    }

    @Override
    public Optional<MembersInjectionBinding> tryRegisterInjectMethod(XMethodElement methodElement) {
        if (!XElementKt.isTypeElement((XElement)methodElement.getEnclosingElement())) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "@Inject methods must be enclosed in a type.", (XElement)methodElement);
        }
        return this.tryRegisterMembersInjectedType(XElements.asTypeElement((XElement)methodElement.getEnclosingElement()), Optional.empty(), false);
    }

    @CanIgnoreReturnValue
    private Optional<MembersInjectionBinding> tryRegisterMembersInjectedType(XTypeElement typeElement, Optional<XType> resolvedType, boolean warnIfNotAlreadyGenerated) {
        ValidationReport report = this.injectValidator.validateForMembersInjection(typeElement);
        report.printMessagesTo(this.messager);
        if (!report.isClean()) {
            return Optional.empty();
        }
        XType type = typeElement.getType();
        Key key = this.keyFactory.forInjectConstructorWithResolvedType(type);
        MembersInjectionBinding cachedBinding = this.membersInjectionBindings.getBinding(key);
        if (cachedBinding != null) {
            return Optional.of(cachedBinding);
        }
        MembersInjectionBinding binding = this.bindingFactory.membersInjectionBinding(type, resolvedType);
        this.registerBinding(binding, warnIfNotAlreadyGenerated);
        Optional supertype = XTypes.nonObjectSuperclass((XType)type);
        while (supertype.isPresent()) {
            this.getOrFindMembersInjectionBinding(this.keyFactory.forMembersInjectedType((XType)supertype.get()));
            supertype = XTypes.nonObjectSuperclass((XType)((XType)supertype.get()));
        }
        return Optional.of(binding);
    }

    @Override
    @CanIgnoreReturnValue
    public Optional<ProvisionBinding> getOrFindProvisionBinding(Key key) {
        Preconditions.checkNotNull((Object)key);
        if (!Keys.isValidImplicitProvisionKey(key)) {
            return Optional.empty();
        }
        ProvisionBinding binding = this.provisionBindings.getBinding(key);
        if (binding != null) {
            return Optional.of(binding);
        }
        XType type = key.type().xprocessing();
        XTypeElement element = type.getTypeElement();
        ValidationReport report = this.injectValidator.validate(element);
        report.printMessagesTo(this.messager);
        if (!report.isClean()) {
            return Optional.empty();
        }
        return ((Optional)Stream.concat(InjectionAnnotations.injectedConstructors(element).stream(), AssistedInjectionAnnotations.assistedInjectedConstructors(element).stream()).collect(DaggerCollectors.toOptional())).flatMap(constructor -> this.tryRegisterConstructor((XConstructorElement)constructor, Optional.of(type), true));
    }

    @Override
    @CanIgnoreReturnValue
    public Optional<MembersInjectionBinding> getOrFindMembersInjectionBinding(Key key) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkArgument((boolean)Keys.isValidMembersInjectionKey(key));
        MembersInjectionBinding binding = this.membersInjectionBindings.getBinding(key);
        if (binding != null) {
            return Optional.of(binding);
        }
        return this.tryRegisterMembersInjectedType(key.type().xprocessing().getTypeElement(), Optional.of(key.type().xprocessing()), true);
    }

    @Override
    public Optional<ProvisionBinding> getOrFindMembersInjectorProvisionBinding(Key key) {
        if (!Keys.isValidMembersInjectionKey(key)) {
            return Optional.empty();
        }
        Key membersInjectionKey = this.keyFactory.forMembersInjectedType(XTypes.unwrapType((XType)key.type().xprocessing()));
        return this.getOrFindMembersInjectionBinding(membersInjectionKey).map(binding -> this.bindingFactory.membersInjectorBinding(key, (MembersInjectionBinding)binding));
    }

    final class BindingsCollection<B extends Binding> {
        private final ClassName factoryClass;
        private final Map<Key, B> bindingsByKey = Maps.newLinkedHashMap();
        private final Deque<B> bindingsRequiringGeneration = new ArrayDeque<B>();
        private final Set<Key> materializedBindingKeys = Sets.newLinkedHashSet();

        BindingsCollection(ClassName factoryClass) {
            this.factoryClass = factoryClass;
        }

        void generateBindings(SourceFileGenerator<B> generator) throws SourceFileGenerationException {
            Binding binding = (Binding)this.bindingsRequiringGeneration.poll();
            while (binding != null) {
                Preconditions.checkState((!binding.unresolved().isPresent() ? 1 : 0) != 0);
                XType type = binding.key().type().xprocessing();
                if (!XTypes.isDeclared((XType)type) || InjectBindingRegistryImpl.this.injectValidatorWhenGeneratingCode.validate(type.getTypeElement()).isClean()) {
                    generator.generate(binding);
                }
                this.materializedBindingKeys.add(binding.key());
                binding = (Binding)this.bindingsRequiringGeneration.poll();
            }
            this.bindingsByKey.clear();
        }

        B getBinding(Key key) {
            return (B)((Binding)this.bindingsByKey.get(key));
        }

        void tryRegisterBinding(B binding, boolean warnIfNotAlreadyGenerated) {
            this.tryToCacheBinding(binding);
            B maybeUnresolved = ((Binding)binding).unresolved().isPresent() ? ((Binding)binding).unresolved().get() : binding;
            this.tryToGenerateBinding(maybeUnresolved, warnIfNotAlreadyGenerated);
        }

        void tryToGenerateBinding(B binding, boolean warnIfNotAlreadyGenerated) {
            if (this.shouldGenerateBinding(binding)) {
                this.bindingsRequiringGeneration.offer(binding);
                if (InjectBindingRegistryImpl.this.compilerOptions.warnIfInjectionFactoryNotGeneratedUpstream() && warnIfNotAlreadyGenerated) {
                    InjectBindingRegistryImpl.this.messager.printMessage(Diagnostic.Kind.NOTE, String.format("Generating a %s for %s. Prefer to run the dagger processor over that class instead.", this.factoryClass.simpleName(), XProcessingEnvs.erasure((XType)((BindingDeclaration)binding).key().type().xprocessing(), (XProcessingEnv)InjectBindingRegistryImpl.this.processingEnv)));
                }
            }
        }

        private boolean shouldGenerateBinding(B binding) {
            return !((Binding)binding).unresolved().isPresent() && !this.materializedBindingKeys.contains(((BindingDeclaration)binding).key()) && !this.bindingsRequiringGeneration.contains(binding) && InjectBindingRegistryImpl.this.processingEnv.findTypeElement((TypeName)SourceFiles.generatedClassNameForBinding(binding)) == null;
        }

        private void tryToCacheBinding(B binding) {
            if (((Binding)binding).unresolved().isPresent() || ((BindingDeclaration)binding).bindingTypeElement().get().getType().getTypeArguments().isEmpty()) {
                Key key = ((BindingDeclaration)binding).key();
                Binding previousValue = (Binding)this.bindingsByKey.put(key, binding);
                Preconditions.checkState((previousValue == null || binding.equals(previousValue) ? 1 : 0) != 0, (String)"couldn't register %s. %s was already registered for %s", binding, (Object)previousValue, (Object)key);
            }
        }
    }
}

