/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.FormatMethod;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.validation.BindingElementValidator;
import dagger.internal.codegen.validation.DependencyRequestValidator;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XMethodElements;
import dagger.internal.codegen.xprocessing.XProcessingEnvs;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotated;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XVariableElement;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;

abstract class BindingMethodValidator
extends BindingElementValidator<XMethodElement> {
    private final ClassName methodAnnotation;
    private final ImmutableSet<ClassName> enclosingElementAnnotations;
    private final Abstractness abstractness;
    private final ExceptionSuperclass exceptionSuperclass;
    private final XProcessingEnv processingEnv;
    private final DependencyRequestValidator dependencyRequestValidator;

    protected BindingMethodValidator(ClassName methodAnnotation, ClassName enclosingElementAnnotation, Abstractness abstractness, ExceptionSuperclass exceptionSuperclass, BindingElementValidator.AllowsMultibindings allowsMultibindings, BindingElementValidator.AllowsScoping allowsScoping, XProcessingEnv processingEnv, DependencyRequestValidator dependencyRequestValidator, InjectionAnnotations injectionAnnotations) {
        this(methodAnnotation, (Iterable<ClassName>)ImmutableSet.of((Object)enclosingElementAnnotation), abstractness, exceptionSuperclass, allowsMultibindings, allowsScoping, processingEnv, dependencyRequestValidator, injectionAnnotations);
    }

    protected BindingMethodValidator(ClassName methodAnnotation, Iterable<ClassName> enclosingElementAnnotations, Abstractness abstractness, ExceptionSuperclass exceptionSuperclass, BindingElementValidator.AllowsMultibindings allowsMultibindings, BindingElementValidator.AllowsScoping allowsScoping, XProcessingEnv processingEnv, DependencyRequestValidator dependencyRequestValidator, InjectionAnnotations injectionAnnotations) {
        super(allowsMultibindings, allowsScoping, injectionAnnotations);
        this.methodAnnotation = methodAnnotation;
        this.enclosingElementAnnotations = ImmutableSet.copyOf(enclosingElementAnnotations);
        this.abstractness = abstractness;
        this.exceptionSuperclass = exceptionSuperclass;
        this.processingEnv = processingEnv;
        this.dependencyRequestValidator = dependencyRequestValidator;
    }

    final ClassName methodAnnotation() {
        return this.methodAnnotation;
    }

    @FormatMethod
    protected final String bindingMethods(String ruleFormat, Object ... args) {
        return this.bindingElements(ruleFormat, args);
    }

    @Override
    protected final String bindingElements() {
        return String.format("@%s methods", this.methodAnnotation.simpleName());
    }

    @Override
    protected final String bindingElementTypeVerb() {
        return "return";
    }

    protected static enum ExceptionSuperclass {
        NO_EXCEPTIONS{

            @Override
            protected String errorMessage(BindingMethodValidator validator) {
                return validator.bindingMethods("may not throw", new Object[0]);
            }

            @Override
            protected void checkThrows(BindingMethodValidator validator, XExecutableElement element, ValidationReport.Builder report) {
                if (!element.getThrownTypes().isEmpty()) {
                    report.addError(validator.bindingMethods("may not throw", new Object[0]));
                    return;
                }
            }
        }
        ,
        EXCEPTION(TypeNames.EXCEPTION){

            @Override
            protected String errorMessage(BindingMethodValidator validator) {
                return validator.bindingMethods("may only throw unchecked exceptions or exceptions subclassing Exception", new Object[0]);
            }
        }
        ,
        RUNTIME_EXCEPTION(TypeNames.RUNTIME_EXCEPTION){

            @Override
            protected String errorMessage(BindingMethodValidator validator) {
                return validator.bindingMethods("may only throw unchecked exceptions", new Object[0]);
            }
        };

        private final ClassName superclass;

        private ExceptionSuperclass() {
            this((ClassName)null);
        }

        private ExceptionSuperclass(ClassName superclass) {
            this.superclass = superclass;
        }

        protected void checkThrows(BindingMethodValidator validator, XExecutableElement element, ValidationReport.Builder report) {
            XType exceptionSupertype = validator.processingEnv.findType((TypeName)this.superclass);
            XType errorType = validator.processingEnv.findType((TypeName)TypeNames.ERROR);
            for (XType thrownType : element.getThrownTypes()) {
                if (XProcessingEnvs.isSubtype((XType)thrownType, (XType)exceptionSupertype, (XProcessingEnv)validator.processingEnv) || XProcessingEnvs.isSubtype((XType)thrownType, (XType)errorType, (XProcessingEnv)validator.processingEnv)) continue;
                report.addError(this.errorMessage(validator));
                break;
            }
        }

        protected abstract String errorMessage(BindingMethodValidator var1);
    }

    protected static enum Abstractness {
        MUST_BE_ABSTRACT,
        MUST_BE_CONCRETE;

    }

    protected abstract class MethodValidator
    extends BindingElementValidator.ElementValidator {
        private final XMethodElement method;

        protected MethodValidator(XMethodElement method) {
            super((BindingElementValidator)BindingMethodValidator.this, (XElement)method);
            this.method = method;
        }

        @Override
        protected final Optional<XType> bindingElementType() {
            return Optional.of(this.method.getReturnType());
        }

        @Override
        protected final void checkAdditionalProperties() {
            this.checkEnclosingElement();
            this.checkTypeParameters();
            this.checkNotPrivate();
            this.checkAbstractness();
            this.checkThrows();
            this.checkParameters();
            this.checkAdditionalMethodProperties();
        }

        protected void checkAdditionalMethodProperties() {
        }

        private void checkEnclosingElement() {
            XTypeElement enclosingTypeElement = XMethodElements.getEnclosingTypeElement((XMethodElement)this.method);
            if (enclosingTypeElement.isCompanionObject()) {
                enclosingTypeElement = enclosingTypeElement.getEnclosingTypeElement();
            }
            if (!XElements.hasAnyAnnotation((XAnnotated)enclosingTypeElement, (Collection)BindingMethodValidator.this.enclosingElementAnnotations)) {
                this.report.addError(BindingMethodValidator.this.bindingMethods("can only be present within a @%s", BindingMethodValidator.this.enclosingElementAnnotations.stream().map(ClassName::simpleName).collect(Collectors.joining(" or @"))));
            }
        }

        private void checkTypeParameters() {
            if (XMethodElements.hasTypeParameters((XMethodElement)this.method)) {
                this.report.addError(BindingMethodValidator.this.bindingMethods("may not have type parameters", new Object[0]));
            }
        }

        private void checkNotPrivate() {
            if (this.method.isPrivate()) {
                this.report.addError(BindingMethodValidator.this.bindingMethods("cannot be private", new Object[0]));
            }
        }

        private void checkAbstractness() {
            boolean isAbstract = this.method.isAbstract();
            switch (BindingMethodValidator.this.abstractness) {
                case MUST_BE_ABSTRACT: {
                    if (isAbstract) break;
                    this.report.addError(BindingMethodValidator.this.bindingMethods("must be abstract", new Object[0]));
                    break;
                }
                case MUST_BE_CONCRETE: {
                    if (!isAbstract) break;
                    this.report.addError(BindingMethodValidator.this.bindingMethods("cannot be abstract", new Object[0]));
                }
            }
        }

        private void checkThrows() {
            BindingMethodValidator.this.exceptionSuperclass.checkThrows(BindingMethodValidator.this, (XExecutableElement)this.method, this.report);
        }

        protected void checkParameters() {
            for (XVariableElement parameter : this.method.getParameters()) {
                this.checkParameter(parameter);
            }
        }

        protected void checkParameter(XVariableElement parameter) {
            BindingMethodValidator.this.dependencyRequestValidator.validateDependencyRequest(this.report, (XElement)parameter, parameter.getType());
        }
    }
}

