/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.kotlin;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.extension.DaggerCollectors;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.kotlin.AutoValue_KotlinMetadata;
import dagger.internal.codegen.kotlin.AutoValue_KotlinMetadata_ClassMetadata;
import dagger.internal.codegen.kotlin.AutoValue_KotlinMetadata_FunctionMetadata;
import dagger.internal.codegen.kotlin.AutoValue_KotlinMetadata_MethodForAnnotations;
import dagger.internal.codegen.kotlin.AutoValue_KotlinMetadata_PropertyMetadata;
import dagger.internal.codegen.kotlin.AutoValue_KotlinMetadata_ValueParameterMetadata;
import dagger.internal.codegen.xprocessing.XAnnotationValues;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotationValue;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XFieldElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import kotlinx.metadata.Flag;
import kotlinx.metadata.KmClassVisitor;
import kotlinx.metadata.KmConstructorExtensionVisitor;
import kotlinx.metadata.KmConstructorVisitor;
import kotlinx.metadata.KmExtensionType;
import kotlinx.metadata.KmFunctionExtensionVisitor;
import kotlinx.metadata.KmFunctionVisitor;
import kotlinx.metadata.KmPropertyExtensionVisitor;
import kotlinx.metadata.KmPropertyVisitor;
import kotlinx.metadata.KmValueParameterVisitor;
import kotlinx.metadata.jvm.JvmConstructorExtensionVisitor;
import kotlinx.metadata.jvm.JvmFieldSignature;
import kotlinx.metadata.jvm.JvmFunctionExtensionVisitor;
import kotlinx.metadata.jvm.JvmMethodSignature;
import kotlinx.metadata.jvm.JvmPropertyExtensionVisitor;
import kotlinx.metadata.jvm.KotlinClassHeader;
import kotlinx.metadata.jvm.KotlinClassMetadata;

@AutoValue
abstract class KotlinMetadata {
    private static final String DELEGATED_PROPERTY_NAME_SUFFIX = "$delegate";
    private final Map<XFieldElement, Optional<MethodForAnnotations>> elementFieldAnnotationMethodMap = new HashMap<XFieldElement, Optional<MethodForAnnotations>>();
    private final Map<XFieldElement, Optional<XMethodElement>> elementFieldGetterMethodMap = new HashMap<XFieldElement, Optional<XMethodElement>>();

    KotlinMetadata() {
    }

    abstract XTypeElement typeElement();

    abstract ClassMetadata classMetadata();

    @Memoized
    ImmutableMap<String, XMethodElement> methodDescriptors() {
        return (ImmutableMap)this.typeElement().getDeclaredMethods().stream().collect(DaggerStreams.toImmutableMap(XElements::getMethodDescriptor, Function.identity()));
    }

    Optional<XMethodElement> getSyntheticAnnotationMethod(XFieldElement fieldElement) {
        return this.getAnnotationMethod(fieldElement).map(methodForAnnotations -> {
            if (methodForAnnotations == MethodForAnnotations.MISSING) {
                throw new IllegalStateException("Method for annotations is missing for " + fieldElement);
            }
            return methodForAnnotations.method();
        });
    }

    boolean isMissingSyntheticAnnotationMethod(XFieldElement fieldElement) {
        return this.getAnnotationMethod(fieldElement).map(methodForAnnotations -> methodForAnnotations == MethodForAnnotations.MISSING).orElse(false);
    }

    private Optional<MethodForAnnotations> getAnnotationMethod(XFieldElement fieldElement) {
        return this.elementFieldAnnotationMethodMap.computeIfAbsent(fieldElement, this::getAnnotationMethodUncached);
    }

    private Optional<MethodForAnnotations> getAnnotationMethodUncached(XFieldElement fieldElement) {
        return this.findProperty(fieldElement).methodForAnnotationsSignature().map(signature -> Optional.ofNullable((XMethodElement)this.methodDescriptors().get(signature)).map(MethodForAnnotations::create).orElse(MethodForAnnotations.MISSING));
    }

    Optional<XMethodElement> getPropertyGetter(XFieldElement fieldElement) {
        return this.elementFieldGetterMethodMap.computeIfAbsent(fieldElement, this::getPropertyGetterUncached);
    }

    private Optional<XMethodElement> getPropertyGetterUncached(XFieldElement fieldElement) {
        return this.findProperty(fieldElement).getterSignature().flatMap(signature -> Optional.ofNullable((XMethodElement)this.methodDescriptors().get(signature)));
    }

    private PropertyMetadata findProperty(XFieldElement field) {
        String fieldDescriptor = XElements.getFieldDescriptor((XFieldElement)field);
        if (this.classMetadata().propertiesByFieldSignature().containsKey((Object)fieldDescriptor)) {
            return (PropertyMetadata)this.classMetadata().propertiesByFieldSignature().get((Object)fieldDescriptor);
        }
        String propertyName = KotlinMetadata.getPropertyNameFromField(field);
        return (PropertyMetadata)this.classMetadata().propertiesByFieldSignature().values().stream().filter(property -> propertyName.contentEquals(property.name())).collect(DaggerCollectors.onlyElement());
    }

    private static String getPropertyNameFromField(XFieldElement field) {
        String name = XElements.getSimpleName((XElement)field);
        if (name.endsWith(DELEGATED_PROPERTY_NAME_SUFFIX)) {
            return name.substring(0, name.length() - DELEGATED_PROPERTY_NAME_SUFFIX.length());
        }
        return name;
    }

    static KotlinMetadata from(XTypeElement typeElement) {
        return new AutoValue_KotlinMetadata(typeElement, ClassVisitor.createClassMetadata(KotlinMetadata.metadataOf(typeElement)));
    }

    private static KotlinClassMetadata.Class metadataOf(XTypeElement typeElement) {
        XAnnotation metadataAnnotation = typeElement.getAnnotation(TypeNames.KOTLIN_METADATA);
        Preconditions.checkNotNull((Object)metadataAnnotation);
        KotlinClassHeader header = new KotlinClassHeader(Integer.valueOf(metadataAnnotation.getAsInt("k")), metadataAnnotation.getAsIntList("mv").stream().mapToInt(Integer::intValue).toArray(), metadataAnnotation.getAsStringList("d1").toArray(new String[0]), metadataAnnotation.getAsStringList("d2").toArray(new String[0]), metadataAnnotation.getAsString("xs"), XAnnotationValues.hasStringValue((XAnnotationValue)metadataAnnotation.getAnnotationValue("pn")) ? metadataAnnotation.getAsString("pn") : null, XAnnotationValues.hasIntValue((XAnnotationValue)metadataAnnotation.getAnnotationValue("xi")) ? Integer.valueOf(metadataAnnotation.getAsInt("xi")) : null);
        KotlinClassMetadata metadata = KotlinClassMetadata.read((KotlinClassHeader)header);
        if (metadata == null) {
            throw new IllegalStateException("Unsupported metadata version. Check that your Kotlin version is >= 1.0");
        }
        if (metadata instanceof KotlinClassMetadata.Class) {
            return (KotlinClassMetadata.Class)metadata;
        }
        throw new IllegalStateException("Unsupported metadata type: " + metadata);
    }

    @AutoValue
    static abstract class MethodForAnnotations {
        static final MethodForAnnotations MISSING = MethodForAnnotations.create(null);

        MethodForAnnotations() {
        }

        static MethodForAnnotations create(XMethodElement method) {
            return new AutoValue_KotlinMetadata_MethodForAnnotations(method);
        }

        @Nullable
        abstract XMethodElement method();
    }

    static abstract class BaseMetadata {
        BaseMetadata() {
        }

        abstract int flags();

        boolean flags(Flag flag) {
            return flag.invoke(this.flags());
        }

        abstract String name();

        static interface Builder<BuilderT> {
            public BuilderT flags(int var1);

            public BuilderT name(String var1);
        }
    }

    @AutoValue
    static abstract class ValueParameterMetadata
    extends BaseMetadata {
        ValueParameterMetadata() {
        }

        private static ValueParameterMetadata create(int flags, String name) {
            return new AutoValue_KotlinMetadata_ValueParameterMetadata(flags, name);
        }
    }

    @AutoValue
    static abstract class PropertyMetadata
    extends BaseMetadata {
        PropertyMetadata() {
        }

        abstract Optional<String> fieldSignature();

        abstract Optional<String> getterSignature();

        abstract Optional<String> methodForAnnotationsSignature();

        static Builder builder(int flags, String name) {
            return (Builder)new AutoValue_KotlinMetadata_PropertyMetadata.Builder().flags(flags).name(name);
        }

        @AutoValue.Builder
        static interface Builder
        extends BaseMetadata.Builder<Builder> {
            public Builder fieldSignature(Optional<String> var1);

            public Builder getterSignature(Optional<String> var1);

            public Builder methodForAnnotationsSignature(Optional<String> var1);

            public PropertyMetadata build();
        }
    }

    @AutoValue
    static abstract class FunctionMetadata
    extends BaseMetadata {
        FunctionMetadata() {
        }

        abstract String signature();

        abstract ImmutableList<ValueParameterMetadata> parameters();

        static Builder builder(int flags, String name) {
            return (Builder)new AutoValue_KotlinMetadata_FunctionMetadata.Builder().flags(flags).name(name);
        }

        @AutoValue.Builder
        static abstract class Builder
        implements BaseMetadata.Builder<Builder> {
            Builder() {
            }

            abstract Builder signature(String var1);

            abstract ImmutableList.Builder<ValueParameterMetadata> parametersBuilder();

            Builder addParameter(ValueParameterMetadata parameter) {
                this.parametersBuilder().add((Object)parameter);
                return this;
            }

            abstract FunctionMetadata build();
        }
    }

    @AutoValue
    static abstract class ClassMetadata
    extends BaseMetadata {
        ClassMetadata() {
        }

        abstract Optional<String> companionObjectName();

        abstract ImmutableSet<FunctionMetadata> constructors();

        abstract ImmutableMap<String, FunctionMetadata> functionsBySignature();

        abstract ImmutableMap<String, PropertyMetadata> propertiesByFieldSignature();

        static Builder builder() {
            return new AutoValue_KotlinMetadata_ClassMetadata.Builder();
        }

        @AutoValue.Builder
        static abstract class Builder
        implements BaseMetadata.Builder<Builder> {
            Builder() {
            }

            abstract Builder companionObjectName(String var1);

            abstract ImmutableSet.Builder<FunctionMetadata> constructorsBuilder();

            abstract ImmutableMap.Builder<String, FunctionMetadata> functionsBySignatureBuilder();

            abstract ImmutableMap.Builder<String, PropertyMetadata> propertiesByFieldSignatureBuilder();

            Builder addConstructor(FunctionMetadata constructor) {
                this.constructorsBuilder().add((Object)constructor);
                this.functionsBySignatureBuilder().put((Object)constructor.signature(), (Object)constructor);
                return this;
            }

            Builder addFunction(FunctionMetadata function) {
                this.functionsBySignatureBuilder().put((Object)function.signature(), (Object)function);
                return this;
            }

            Builder addProperty(PropertyMetadata property) {
                if (property.fieldSignature().isPresent()) {
                    this.propertiesByFieldSignatureBuilder().put((Object)property.fieldSignature().get(), (Object)property);
                }
                return this;
            }

            abstract ClassMetadata build();
        }
    }

    private static final class ClassVisitor
    extends KmClassVisitor {
        private final ClassMetadata.Builder classMetadata = ClassMetadata.builder();

        private ClassVisitor() {
        }

        static ClassMetadata createClassMetadata(KotlinClassMetadata.Class data) {
            ClassVisitor visitor = new ClassVisitor();
            data.accept((KmClassVisitor)visitor);
            return visitor.classMetadata.build();
        }

        public void visit(int flags, String name) {
            ((ClassMetadata.Builder)this.classMetadata.flags(flags)).name(name);
        }

        public KmConstructorVisitor visitConstructor(final int flags) {
            return new KmConstructorVisitor(){
                private final FunctionMetadata.Builder constructor;
                {
                    this.constructor = FunctionMetadata.builder(flags, "<init>");
                }

                public KmValueParameterVisitor visitValueParameter(int flags2, String name) {
                    this.constructor.addParameter(ValueParameterMetadata.create(flags2, name));
                    return super.visitValueParameter(flags2, name);
                }

                public KmConstructorExtensionVisitor visitExtensions(KmExtensionType kmExtensionType) {
                    return kmExtensionType.equals((Object)JvmConstructorExtensionVisitor.TYPE) ? new JvmConstructorExtensionVisitor(){

                        public void visit(JvmMethodSignature jvmMethodSignature) {
                            constructor.signature(jvmMethodSignature.asString());
                        }
                    } : null;
                }

                public void visitEnd() {
                    classMetadata.addConstructor(this.constructor.build());
                }
            };
        }

        public KmFunctionVisitor visitFunction(final int flags, final String name) {
            return new KmFunctionVisitor(){
                private final FunctionMetadata.Builder function;
                {
                    this.function = FunctionMetadata.builder(flags, name);
                }

                public KmValueParameterVisitor visitValueParameter(int flags2, String name2) {
                    this.function.addParameter(ValueParameterMetadata.create(flags2, name2));
                    return super.visitValueParameter(flags2, name2);
                }

                public KmFunctionExtensionVisitor visitExtensions(KmExtensionType kmExtensionType) {
                    return kmExtensionType.equals((Object)JvmFunctionExtensionVisitor.TYPE) ? new JvmFunctionExtensionVisitor(){

                        public void visit(JvmMethodSignature jvmMethodSignature) {
                            function.signature(jvmMethodSignature.asString());
                        }
                    } : null;
                }

                public void visitEnd() {
                    classMetadata.addFunction(this.function.build());
                }
            };
        }

        public void visitCompanionObject(String companionObjectName) {
            this.classMetadata.companionObjectName(companionObjectName);
        }

        public KmPropertyVisitor visitProperty(final int flags, final String name, int getterFlags, int setterFlags) {
            return new KmPropertyVisitor(){
                private final PropertyMetadata.Builder property;
                {
                    this.property = PropertyMetadata.builder(flags, name);
                }

                public KmPropertyExtensionVisitor visitExtensions(KmExtensionType kmExtensionType) {
                    if (!kmExtensionType.equals((Object)JvmPropertyExtensionVisitor.TYPE)) {
                        return null;
                    }
                    return new JvmPropertyExtensionVisitor(){

                        public void visit(int jvmFlags, @Nullable JvmFieldSignature jvmFieldSignature, @Nullable JvmMethodSignature jvmGetterSignature, @Nullable JvmMethodSignature jvmSetterSignature) {
                            property.fieldSignature(Optional.ofNullable(jvmFieldSignature).map(JvmFieldSignature::asString));
                            property.getterSignature(Optional.ofNullable(jvmGetterSignature).map(JvmMethodSignature::asString));
                        }

                        public void visitSyntheticMethodForAnnotations(@Nullable JvmMethodSignature methodSignature) {
                            property.methodForAnnotationsSignature(Optional.ofNullable(methodSignature).map(JvmMethodSignature::asString));
                        }
                    };
                }

                public void visitEnd() {
                    classMetadata.addProperty(this.property.build());
                }
            };
        }
    }
}

