/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import dagger.internal.codegen.base.DaggerSuperficialValidation;
import dagger.internal.codegen.base.MapKeyAccessibility;
import dagger.internal.codegen.binding.AnnotationExpression;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.extension.DaggerCollectors;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.model.DaggerAnnotation;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotated;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotationValue;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeKt;
import java.util.Optional;
import javax.lang.model.element.Modifier;

public final class MapKeys {
    static Optional<XAnnotation> getMapKey(XElement bindingElement) {
        return (Optional)MapKeys.getMapKeys(bindingElement).stream().collect(DaggerCollectors.toOptional());
    }

    public static ImmutableSet<XAnnotation> getMapKeys(XElement bindingElement) {
        return XElements.getAnnotatedAnnotations((XAnnotated)bindingElement, (ClassName)TypeNames.MAP_KEY);
    }

    private static Optional<XAnnotationValue> unwrapValue(XAnnotation mapKey) {
        XTypeElement mapKeyType = mapKey.getType().getTypeElement();
        XAnnotation mapKeyAnnotation = mapKeyType.getAnnotation(TypeNames.MAP_KEY);
        Preconditions.checkArgument((mapKeyAnnotation != null ? 1 : 0) != 0, (String)"%s is not annotated with @MapKey", (Object)mapKeyType);
        return mapKeyAnnotation.getAsBoolean("unwrapValue") ? Optional.of((XAnnotationValue)Iterables.getOnlyElement((Iterable)mapKey.getAnnotationValues())) : Optional.empty();
    }

    static XType mapKeyType(XAnnotation mapKey) {
        return MapKeys.unwrapValue(mapKey).isPresent() ? MapKeys.getUnwrappedMapKeyType(mapKey.getType()) : mapKey.getType();
    }

    public static XType getUnwrappedMapKeyType(XType mapKeyAnnotationType) {
        Preconditions.checkArgument((XTypes.isDeclared((XType)mapKeyAnnotationType) && mapKeyAnnotationType.getTypeElement().isAnnotationClass() ? 1 : 0) != 0, (String)"%s is not an annotation type", (Object)mapKeyAnnotationType);
        XMethodElement annotationValueMethod = (XMethodElement)Iterables.getOnlyElement((Iterable)mapKeyAnnotationType.getTypeElement().getDeclaredMethods());
        XType annotationValueType = annotationValueMethod.getReturnType();
        if (XTypeKt.isArray((XType)annotationValueType)) {
            throw new IllegalArgumentException(mapKeyAnnotationType + "." + XElements.getSimpleName((XElement)annotationValueMethod) + " cannot be an array");
        }
        return XTypes.isPrimitive((XType)annotationValueType) ? annotationValueType.boxed() : annotationValueType;
    }

    public static CodeBlock getMapKeyExpression(ContributionBinding binding, ClassName requestingClass, XProcessingEnv processingEnv) {
        XAnnotation mapKeyAnnotation = binding.mapKey().get().xprocessing();
        return MapKeyAccessibility.isMapKeyAccessibleFrom(mapKeyAnnotation, requestingClass.packageName()) ? MapKeys.directMapKeyExpression(mapKeyAnnotation, processingEnv) : CodeBlock.of((String)"$T.create()", (Object[])new Object[]{MapKeys.mapKeyProxyClassName(binding)});
    }

    private static CodeBlock directMapKeyExpression(XAnnotation mapKey, XProcessingEnv processingEnv) {
        Optional<XAnnotationValue> unwrappedValue = MapKeys.unwrapValue(mapKey);
        if (mapKey.getQualifiedName().contentEquals("dagger.android.AndroidInjectionKey")) {
            XTypeElement unwrappedType = DaggerSuperficialValidation.requireTypeElement(processingEnv, unwrappedValue.get().asString());
            return CodeBlock.of((String)"$T.of($S)", (Object[])new Object[]{ClassName.get((String)"dagger.android.internal", (String)"AndroidInjectionKeys", (String[])new String[0]), unwrappedType.getClassName().reflectionName()});
        }
        AnnotationExpression annotationExpression = new AnnotationExpression(mapKey);
        if (unwrappedValue.isPresent()) {
            XType unwrappedValueType = ((XMethodElement)Iterables.getOnlyElement((Iterable)mapKey.getType().getTypeElement().getDeclaredMethods())).getReturnType();
            return annotationExpression.getValueExpression(unwrappedValue.get(), unwrappedValueType);
        }
        return annotationExpression.getAnnotationInstanceExpression();
    }

    public static ClassName mapKeyProxyClassName(ContributionBinding binding) {
        return SourceFiles.elementBasedClassName(XElements.asExecutable((XElement)binding.bindingElement().get()), "MapKey");
    }

    public static Optional<MethodSpec> mapKeyFactoryMethod(ContributionBinding binding, XProcessingEnv processingEnv) {
        return binding.mapKey().map(DaggerAnnotation::xprocessing).filter(mapKey -> !MapKeyAccessibility.isMapKeyPubliclyAccessible(mapKey)).map(mapKey -> MethodSpec.methodBuilder((String)"create").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(MapKeys.mapKeyType(mapKey).getTypeName()).addStatement("return $L", new Object[]{MapKeys.directMapKeyExpression(mapKey, processingEnv)}).build());
    }

    private MapKeys() {
    }
}

