/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.ClassName;
import dagger.Reusable;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.spi.shaded.auto.common.AnnotationMirrors;
import dagger.spi.shaded.auto.common.MoreElements;
import dagger.spi.shaded.auto.common.MoreTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.AnnotationValueVisitor;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.AbstractElementVisitor8;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;
import javax.lang.model.util.SimpleTypeVisitor8;

@Reusable
public final class DaggerSuperficialValidation {
    private final boolean isStrictValidationEnabled;
    private final ElementVisitor<Void, Void> elementValidatingVisitor = new AbstractElementVisitor8<Void, Void>(){

        @Override
        public Void visitPackage(PackageElement e, Void p) {
            DaggerSuperficialValidation.this.validateAnnotations(e.getAnnotationMirrors());
            return null;
        }

        @Override
        public Void visitType(TypeElement e, Void p) {
            DaggerSuperficialValidation.this.validateBaseElement(e);
            DaggerSuperficialValidation.this.validateElements(e.getTypeParameters());
            DaggerSuperficialValidation.this.validateTypes("interface", e.getInterfaces());
            DaggerSuperficialValidation.this.validateType("superclass", e.getSuperclass());
            return null;
        }

        @Override
        public Void visitVariable(VariableElement e, Void p) {
            DaggerSuperficialValidation.this.validateBaseElement(e);
            return null;
        }

        @Override
        public Void visitExecutable(ExecutableElement e, Void p) {
            AnnotationValue defaultValue = e.getDefaultValue();
            DaggerSuperficialValidation.this.validateBaseElement(e);
            if (defaultValue != null) {
                DaggerSuperficialValidation.this.validateAnnotationValue(defaultValue, e.getReturnType());
            }
            DaggerSuperficialValidation.this.validateType("return type", e.getReturnType());
            DaggerSuperficialValidation.this.validateTypes("thrown type", e.getThrownTypes());
            DaggerSuperficialValidation.this.validateElements(e.getTypeParameters());
            DaggerSuperficialValidation.this.validateElements(e.getParameters());
            return null;
        }

        @Override
        public Void visitTypeParameter(TypeParameterElement e, Void p) {
            DaggerSuperficialValidation.this.validateBaseElement(e);
            DaggerSuperficialValidation.this.validateTypes("bound type", e.getBounds());
            return null;
        }

        @Override
        public Void visitUnknown(Element e, Void p) {
            return null;
        }
    };
    private final TypeVisitor<Void, Void> typeValidatingVisitor = new SimpleTypeVisitor8<Void, Void>(){

        @Override
        protected Void defaultAction(TypeMirror t, Void p) {
            return null;
        }

        @Override
        public Void visitArray(ArrayType t, Void p) {
            DaggerSuperficialValidation.this.validateType("array component type", t.getComponentType());
            return null;
        }

        @Override
        public Void visitDeclared(DeclaredType t, Void p) {
            if (DaggerSuperficialValidation.this.isStrictValidationEnabled && t.getKind() == TypeKind.ERROR) {
                throw new ValidationException.KnownErrorType(t);
            }
            DaggerSuperficialValidation.this.validateTypes("type argument", t.getTypeArguments());
            return null;
        }

        @Override
        public Void visitError(ErrorType t, Void p) {
            throw new ValidationException.KnownErrorType(t);
        }

        @Override
        public Void visitUnknown(TypeMirror t, Void p) {
            return this.defaultAction(t, p);
        }

        @Override
        public Void visitWildcard(WildcardType t, Void p) {
            TypeMirror extendsBound = t.getExtendsBound();
            TypeMirror superBound = t.getSuperBound();
            if (extendsBound != null) {
                DaggerSuperficialValidation.this.validateType("extends bound type", extendsBound);
            }
            if (superBound != null) {
                DaggerSuperficialValidation.this.validateType("super bound type", superBound);
            }
            return null;
        }

        @Override
        public Void visitExecutable(ExecutableType t, Void p) {
            DaggerSuperficialValidation.this.validateTypes("parameter type", t.getParameterTypes());
            DaggerSuperficialValidation.this.validateType("return type", t.getReturnType());
            DaggerSuperficialValidation.this.validateTypes("thrown type", t.getThrownTypes());
            DaggerSuperficialValidation.this.validateTypes("type variable", t.getTypeVariables());
            return null;
        }
    };
    private final AnnotationValueVisitor<Void, TypeMirror> valueValidatingVisitor = new SimpleAnnotationValueVisitor8<Void, TypeMirror>(){

        @Override
        protected Void defaultAction(Object o, TypeMirror expectedType) {
            try {
                DaggerSuperficialValidation.this.validateIsTypeOf(o.getClass(), expectedType);
            }
            catch (RuntimeException exception) {
                throw ValidationException.from(exception).append(this.exceptionMessage("DEFAULT", o, expectedType));
            }
            return null;
        }

        @Override
        public Void visitString(String str, TypeMirror expectedType) {
            try {
                if (!MoreTypes.isTypeOf(String.class, (TypeMirror)expectedType)) {
                    if (str.contentEquals("<error>")) {
                        throw new ValidationException.KnownErrorType("<error>");
                    }
                    throw new ValidationException.UnknownErrorType();
                }
            }
            catch (RuntimeException exception) {
                throw ValidationException.from(exception).append(this.exceptionMessage("STRING", str, expectedType));
            }
            return null;
        }

        @Override
        public Void visitUnknown(AnnotationValue av, TypeMirror expectedType) {
            this.defaultAction((Object)av, expectedType);
            return null;
        }

        @Override
        public Void visitAnnotation(AnnotationMirror a, TypeMirror expectedType) {
            try {
                DaggerSuperficialValidation.this.validateIsEquivalentType(a.getAnnotationType(), expectedType);
                DaggerSuperficialValidation.this.validateAnnotation(a);
            }
            catch (RuntimeException exception) {
                throw ValidationException.from(exception).append(this.exceptionMessage("ANNOTATION", a, expectedType));
            }
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> values, TypeMirror expectedType) {
            try {
                if (!expectedType.getKind().equals((Object)TypeKind.ARRAY)) {
                    throw new ValidationException.UnknownErrorType();
                }
                TypeMirror componentType = MoreTypes.asArray((TypeMirror)expectedType).getComponentType();
                for (AnnotationValue annotationValue : values) {
                    annotationValue.accept(this, componentType);
                }
            }
            catch (RuntimeException exception) {
                throw ValidationException.from(exception).append(this.exceptionMessage("ARRAY", values, expectedType));
            }
            return null;
        }

        @Override
        public Void visitEnumConstant(VariableElement enumConstant, TypeMirror expectedType) {
            try {
                DaggerSuperficialValidation.this.validateIsEquivalentType(MoreTypes.asDeclared((TypeMirror)enumConstant.asType()), expectedType);
                DaggerSuperficialValidation.this.validateElement(enumConstant);
            }
            catch (RuntimeException exception) {
                throw ValidationException.from(exception).append(this.exceptionMessage("ENUM_CONSTANT", enumConstant, expectedType));
            }
            return null;
        }

        @Override
        public Void visitType(TypeMirror type, TypeMirror expectedType) {
            try {
                DaggerSuperficialValidation.this.validateType("annotation value type", type);
            }
            catch (RuntimeException exception) {
                throw ValidationException.from(exception).append(this.exceptionMessage("TYPE", type, expectedType));
            }
            return null;
        }

        @Override
        public Void visitBoolean(boolean b, TypeMirror expectedType) {
            try {
                DaggerSuperficialValidation.this.validateIsTypeOf(Boolean.TYPE, expectedType);
            }
            catch (RuntimeException exception) {
                throw ValidationException.from(exception).append(this.exceptionMessage("BOOLEAN", b, expectedType));
            }
            return null;
        }

        @Override
        public Void visitByte(byte b, TypeMirror expectedType) {
            try {
                DaggerSuperficialValidation.this.validateIsTypeOf(Byte.TYPE, expectedType);
            }
            catch (RuntimeException exception) {
                throw ValidationException.from(exception).append(this.exceptionMessage("BYTE", b, expectedType));
            }
            return null;
        }

        @Override
        public Void visitChar(char c, TypeMirror expectedType) {
            try {
                DaggerSuperficialValidation.this.validateIsTypeOf(Character.TYPE, expectedType);
            }
            catch (RuntimeException exception) {
                throw ValidationException.from(exception).append(this.exceptionMessage("CHAR", Character.valueOf(c), expectedType));
            }
            return null;
        }

        @Override
        public Void visitDouble(double d, TypeMirror expectedType) {
            try {
                DaggerSuperficialValidation.this.validateIsTypeOf(Double.TYPE, expectedType);
            }
            catch (RuntimeException exception) {
                throw ValidationException.from(exception).append(this.exceptionMessage("DOUBLE", d, expectedType));
            }
            return null;
        }

        @Override
        public Void visitFloat(float f, TypeMirror expectedType) {
            try {
                DaggerSuperficialValidation.this.validateIsTypeOf(Float.TYPE, expectedType);
            }
            catch (RuntimeException exception) {
                throw ValidationException.from(exception).append(this.exceptionMessage("FLOAT", Float.valueOf(f), expectedType));
            }
            return null;
        }

        @Override
        public Void visitInt(int i, TypeMirror expectedType) {
            try {
                DaggerSuperficialValidation.this.validateIsTypeOf(Integer.TYPE, expectedType);
            }
            catch (RuntimeException exception) {
                throw ValidationException.from(exception).append(this.exceptionMessage("INT", i, expectedType));
            }
            return null;
        }

        @Override
        public Void visitLong(long l, TypeMirror expectedType) {
            try {
                DaggerSuperficialValidation.this.validateIsTypeOf(Long.TYPE, expectedType);
            }
            catch (RuntimeException exception) {
                throw ValidationException.from(exception).append(this.exceptionMessage("LONG", l, expectedType));
            }
            return null;
        }

        @Override
        public Void visitShort(short s, TypeMirror expectedType) {
            try {
                DaggerSuperficialValidation.this.validateIsTypeOf(Short.TYPE, expectedType);
            }
            catch (RuntimeException exception) {
                throw ValidationException.from(exception).append(this.exceptionMessage("SHORT", s, expectedType));
            }
            return null;
        }

        private <T> String exceptionMessage(String valueType, T value, TypeMirror expectedType) {
            return String.format("annotation value (%s): value '%s' with expected type %s", valueType, value, expectedType);
        }
    };

    public static XTypeElement requireTypeElement(XProcessingEnv processingEnv, ClassName className) {
        return DaggerSuperficialValidation.requireTypeElement(processingEnv, className.canonicalName());
    }

    public static XTypeElement requireTypeElement(XProcessingEnv processingEnv, String className) {
        XTypeElement type = processingEnv.findTypeElement(className);
        if (type == null) {
            throw new ValidationException.KnownErrorType(className);
        }
        return type;
    }

    @Inject
    DaggerSuperficialValidation(CompilerOptions compilerOptions) {
        this.isStrictValidationEnabled = compilerOptions.strictSuperficialValidation();
    }

    public void validateTypeOf(XElement element) {
        this.validateTypeOf(XConverters.toJavac((XElement)element));
    }

    private void validateTypeOf(Element element) {
        try {
            this.validateType(Ascii.toLowerCase((String)element.getKind().name()), element.asType());
        }
        catch (RuntimeException exception) {
            throw ValidationException.from(exception).append(element);
        }
    }

    public void validateSuperTypeOf(XTypeElement element) {
        this.validateSuperTypeOf(XConverters.toJavac((XTypeElement)element));
    }

    private void validateSuperTypeOf(TypeElement element) {
        try {
            this.validateType("superclass", element.getSuperclass());
        }
        catch (RuntimeException exception) {
            throw ValidationException.from(exception).append(element);
        }
    }

    public void validateThrownTypesOf(XExecutableElement element) {
        this.validateThrownTypesOf(XConverters.toJavac((XExecutableElement)element));
    }

    private void validateThrownTypesOf(ExecutableElement element) {
        try {
            this.validateTypes("thrown type", element.getThrownTypes());
        }
        catch (RuntimeException exception) {
            throw ValidationException.from(exception).append(element);
        }
    }

    public void validateAnnotationTypesOf(XElement element) {
        this.validateAnnotationTypesOf(XConverters.toJavac((XElement)element));
    }

    public void validateAnnotationTypesOf(Element element) {
        element.getAnnotationMirrors().forEach(annotation -> this.validateAnnotationTypeOf(element, (AnnotationMirror)annotation));
    }

    public void validateAnnotationTypeOf(XElement element, XAnnotation annotation) {
        this.validateAnnotationTypeOf(XConverters.toJavac((XElement)element), XConverters.toJavac((XAnnotation)annotation));
    }

    public void validateAnnotationTypeOf(Element element, AnnotationMirror annotation) {
        try {
            this.validateType("annotation type", annotation.getAnnotationType());
        }
        catch (RuntimeException exception) {
            throw ValidationException.from(exception).append(annotation).append(element);
        }
    }

    public void validateAnnotationsOf(XElement element) {
        this.validateAnnotationsOf(XConverters.toJavac((XElement)element));
    }

    public void validateAnnotationsOf(Element element) {
        try {
            this.validateAnnotations(element.getAnnotationMirrors());
        }
        catch (RuntimeException exception) {
            throw ValidationException.from(exception).append(element);
        }
    }

    public void validateAnnotationOf(XElement element, XAnnotation annotation) {
        this.validateAnnotationOf(XConverters.toJavac((XElement)element), XConverters.toJavac((XAnnotation)annotation));
    }

    public void validateAnnotationOf(Element element, AnnotationMirror annotation) {
        try {
            this.validateAnnotation(annotation);
        }
        catch (RuntimeException exception) {
            throw ValidationException.from(exception).append(element);
        }
    }

    public void validateTypeHierarchyOf(String typeDescription, XElement element, XType type) {
        try {
            this.validateTypeHierarchy(typeDescription, type);
        }
        catch (RuntimeException exception) {
            throw ValidationException.from(exception).append(XConverters.toJavac((XElement)element));
        }
    }

    private void validateTypeHierarchy(String desc, XType type) {
        this.validateType(desc, XConverters.toJavac((XType)type));
        try {
            type.getSuperTypes().forEach(supertype -> this.validateTypeHierarchy("supertype", (XType)supertype));
        }
        catch (RuntimeException exception) {
            throw ValidationException.from(exception).append(desc, XConverters.toJavac((XType)type));
        }
    }

    public void validateElements(Iterable<? extends Element> elements) {
        for (Element element : elements) {
            this.validateElement(element);
        }
    }

    public void validateElement(XElement element) {
        this.validateElement(XConverters.toJavac((XElement)element));
    }

    public void validateElement(Element element) {
        try {
            element.accept(this.elementValidatingVisitor, null);
        }
        catch (RuntimeException exception) {
            throw ValidationException.from(exception).append(element);
        }
    }

    private void validateBaseElement(Element e) {
        this.validateType(Ascii.toLowerCase((String)e.getKind().name()), e.asType());
        this.validateAnnotations(e.getAnnotationMirrors());
        this.validateElements(e.getEnclosedElements());
    }

    private void validateTypes(String desc, Iterable<? extends TypeMirror> types) {
        for (TypeMirror typeMirror : types) {
            this.validateType(desc, typeMirror);
        }
    }

    private void validateType(String desc, TypeMirror type) {
        try {
            type.accept(this.typeValidatingVisitor, null);
            if (this.isStrictValidationEnabled && type.getKind() == TypeKind.ERROR) {
                throw new ValidationException.KnownErrorType(type.toString());
            }
        }
        catch (RuntimeException e) {
            throw ValidationException.from(e).append(desc, type);
        }
    }

    private void validateAnnotations(Iterable<? extends AnnotationMirror> annotationMirrors) {
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            this.validateAnnotation(annotationMirror);
        }
    }

    private void validateAnnotation(AnnotationMirror annotationMirror) {
        try {
            this.validateType("annotation type", annotationMirror.getAnnotationType());
            this.validateAnnotationValues(annotationMirror.getElementValues());
        }
        catch (RuntimeException exception) {
            throw ValidationException.from(exception).append(annotationMirror);
        }
    }

    private void validateAnnotationValues(Map<? extends ExecutableElement, ? extends AnnotationValue> valueMap) {
        valueMap.forEach((method, annotationValue) -> {
            try {
                TypeMirror expectedType = method.getReturnType();
                this.validateAnnotationValue((AnnotationValue)annotationValue, expectedType);
            }
            catch (RuntimeException exception) {
                throw ValidationException.from(exception).append(String.format("annotation method: %s %s", method.getReturnType(), method));
            }
        });
    }

    private void validateAnnotationValue(AnnotationValue annotationValue, TypeMirror expectedType) {
        annotationValue.accept(this.valueValidatingVisitor, expectedType);
    }

    private void validateIsTypeOf(Class<?> clazz, TypeMirror expectedType) {
        if (!MoreTypes.isTypeOf(clazz, (TypeMirror)expectedType)) {
            throw new ValidationException.UnknownErrorType();
        }
    }

    private void validateIsEquivalentType(DeclaredType type, TypeMirror expectedType) {
        if (!MoreTypes.equivalence().equivalent((Object)type, (Object)expectedType)) {
            throw new ValidationException.KnownErrorType(type);
        }
    }

    public static abstract class ValidationException
    extends RuntimeException {
        private Optional<Element> lastReportedElement = Optional.empty();
        private final List<String> messages = new ArrayList<String>();

        private static ValidationException from(Throwable throwable) {
            return throwable instanceof ValidationException ? (ValidationException)throwable : new UnexpectedException(throwable);
        }

        private ValidationException() {
            super("");
        }

        private ValidationException(Throwable throwable) {
            super("", throwable);
        }

        private ValidationException append(Element element) {
            this.lastReportedElement = Optional.of(element);
            return this.append(this.getMessageForElement(element));
        }

        private ValidationException append(String desc, TypeMirror type) {
            return this.append(String.format("type (%s %s): %s", type.getKind().name(), desc, type));
        }

        private ValidationException append(AnnotationMirror annotationMirror) {
            return this.append(String.format("annotation: %s", AnnotationMirrors.toString((AnnotationMirror)annotationMirror)));
        }

        private ValidationException append(String message) {
            this.messages.add(message);
            return this;
        }

        @Override
        public String getMessage() {
            return String.format("\n  Validation trace:\n    => %s", this.getTrace());
        }

        public String getTrace() {
            return String.join((CharSequence)"\n    => ", (Iterable<? extends CharSequence>)this.getMessageInternal().reverse());
        }

        private ImmutableList<String> getMessageInternal() {
            if (!this.lastReportedElement.isPresent()) {
                return ImmutableList.copyOf(this.messages);
            }
            ArrayList<String> newMessages = new ArrayList<String>(this.messages);
            Element element = this.lastReportedElement.get();
            while (ValidationException.shouldAppendEnclosingElement(element)) {
                element = element.getEnclosingElement();
                newMessages.add(this.getMessageForElement(element));
            }
            return ImmutableList.copyOf(newMessages);
        }

        private static boolean shouldAppendEnclosingElement(Element element) {
            return element.getEnclosingElement() != null && !MoreElements.isType((Element)element) && (ValidationException.isExecutable(element.getEnclosingElement()) || MoreElements.isType((Element)element.getEnclosingElement()));
        }

        private static boolean isExecutable(Element element) {
            return element.getKind() == ElementKind.METHOD || element.getKind() == ElementKind.CONSTRUCTOR;
        }

        private String getMessageForElement(Element element) {
            return String.format("element (%s): %s", element.getKind().name(), element);
        }

        public static final class UnknownErrorType
        extends ValidationException {
        }

        public static final class KnownErrorType
        extends ValidationException {
            private final String errorTypeName;

            private KnownErrorType(DeclaredType errorType) {
                Element errorElement = errorType.asElement();
                this.errorTypeName = MoreElements.isType((Element)errorElement) ? MoreElements.asType((Element)errorElement).getQualifiedName().toString() : errorElement.getSimpleName().toString();
            }

            private KnownErrorType(String errorTypeName) {
                this.errorTypeName = errorTypeName;
            }

            public String getErrorTypeName() {
                return this.errorTypeName;
            }
        }

        public static final class UnexpectedException
        extends ValidationException {
            private UnexpectedException(Throwable throwable) {
                super(throwable);
            }
        }
    }
}

