/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.CodeBlock;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.base.ContributionType;
import dagger.internal.codegen.binding.BindsTypeChecker;
import dagger.internal.codegen.binding.FrameworkType;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.spi.model.BindingKind;
import dagger.spi.model.DependencyRequest;
import dagger.spi.model.RequestKind;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

final class ExperimentalSwitchingProviderDependencyRepresentation {
    private final ProvisionBinding binding;
    private final ComponentImplementation.ShardImplementation shardImplementation;
    private final BindsTypeChecker bindsTypeChecker;
    private final DaggerTypes types;
    private final DaggerElements elements;
    private final TypeMirror type;

    @AssistedInject
    ExperimentalSwitchingProviderDependencyRepresentation(@Assisted ProvisionBinding binding, ComponentImplementation componentImplementation, DaggerTypes types, DaggerElements elements) {
        this.binding = binding;
        this.shardImplementation = componentImplementation.shardImplementation(binding);
        this.types = types;
        this.elements = elements;
        this.bindsTypeChecker = new BindsTypeChecker(types, elements);
        this.type = this.isDelegateSetValuesBinding() ? types.erasure(elements.getTypeElement(TypeNames.COLLECTION).asType()) : XConverters.toJavac((XType)binding.contributedType());
    }

    Expression getDependencyExpression(RequestKind requestKind, ProvisionBinding requestingBinding) {
        int index = this.findIndexOfDependency(requestingBinding);
        DeclaredType frameworkType = this.types.getDeclaredType(this.elements.getTypeElement(FrameworkType.PROVIDER.frameworkClassName()), new TypeMirror[0]);
        Expression expression = FrameworkType.PROVIDER.to(requestKind, Expression.create(frameworkType, CodeBlock.of((String)"(($T) dependencies[$L])", (Object[])new Object[]{frameworkType, index})), this.types);
        if (this.usesExplicitTypeCast(expression, requestKind)) {
            return expression.castTo(this.type);
        }
        if (this.usesErasedTypeCast(requestKind)) {
            return expression.castTo(this.types.erasure(this.type));
        }
        return expression;
    }

    private int findIndexOfDependency(ProvisionBinding requestingBinding) {
        return ((ImmutableList)requestingBinding.dependencies().stream().map(DependencyRequest::key).collect(DaggerStreams.toImmutableList())).indexOf((Object)this.binding.key()) + (requestingBinding.requiresModuleInstance() && requestingBinding.contributingModule().isPresent() ? 1 : 0);
    }

    private boolean isDelegateSetValuesBinding() {
        return this.binding.kind().equals((Object)BindingKind.DELEGATE) && this.binding.contributionType().equals((Object)ContributionType.SET_VALUES);
    }

    private boolean usesExplicitTypeCast(Expression expression, RequestKind requestKind) {
        return requestKind.equals((Object)RequestKind.INSTANCE) && !this.bindsTypeChecker.isAssignable(expression.type(), this.type, this.binding.contributionType()) && Accessibility.isTypeAccessibleFrom(this.type, this.shardImplementation.name().packageName());
    }

    private boolean usesErasedTypeCast(RequestKind requestKind) {
        return requestKind.equals((Object)RequestKind.INSTANCE) && !Accessibility.isTypeAccessibleFrom(this.type, this.shardImplementation.name().packageName()) && Accessibility.isRawTypeAccessible(this.type, this.shardImplementation.name().packageName());
    }

    @AssistedFactory
    static interface Factory {
        public ExperimentalSwitchingProviderDependencyRepresentation create(ProvisionBinding var1);
    }
}

