/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.componentgenerator;

import com.google.common.base.Ascii;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.base.ComponentCreatorKind;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.binding.ComponentCreatorDescriptor;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.binding.MethodSignature;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.javapoet.TypeSpecs;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.writing.ComponentNames;
import dagger.internal.codegen.xprocessing.MethodSpecs;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypeElements;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XExecutableParameterElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XFiler;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.HashSet;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Modifier;

final class ComponentHjarGenerator
extends SourceFileGenerator<ComponentDescriptor> {
    @Inject
    ComponentHjarGenerator(XFiler filer, DaggerElements elements, SourceVersion sourceVersion) {
        super(filer, elements, sourceVersion);
    }

    @Override
    public XElement originatingElement(ComponentDescriptor input) {
        return input.typeElement();
    }

    @Override
    public ImmutableList<TypeSpec.Builder> topLevelTypes(ComponentDescriptor componentDescriptor) {
        boolean noArgFactoryMethod;
        ComponentCreatorKind creatorKind;
        ClassName builderMethodReturnType;
        ClassName generatedTypeName = ComponentNames.getRootComponentClassName(componentDescriptor);
        TypeSpec.Builder generatedComponent = TypeSpec.classBuilder((ClassName)generatedTypeName).addModifiers(new Modifier[]{Modifier.FINAL}).addMethod(ComponentHjarGenerator.privateConstructor());
        if (componentDescriptor.typeElement().isPublic()) {
            generatedComponent.addModifiers(new Modifier[]{Modifier.PUBLIC});
        }
        XTypeElement componentElement = componentDescriptor.typeElement();
        TypeSpecs.addSupertype(generatedComponent, componentElement);
        if (componentDescriptor.creatorDescriptor().isPresent()) {
            ComponentCreatorDescriptor creatorDescriptor = componentDescriptor.creatorDescriptor().get();
            builderMethodReturnType = creatorDescriptor.typeElement().getClassName();
            creatorKind = creatorDescriptor.kind();
            noArgFactoryMethod = creatorDescriptor.factoryParameters().isEmpty();
        } else {
            ClassName builderClassName;
            TypeSpec.Builder builder = TypeSpec.classBuilder((String)"Builder").addModifiers(new Modifier[]{Modifier.STATIC, Modifier.FINAL}).addMethod(ComponentHjarGenerator.privateConstructor());
            if (componentDescriptor.typeElement().isPublic()) {
                builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
            }
            builderMethodReturnType = builderClassName = generatedTypeName.nestedClass("Builder");
            creatorKind = ComponentCreatorKind.BUILDER;
            noArgFactoryMethod = true;
            ComponentHjarGenerator.componentRequirements(componentDescriptor).map(requirement -> ComponentHjarGenerator.builderSetterMethod(requirement.typeElement(), builderClassName)).forEach(arg_0 -> ((TypeSpec.Builder)builder).addMethod(arg_0));
            builder.addMethod(ComponentHjarGenerator.builderBuildMethod(componentDescriptor));
            generatedComponent.addType(builder.build());
        }
        generatedComponent.addMethod(ComponentHjarGenerator.staticCreatorMethod((TypeName)builderMethodReturnType, creatorKind));
        if (noArgFactoryMethod && !this.hasBindsInstanceMethods(componentDescriptor) && ComponentHjarGenerator.componentRequirements(componentDescriptor).noneMatch(ComponentRequirement::requiresAPassedInstance)) {
            generatedComponent.addMethod(ComponentHjarGenerator.createMethod(componentDescriptor));
        }
        XType componentType = componentElement.getType();
        HashSet methodSignatures = Sets.newHashSetWithExpectedSize((int)componentDescriptor.componentMethods().size());
        componentDescriptor.componentMethods().stream().filter(method -> methodSignatures.add(MethodSignature.forComponentMethod(method, componentType))).forEach(method -> generatedComponent.addMethod(this.emptyComponentMethod(componentElement, method.methodElement())));
        if (componentDescriptor.isProduction()) {
            generatedComponent.addSuperinterface((TypeName)TypeNames.CANCELLATION_LISTENER).addMethod(ComponentHjarGenerator.onProducerFutureCancelledMethod());
        }
        return ImmutableList.of((Object)generatedComponent);
    }

    private MethodSpec emptyComponentMethod(XTypeElement typeElement, XMethodElement baseMethod) {
        return MethodSpecs.overriding((XMethodElement)baseMethod, (XType)typeElement.getType()).build();
    }

    private static MethodSpec privateConstructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
    }

    private static Stream<ComponentRequirement> componentRequirements(ComponentDescriptor component) {
        Preconditions.checkArgument((!component.isSubcomponent() ? 1 : 0) != 0);
        return Stream.concat(component.dependencies().stream(), component.modules().stream().filter(module -> !module.moduleElement().isAbstract() && Accessibility.isElementAccessibleFrom((XElement)module.moduleElement(), component.typeElement().getClassName().packageName())).map(module -> ComponentRequirement.forModule(module.moduleElement().getType())));
    }

    private boolean hasBindsInstanceMethods(ComponentDescriptor componentDescriptor) {
        return componentDescriptor.creatorDescriptor().isPresent() && XTypeElements.getAllUnimplementedMethods((XTypeElement)componentDescriptor.creatorDescriptor().get().typeElement()).stream().anyMatch(method -> ComponentHjarGenerator.isBindsInstance(method));
    }

    private static boolean isBindsInstance(XMethodElement method) {
        return method.hasAnnotation(TypeNames.BINDS_INSTANCE) || method.getParameters().size() == 1 && ((XExecutableParameterElement)Iterables.getOnlyElement((Iterable)method.getParameters())).hasAnnotation(TypeNames.BINDS_INSTANCE);
    }

    private static MethodSpec builderSetterMethod(XTypeElement componentRequirement, ClassName builderClass) {
        String simpleName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, XElements.getSimpleName((XElement)componentRequirement));
        return MethodSpec.methodBuilder((String)simpleName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)componentRequirement.getClassName(), simpleName, new Modifier[0]).returns((TypeName)builderClass).build();
    }

    private static MethodSpec builderBuildMethod(ComponentDescriptor component) {
        return MethodSpec.methodBuilder((String)"build").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)component.typeElement().getClassName()).build();
    }

    private static MethodSpec staticCreatorMethod(TypeName creatorMethodReturnType, ComponentCreatorKind creatorKind) {
        return MethodSpec.methodBuilder((String)Ascii.toLowerCase((String)creatorKind.typeName())).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(creatorMethodReturnType).build();
    }

    private static MethodSpec createMethod(ComponentDescriptor componentDescriptor) {
        return MethodSpec.methodBuilder((String)"create").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)componentDescriptor.typeElement().getClassName()).build();
    }

    private static MethodSpec onProducerFutureCancelledMethod() {
        return MethodSpec.methodBuilder((String)"onProducerFutureCancelled").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TypeName.BOOLEAN, "mayInterruptIfRunning", new Modifier[0]).build();
    }
}

