/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.bindinggraphvalidation;

import com.google.auto.value.AutoValue;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import dagger.internal.codegen.binding.BindingDeclaration;
import dagger.internal.codegen.binding.BindingDeclarationFormatter;
import dagger.internal.codegen.binding.BindingNode;
import dagger.internal.codegen.binding.MultibindingDeclaration;
import dagger.internal.codegen.bindinggraphvalidation.AutoValue_DuplicateBindingsValidator_BindingElement;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.spi.model.Binding;
import dagger.spi.model.BindingGraph;
import dagger.spi.model.BindingGraphPlugin;
import dagger.spi.model.BindingKind;
import dagger.spi.model.ComponentPath;
import dagger.spi.model.DaggerElement;
import dagger.spi.model.DaggerTypeElement;
import dagger.spi.model.DiagnosticReporter;
import dagger.spi.model.Key;
import java.util.Collection;
import java.util.Comparator;
import java.util.Formatter;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

final class DuplicateBindingsValidator
implements BindingGraphPlugin {
    private static final Comparator<Binding> BY_LENGTH_OF_COMPONENT_PATH = Comparator.comparing(binding -> binding.componentPath().components().size());
    private final BindingDeclarationFormatter bindingDeclarationFormatter;
    private final CompilerOptions compilerOptions;

    @Inject
    DuplicateBindingsValidator(BindingDeclarationFormatter bindingDeclarationFormatter, CompilerOptions compilerOptions) {
        this.bindingDeclarationFormatter = bindingDeclarationFormatter;
        this.compilerOptions = compilerOptions;
    }

    public String pluginName() {
        return "Dagger/DuplicateBindings";
    }

    public void visitGraph(BindingGraph bindingGraph, DiagnosticReporter diagnosticReporter) {
        HashSet reportedDuplicateBindingSets = new HashSet();
        this.duplicateBindingSets(bindingGraph).forEach(duplicateBindings -> {
            if (reportedDuplicateBindingSets.add(duplicateBindings.keySet())) {
                this.reportDuplicateBindings((ImmutableSetMultimap<BindingElement, Binding>)duplicateBindings, bindingGraph, diagnosticReporter);
            }
        });
    }

    private ImmutableSet<ImmutableSetMultimap<BindingElement, Binding>> duplicateBindingSets(BindingGraph bindingGraph) {
        return (ImmutableSet)DuplicateBindingsValidator.groupBindingsByKey(bindingGraph).stream().flatMap(bindings -> DuplicateBindingsValidator.mutuallyVisibleSubsets((Set<Binding>)bindings).stream()).map(BindingElement::index).filter(duplicates -> duplicates.keySet().size() > 1).collect(DaggerStreams.toImmutableSet());
    }

    private static ImmutableSet<ImmutableSet<Binding>> groupBindingsByKey(BindingGraph bindingGraph) {
        return DuplicateBindingsValidator.valueSetsForEachKey((Multimap)bindingGraph.bindings().stream().filter(binding -> !binding.kind().equals((Object)BindingKind.MEMBERS_INJECTION)).collect(DaggerStreams.toImmutableSetMultimap(BindingGraph.MaybeBinding::key, binding -> binding)));
    }

    private static ImmutableSet<ImmutableSet<Binding>> mutuallyVisibleSubsets(Set<Binding> duplicateBindings) {
        ImmutableListMultimap bindingsByComponentPath = Multimaps.index(duplicateBindings, Binding::componentPath);
        ImmutableSetMultimap.Builder mutuallyVisibleBindings = ImmutableSetMultimap.builder();
        bindingsByComponentPath.asMap().forEach((componentPath, bindings) -> {
            mutuallyVisibleBindings.putAll(componentPath, (Iterable)bindings);
            ComponentPath ancestor = componentPath;
            while (!ancestor.atRoot()) {
                ancestor = ancestor.parent();
                ImmutableList bindingsInAncestor = bindingsByComponentPath.get((Object)ancestor);
                mutuallyVisibleBindings.putAll(componentPath, (Iterable)bindingsInAncestor);
            }
        });
        return DuplicateBindingsValidator.valueSetsForEachKey(mutuallyVisibleBindings.build());
    }

    private void reportDuplicateBindings(ImmutableSetMultimap<BindingElement, Binding> duplicateBindings, BindingGraph bindingGraph, DiagnosticReporter diagnosticReporter) {
        String message;
        if (DuplicateBindingsValidator.explicitBindingConfictsWithInject((ImmutableSet<BindingElement>)duplicateBindings.keySet())) {
            this.compilerOptions.explicitBindingConflictsWithInjectValidationType().diagnosticKind().ifPresent(diagnosticKind -> this.reportExplicitBindingConflictsWithInject(duplicateBindings, diagnosticReporter, (Diagnostic.Kind)((Object)diagnosticKind), bindingGraph.rootComponentNode()));
            return;
        }
        ImmutableSet bindings = ImmutableSet.copyOf((Collection)duplicateBindings.values());
        Binding oneBinding = (Binding)bindings.asList().get(0);
        String string = message = bindings.stream().anyMatch(binding -> binding.kind().isMultibinding()) ? this.incompatibleBindingsMessage(oneBinding, (ImmutableSet<Binding>)bindings, bindingGraph) : this.duplicateBindingMessage(oneBinding, (ImmutableSet<Binding>)bindings, bindingGraph);
        if (this.compilerOptions.experimentalDaggerErrorMessages()) {
            diagnosticReporter.reportComponent(Diagnostic.Kind.ERROR, bindingGraph.rootComponentNode(), message);
        } else {
            diagnosticReporter.reportBinding(Diagnostic.Kind.ERROR, (BindingGraph.MaybeBinding)oneBinding, message);
        }
    }

    private static boolean explicitBindingConfictsWithInject(ImmutableSet<BindingElement> duplicateBindings) {
        ImmutableMultiset bindingKinds = Multimaps.index(duplicateBindings, BindingElement::bindingKind).keys();
        return bindingKinds.count((Object)BindingKind.INJECTION) == 1 && bindingKinds.size() == 2;
    }

    private void reportExplicitBindingConflictsWithInject(ImmutableSetMultimap<BindingElement, Binding> duplicateBindings, DiagnosticReporter diagnosticReporter, Diagnostic.Kind diagnosticKind, BindingGraph.ComponentNode rootComponent) {
        Binding injectBinding = DuplicateBindingsValidator.rootmostBindingWithKind(k -> k.equals((Object)BindingKind.INJECTION), (ImmutableCollection<Binding>)duplicateBindings.values());
        Binding explicitBinding = DuplicateBindingsValidator.rootmostBindingWithKind(k -> !k.equals((Object)BindingKind.INJECTION), (ImmutableCollection<Binding>)duplicateBindings.values());
        StringBuilder message = new StringBuilder().append(explicitBinding.key()).append(" is bound multiple times:").append(this.formatWithComponentPath(injectBinding)).append(this.formatWithComponentPath(explicitBinding)).append("\nThis condition was never validated before, and will soon be an error. See https://dagger.dev/conflicting-inject.");
        if (this.compilerOptions.experimentalDaggerErrorMessages()) {
            diagnosticReporter.reportComponent(diagnosticKind, rootComponent, message.toString());
        } else {
            diagnosticReporter.reportBinding(diagnosticKind, (BindingGraph.MaybeBinding)explicitBinding, message.toString());
        }
    }

    private String formatWithComponentPath(Binding binding) {
        return String.format("\n%s%s [%s]", "    ", this.bindingDeclarationFormatter.format(((BindingNode)binding).delegate()), binding.componentPath());
    }

    private String duplicateBindingMessage(Binding oneBinding, ImmutableSet<Binding> duplicateBindings, BindingGraph graph) {
        StringBuilder message = new StringBuilder().append(oneBinding.key()).append(" is bound multiple times:");
        this.formatDeclarations(message, 1, (Iterable<? extends BindingDeclaration>)this.declarations(graph, (Set<Binding>)duplicateBindings));
        if (this.compilerOptions.experimentalDaggerErrorMessages()) {
            message.append(String.format("\n%sin component: [%s]", "    ", oneBinding.componentPath()));
        }
        return message.toString();
    }

    private String incompatibleBindingsMessage(Binding oneBinding, ImmutableSet<Binding> duplicateBindings, BindingGraph graph) {
        Key key = oneBinding.key();
        ImmutableSet multibindings = (ImmutableSet)duplicateBindings.stream().filter(binding -> binding.kind().isMultibinding()).collect(DaggerStreams.toImmutableSet());
        Verify.verify((multibindings.size() == 1 ? 1 : 0) != 0, (String)"expected only one multibinding for %s: %s", (Object)key, (Object)multibindings);
        StringBuilder message = new StringBuilder();
        Formatter messageFormatter = new Formatter(message);
        messageFormatter.format("%s has incompatible bindings or declarations:\n", key);
        message.append("    ");
        Binding multibinding = (Binding)Iterables.getOnlyElement((Iterable)multibindings);
        messageFormatter.format("%s bindings and declarations:", this.multibindingTypeString(multibinding));
        this.formatDeclarations(message, 2, (Iterable<? extends BindingDeclaration>)this.declarations(graph, (Set<Binding>)multibindings));
        Set uniqueBindings = Sets.filter(duplicateBindings, binding -> !binding.equals(multibinding));
        message.append('\n').append("    ").append("Unique bindings and declarations:");
        this.formatDeclarations(message, 2, Sets.filter(this.declarations(graph, uniqueBindings), declaration -> !(declaration instanceof MultibindingDeclaration)));
        if (this.compilerOptions.experimentalDaggerErrorMessages()) {
            message.append(String.format("\n%sin component: [%s]", "    ", oneBinding.componentPath()));
        }
        return message.toString();
    }

    private void formatDeclarations(StringBuilder builder, int indentLevel, Iterable<? extends BindingDeclaration> bindingDeclarations) {
        this.bindingDeclarationFormatter.formatIndentedList(builder, ImmutableList.copyOf(bindingDeclarations), indentLevel);
    }

    private ImmutableSet<BindingDeclaration> declarations(BindingGraph graph, Set<Binding> bindings) {
        return (ImmutableSet)bindings.stream().flatMap(binding -> this.declarations(graph, (Binding)binding).stream()).distinct().sorted(BindingDeclaration.COMPARATOR).collect(DaggerStreams.toImmutableSet());
    }

    private ImmutableSet<BindingDeclaration> declarations(BindingGraph graph, Binding binding) {
        ImmutableSet.Builder declarations = ImmutableSet.builder();
        BindingNode bindingNode = (BindingNode)binding;
        bindingNode.associatedDeclarations().forEach(arg_0 -> ((ImmutableSet.Builder)declarations).add(arg_0));
        if (this.bindingDeclarationFormatter.canFormat(bindingNode.delegate())) {
            declarations.add((Object)bindingNode.delegate());
        } else {
            graph.requestedBindings(binding).stream().flatMap(requestedBinding -> this.declarations(graph, (Binding)requestedBinding).stream()).forEach(arg_0 -> ((ImmutableSet.Builder)declarations).add(arg_0));
        }
        return declarations.build();
    }

    private String multibindingTypeString(Binding multibinding) {
        switch (multibinding.kind()) {
            case MULTIBOUND_MAP: {
                return "Map";
            }
            case MULTIBOUND_SET: {
                return "Set";
            }
        }
        throw new AssertionError(multibinding);
    }

    private static <E> ImmutableSet<ImmutableSet<E>> valueSetsForEachKey(Multimap<?, E> multimap) {
        return (ImmutableSet)multimap.asMap().values().stream().map(ImmutableSet::copyOf).collect(DaggerStreams.toImmutableSet());
    }

    private static Binding rootmostBindingWithKind(Predicate<BindingKind> bindingKindPredicate, ImmutableCollection<Binding> bindings) {
        return bindings.stream().filter(b -> bindingKindPredicate.test(b.kind())).min(BY_LENGTH_OF_COMPONENT_PATH).get();
    }

    @AutoValue
    static abstract class BindingElement {
        BindingElement() {
        }

        abstract BindingKind bindingKind();

        abstract Optional<Element> bindingElement();

        abstract Optional<TypeElement> contributingModule();

        static ImmutableSetMultimap<BindingElement, Binding> index(Set<Binding> bindings) {
            return (ImmutableSetMultimap)bindings.stream().collect(DaggerStreams.toImmutableSetMultimap(BindingElement::forBinding, b -> b));
        }

        private static BindingElement forBinding(Binding binding) {
            return new AutoValue_DuplicateBindingsValidator_BindingElement(binding.kind(), binding.bindingElement().map(DaggerElement::java), binding.contributingModule().map(DaggerTypeElement::java));
        }
    }
}

