/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.model.DaggerAnnotation;
import dagger.spi.model.Key;
import dagger.spi.shaded.androidx.room.compiler.processing.XArrayType;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeKt;
import java.util.Iterator;

public final class KeyVariableNamer {
    private static final ImmutableSet<String> VERY_SIMPLE_NAMES = ImmutableSet.of((Object)"Builder", (Object)"Factory", (Object)"Component", (Object)"Subcomponent", (Object)"Injector");

    private KeyVariableNamer() {
    }

    public static String name(Key key) {
        if (key.multibindingContributionIdentifier().isPresent()) {
            return ((Key.MultibindingContributionIdentifier)key.multibindingContributionIdentifier().get()).bindingElement();
        }
        StringBuilder builder = new StringBuilder();
        if (key.qualifier().isPresent()) {
            builder.append(((DaggerAnnotation)key.qualifier().get()).java().getAnnotationType().asElement().getSimpleName());
        }
        KeyVariableNamer.typeNamer(key.type().xprocessing(), builder);
        return SourceFiles.protectAgainstKeywords(CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, builder.toString()));
    }

    private static void typeNamer(XType type, StringBuilder builder) {
        if (XTypes.isDeclared((XType)type)) {
            XTypeElement element = type.getTypeElement();
            if (element.isNested() && VERY_SIMPLE_NAMES.contains((Object)XElements.getSimpleName((XElement)element))) {
                builder.append(XElements.getSimpleName((XElement)element.getEnclosingTypeElement()));
            }
            builder.append(XElements.getSimpleName((XElement)element));
            Iterator argumentIterator = type.getTypeArguments().iterator();
            if (argumentIterator.hasNext()) {
                builder.append("Of");
                XType first = (XType)argumentIterator.next();
                KeyVariableNamer.typeNamer(first, builder);
                while (argumentIterator.hasNext()) {
                    builder.append("And");
                    KeyVariableNamer.typeNamer((XType)argumentIterator.next(), builder);
                }
            }
        } else if (XTypes.isPrimitive((XType)type)) {
            builder.append(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, type.toString()));
        } else if (XTypeKt.isArray((XType)type)) {
            KeyVariableNamer.typeNamer(((XArrayType)type).getComponentType(), builder);
            builder.append("Array");
        }
    }
}

