/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.auto.service.AutoService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CheckReturnValue;
import dagger.BindsInstance;
import dagger.Component;
import dagger.Module;
import dagger.Provides;
import dagger.internal.codegen.AssistedFactoryProcessingStep;
import dagger.internal.codegen.AssistedInjectProcessingStep;
import dagger.internal.codegen.AssistedProcessingStep;
import dagger.internal.codegen.ComponentHjarProcessingStep;
import dagger.internal.codegen.ComponentProcessingStep;
import dagger.internal.codegen.DaggerComponentProcessor_ProcessorComponent;
import dagger.internal.codegen.InjectProcessingStep;
import dagger.internal.codegen.MapKeyProcessingStep;
import dagger.internal.codegen.ModuleProcessingStep;
import dagger.internal.codegen.ProcessingEnvironmentModule;
import dagger.internal.codegen.ProcessingRoundCacheModule;
import dagger.internal.codegen.ServiceLoaders;
import dagger.internal.codegen.SourceFileGeneratorsModule;
import dagger.internal.codegen.base.ClearableCache;
import dagger.internal.codegen.base.SourceFileGenerationException;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.binding.InjectBindingRegistry;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.bindinggraphvalidation.BindingGraphValidationModule;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.compileroption.ProcessingEnvironmentCompilerOptions;
import dagger.internal.codegen.componentgenerator.ComponentGeneratorModule;
import dagger.internal.codegen.validation.BindingMethodProcessingStep;
import dagger.internal.codegen.validation.BindingMethodValidatorsModule;
import dagger.internal.codegen.validation.BindsInstanceProcessingStep;
import dagger.internal.codegen.validation.ExternalBindingGraphPlugins;
import dagger.internal.codegen.validation.InjectBindingRegistryModule;
import dagger.internal.codegen.validation.MonitoringModuleProcessingStep;
import dagger.internal.codegen.validation.MultibindingAnnotationsProcessingStep;
import dagger.internal.codegen.validation.ValidationBindingGraphPlugins;
import dagger.spi.BindingGraphPlugin;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnvConfig;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingStep;
import dagger.spi.shaded.androidx.room.compiler.processing.XRoundEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.spi.shaded.androidx.room.compiler.processing.javac.JavacBasicAnnotationProcessor;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.Processor;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.lang.model.SourceVersion;

@AutoService(value={Processor.class})
public class ComponentProcessor
extends JavacBasicAnnotationProcessor {
    private final Optional<ImmutableSet<BindingGraphPlugin>> testingPlugins;
    @Inject
    InjectBindingRegistry injectBindingRegistry;
    @Inject
    SourceFileGenerator<ProvisionBinding> factoryGenerator;
    @Inject
    SourceFileGenerator<MembersInjectionBinding> membersInjectorGenerator;
    @Inject
    ImmutableList<XProcessingStep> processingSteps;
    @Inject
    ValidationBindingGraphPlugins validationBindingGraphPlugins;
    @Inject
    ExternalBindingGraphPlugins externalBindingGraphPlugins;
    @Inject
    Set<ClearableCache> clearableCaches;

    private static XProcessingEnvConfig envConfig(Map<String, String> options) {
        return new XProcessingEnvConfig.Builder().disableAnnotatedElementValidation(true).build();
    }

    public ComponentProcessor() {
        super(ComponentProcessor::envConfig);
        this.testingPlugins = Optional.empty();
    }

    private ComponentProcessor(Iterable<BindingGraphPlugin> testingPlugins) {
        super(ComponentProcessor::envConfig);
        this.testingPlugins = Optional.of(ImmutableSet.copyOf(testingPlugins));
    }

    @VisibleForTesting
    public static ComponentProcessor forTesting(BindingGraphPlugin ... testingPlugins) {
        return ComponentProcessor.forTesting(Arrays.asList(testingPlugins));
    }

    @VisibleForTesting
    public static ComponentProcessor forTesting(Iterable<BindingGraphPlugin> testingPlugins) {
        return new ComponentProcessor(testingPlugins);
    }

    public void initialize(XProcessingEnv env) {
        ProcessorComponent.factory().create(env, (ImmutableSet<BindingGraphPlugin>)this.testingPlugins.orElseGet(this::loadExternalPlugins)).inject(this);
    }

    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    public ImmutableSet<String> getSupportedOptions() {
        return ImmutableSet.builder().addAll(ProcessingEnvironmentCompilerOptions.supportedOptions()).addAll(this.validationBindingGraphPlugins.allSupportedOptions()).addAll(this.externalBindingGraphPlugins.allSupportedOptions()).build();
    }

    public Iterable<XProcessingStep> processingSteps() {
        this.validationBindingGraphPlugins.initializePlugins();
        this.externalBindingGraphPlugins.initializePlugins();
        return this.processingSteps;
    }

    private ImmutableSet<BindingGraphPlugin> loadExternalPlugins() {
        return ServiceLoaders.load(this.processingEnv, BindingGraphPlugin.class);
    }

    public void postRound(XProcessingEnv env, XRoundEnv roundEnv) {
        if (!XConverters.toJavac((XRoundEnv)roundEnv).processingOver()) {
            try {
                this.injectBindingRegistry.generateSourcesForRequiredBindings(this.factoryGenerator, this.membersInjectorGenerator);
            }
            catch (SourceFileGenerationException e) {
                e.printMessageTo(env.getMessager());
            }
        }
        this.clearableCaches.forEach(ClearableCache::clearCache);
    }

    @Module
    static interface ProcessingStepsModule {
        @Provides
        public static ImmutableList<XProcessingStep> processingSteps(MapKeyProcessingStep mapKeyProcessingStep, InjectProcessingStep injectProcessingStep, AssistedInjectProcessingStep assistedInjectProcessingStep, AssistedFactoryProcessingStep assistedFactoryProcessingStep, AssistedProcessingStep assistedProcessingStep, MonitoringModuleProcessingStep monitoringModuleProcessingStep, MultibindingAnnotationsProcessingStep multibindingAnnotationsProcessingStep, BindsInstanceProcessingStep bindsInstanceProcessingStep, ModuleProcessingStep moduleProcessingStep, ComponentProcessingStep componentProcessingStep, ComponentHjarProcessingStep componentHjarProcessingStep, BindingMethodProcessingStep bindingMethodProcessingStep, CompilerOptions compilerOptions) {
            return ImmutableList.of((Object)mapKeyProcessingStep, (Object)injectProcessingStep, (Object)assistedInjectProcessingStep, (Object)assistedFactoryProcessingStep, (Object)assistedProcessingStep, (Object)monitoringModuleProcessingStep, (Object)multibindingAnnotationsProcessingStep, (Object)bindsInstanceProcessingStep, (Object)moduleProcessingStep, (Object)(compilerOptions.headerCompilation() ? componentHjarProcessingStep : componentProcessingStep), (Object)bindingMethodProcessingStep);
        }
    }

    @Singleton
    @Component(modules={BindingGraphValidationModule.class, BindingMethodValidatorsModule.class, ComponentGeneratorModule.class, InjectBindingRegistryModule.class, ProcessingEnvironmentModule.class, ProcessingRoundCacheModule.class, ProcessingStepsModule.class, SourceFileGeneratorsModule.class})
    static interface ProcessorComponent {
        public void inject(ComponentProcessor var1);

        public static Factory factory() {
            return DaggerComponentProcessor_ProcessorComponent.factory();
        }

        @Component.Factory
        public static interface Factory {
            @CheckReturnValue
            public ProcessorComponent create(@BindsInstance XProcessingEnv var1, @BindsInstance ImmutableSet<BindingGraphPlugin> var2);
        }
    }
}

