/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.xprocessing;

import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import dagger.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.shaded.androidx.room.compiler.processing.XMethodType;
import dagger.shaded.androidx.room.compiler.processing.XType;
import javax.lang.model.element.Modifier;

public final class MethodSpecs {
    public static MethodSpec.Builder overriding(XMethodElement method, XType owner) {
        XMethodType methodType = method.asMemberOf(owner);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)method.getName()).addAnnotation(Override.class).addTypeVariables(methodType.getTypeVariableNames()).varargs(method.isVarArgs()).returns(methodType.getReturnType().getTypeName());
        if (method.isPublic()) {
            builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        } else if (method.isProtected()) {
            builder.addModifiers(new Modifier[]{Modifier.PROTECTED});
        }
        for (int i = 0; i < methodType.getParameterTypes().size(); ++i) {
            String parameterName = method.getParameters().get(i).getName();
            TypeName parameterType = methodType.getParameterTypes().get(i).getTypeName();
            builder.addParameter(ParameterSpec.builder((TypeName)parameterType, (String)parameterName, (Modifier[])new Modifier[0]).build());
        }
        method.getThrownTypes().stream().map(XType::getTypeName).forEach(arg_0 -> ((MethodSpec.Builder)builder).addException(arg_0));
        return builder;
    }

    private MethodSpecs() {
    }
}

