/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.FormatMethod;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.validation.BindingElementValidator;
import dagger.internal.codegen.validation.DependencyRequestValidator;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XMethodElements;
import dagger.shaded.androidx.room.compiler.processing.XElement;
import dagger.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.shaded.androidx.room.compiler.processing.XType;
import dagger.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.shaded.androidx.room.compiler.processing.XVariableElement;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;

abstract class BindingMethodValidator
extends BindingElementValidator<XMethodElement> {
    private final DaggerTypes types;
    private final DependencyRequestValidator dependencyRequestValidator;
    private final ClassName methodAnnotation;
    private final ImmutableSet<ClassName> enclosingElementAnnotations;
    private final Abstractness abstractness;
    private final ExceptionSuperclass exceptionSuperclass;

    protected BindingMethodValidator(DaggerTypes types, DependencyRequestValidator dependencyRequestValidator, ClassName methodAnnotation, ClassName enclosingElementAnnotation, Abstractness abstractness, ExceptionSuperclass exceptionSuperclass, BindingElementValidator.AllowsMultibindings allowsMultibindings, BindingElementValidator.AllowsScoping allowsScoping, InjectionAnnotations injectionAnnotations) {
        this(types, methodAnnotation, (Iterable<ClassName>)ImmutableSet.of((Object)enclosingElementAnnotation), dependencyRequestValidator, abstractness, exceptionSuperclass, allowsMultibindings, allowsScoping, injectionAnnotations);
    }

    protected BindingMethodValidator(DaggerTypes types, ClassName methodAnnotation, Iterable<ClassName> enclosingElementAnnotations, DependencyRequestValidator dependencyRequestValidator, Abstractness abstractness, ExceptionSuperclass exceptionSuperclass, BindingElementValidator.AllowsMultibindings allowsMultibindings, BindingElementValidator.AllowsScoping allowsScoping, InjectionAnnotations injectionAnnotations) {
        super(methodAnnotation, allowsMultibindings, allowsScoping, injectionAnnotations);
        this.types = types;
        this.methodAnnotation = methodAnnotation;
        this.enclosingElementAnnotations = ImmutableSet.copyOf(enclosingElementAnnotations);
        this.dependencyRequestValidator = dependencyRequestValidator;
        this.abstractness = abstractness;
        this.exceptionSuperclass = exceptionSuperclass;
    }

    final ClassName methodAnnotation() {
        return this.methodAnnotation;
    }

    @FormatMethod
    protected final String bindingMethods(String ruleFormat, Object ... args) {
        return this.bindingElements(ruleFormat, args);
    }

    @Override
    protected final String bindingElements() {
        return String.format("@%s methods", this.methodAnnotation.simpleName());
    }

    @Override
    protected final String bindingElementTypeVerb() {
        return "return";
    }

    protected static enum ExceptionSuperclass {
        NO_EXCEPTIONS{

            @Override
            protected String errorMessage(BindingMethodValidator validator) {
                return validator.bindingMethods("may not throw", new Object[0]);
            }

            @Override
            protected void checkThrows(BindingMethodValidator validator, XExecutableElement element, ValidationReport.Builder report) {
                if (!element.getThrownTypes().isEmpty()) {
                    report.addError(validator.bindingMethods("may not throw", new Object[0]));
                    return;
                }
            }
        }
        ,
        EXCEPTION(TypeNames.EXCEPTION){

            @Override
            protected String errorMessage(BindingMethodValidator validator) {
                return validator.bindingMethods("may only throw unchecked exceptions or exceptions subclassing Exception", new Object[0]);
            }
        }
        ,
        RUNTIME_EXCEPTION(TypeNames.RUNTIME_EXCEPTION){

            @Override
            protected String errorMessage(BindingMethodValidator validator) {
                return validator.bindingMethods("may only throw unchecked exceptions", new Object[0]);
            }
        };

        private final ClassName superclass;

        private ExceptionSuperclass() {
            this((ClassName)null);
        }

        private ExceptionSuperclass(ClassName superclass) {
            this.superclass = superclass;
        }

        protected void checkThrows(BindingMethodValidator validator, XExecutableElement element, ValidationReport.Builder report) {
            XType exceptionSupertype = validator.processingEnv.findType((TypeName)this.superclass);
            XType errorType = validator.processingEnv.findType((TypeName)TypeNames.ERROR);
            for (XType thrownType : element.getThrownTypes()) {
                if (validator.types.isSubtype(thrownType, exceptionSupertype) || validator.types.isSubtype(thrownType, errorType)) continue;
                report.addError(this.errorMessage(validator));
                break;
            }
        }

        protected abstract String errorMessage(BindingMethodValidator var1);
    }

    protected static enum Abstractness {
        MUST_BE_ABSTRACT,
        MUST_BE_CONCRETE;

    }

    protected abstract class MethodValidator
    extends BindingElementValidator.ElementValidator {
        private final XMethodElement method;

        protected MethodValidator(XMethodElement method) {
            super((BindingElementValidator)BindingMethodValidator.this, (XElement)method);
            this.method = method;
        }

        @Override
        protected final Optional<XType> bindingElementType() {
            return Optional.of(this.method.getReturnType());
        }

        @Override
        protected final void checkAdditionalProperties() {
            this.checkEnclosingElement();
            this.checkTypeParameters();
            this.checkNotPrivate();
            this.checkAbstractness();
            this.checkThrows();
            this.checkParameters();
            this.checkAdditionalMethodProperties();
        }

        protected void checkAdditionalMethodProperties() {
        }

        private void checkEnclosingElement() {
            XTypeElement enclosingTypeElement2 = XMethodElements.getEnclosingTypeElement(this.method);
            if (enclosingTypeElement2.isCompanionObject()) {
                enclosingTypeElement2 = enclosingTypeElement2.getEnclosingTypeElement();
            }
            if (!XElements.hasAnyAnnotation(enclosingTypeElement2, (Collection<ClassName>)BindingMethodValidator.this.enclosingElementAnnotations)) {
                this.report.addError(BindingMethodValidator.this.bindingMethods("can only be present within a @%s", BindingMethodValidator.this.enclosingElementAnnotations.stream().map(ClassName::simpleName).collect(Collectors.joining(" or @"))));
            }
        }

        private void checkTypeParameters() {
            if (XMethodElements.hasTypeParameters(this.method)) {
                this.report.addError(BindingMethodValidator.this.bindingMethods("may not have type parameters", new Object[0]));
            }
        }

        private void checkNotPrivate() {
            if (this.method.isPrivate()) {
                this.report.addError(BindingMethodValidator.this.bindingMethods("cannot be private", new Object[0]));
            }
        }

        private void checkAbstractness() {
            boolean isAbstract = this.method.isAbstract();
            switch (BindingMethodValidator.this.abstractness) {
                case MUST_BE_ABSTRACT: {
                    if (isAbstract) break;
                    this.report.addError(BindingMethodValidator.this.bindingMethods("must be abstract", new Object[0]));
                    break;
                }
                case MUST_BE_CONCRETE: {
                    if (!isAbstract) break;
                    this.report.addError(BindingMethodValidator.this.bindingMethods("cannot be abstract", new Object[0]));
                }
            }
        }

        private void checkThrows() {
            BindingMethodValidator.this.exceptionSuperclass.checkThrows(BindingMethodValidator.this, this.method, this.report);
        }

        protected void checkParameters() {
            for (XVariableElement xVariableElement : this.method.getParameters()) {
                this.checkParameter(xVariableElement);
            }
        }

        protected void checkParameter(XVariableElement parameter) {
            BindingMethodValidator.this.dependencyRequestValidator.validateDependencyRequest(this.report, parameter, parameter.getType());
        }
    }
}

