/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.base.ClearableCache;
import dagger.internal.codegen.base.Util;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.validation.BindingMethodValidator;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.shaded.androidx.room.compiler.processing.XMethodElement;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public final class AnyBindingMethodValidator
implements ClearableCache {
    private final ImmutableMap<ClassName, BindingMethodValidator> validators;
    private final Map<XMethodElement, ValidationReport> reports = new HashMap<XMethodElement, ValidationReport>();

    @Inject
    AnyBindingMethodValidator(ImmutableMap<ClassName, BindingMethodValidator> validators) {
        this.validators = validators;
    }

    @Override
    public void clearCache() {
        this.reports.clear();
    }

    ImmutableSet<ClassName> methodAnnotations() {
        return this.validators.keySet();
    }

    boolean isBindingMethod(XExecutableElement method) {
        return XElements.hasAnyAnnotation(method, this.methodAnnotations());
    }

    ValidationReport validate(XMethodElement method) {
        return Util.reentrantComputeIfAbsent(this.reports, method, this::validateUncached);
    }

    boolean wasAlreadyValidated(XMethodElement method) {
        return this.reports.containsKey(method);
    }

    private ValidationReport validateUncached(XMethodElement method) {
        ValidationReport.Builder report = ValidationReport.about(method);
        ImmutableSet bindingMethodAnnotations = (ImmutableSet)this.methodAnnotations().stream().filter(method::hasAnnotation).collect(DaggerStreams.toImmutableSet());
        switch (bindingMethodAnnotations.size()) {
            case 0: {
                throw new IllegalArgumentException(String.format("%s has no binding method annotation", method));
            }
            case 1: {
                report.addSubreport(((BindingMethodValidator)this.validators.get(Iterables.getOnlyElement((Iterable)bindingMethodAnnotations))).validate(method));
                break;
            }
            default: {
                report.addError(String.format("%s is annotated with more than one of (%s)", method.getName(), this.methodAnnotations().stream().map(ClassName::canonicalName).collect(Collectors.joining(", "))), method);
            }
        }
        return report.build();
    }
}

