/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.base.ComponentAnnotation;
import dagger.internal.codegen.base.ModuleAnnotation;
import dagger.internal.codegen.base.MoreAnnotationMirrors;
import dagger.internal.codegen.binding.ComponentCreatorAnnotation;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.shaded.androidx.room.compiler.processing.XElement;
import dagger.shaded.androidx.room.compiler.processing.XType;
import dagger.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.shaded.auto.common.MoreElements;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public final class ConfigurationAnnotations {
    public static Optional<XTypeElement> getSubcomponentCreator(XTypeElement subcomponent) {
        Preconditions.checkArgument((boolean)ComponentAnnotation.subcomponentAnnotation(subcomponent).isPresent());
        return subcomponent.getEnclosedTypeElements().stream().filter(ConfigurationAnnotations::isSubcomponentCreator).findFirst();
    }

    public static Optional<TypeElement> getSubcomponentCreator(TypeElement subcomponent) {
        Preconditions.checkArgument((boolean)ComponentAnnotation.subcomponentAnnotation(subcomponent).isPresent());
        return ElementFilter.typesIn(subcomponent.getEnclosedElements()).stream().filter(ConfigurationAnnotations::isSubcomponentCreator).findFirst();
    }

    static boolean isSubcomponentCreator(XElement element) {
        return ConfigurationAnnotations.isSubcomponentCreator(XConverters.toJavac(element));
    }

    static boolean isSubcomponentCreator(Element element) {
        return DaggerElements.isAnyAnnotationPresent(element, ComponentCreatorAnnotation.subcomponentCreatorAnnotations());
    }

    public static ImmutableList<TypeMirror> getModuleInjects(AnnotationMirror moduleAnnotation) {
        Preconditions.checkNotNull((Object)moduleAnnotation);
        return MoreAnnotationMirrors.getTypeListValue(moduleAnnotation, "injects");
    }

    public static Optional<XAnnotation> getNullableAnnotation(XElement element) {
        return element.getAllAnnotations().stream().filter(annotation -> annotation.getName().contentEquals("Nullable")).findFirst();
    }

    public static Optional<XType> getNullableType(XElement element) {
        return ConfigurationAnnotations.getNullableAnnotation(element).map(XAnnotation::getType);
    }

    public static Optional<DeclaredType> getNullableType(Element element) {
        List<? extends AnnotationMirror> mirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : mirrors) {
            if (!annotationMirror.getAnnotationType().asElement().getSimpleName().contentEquals("Nullable")) continue;
            return Optional.of(annotationMirror.getAnnotationType());
        }
        return Optional.empty();
    }

    @Deprecated
    public static ImmutableSet<TypeElement> getTransitiveModules(DaggerTypes types, DaggerElements elements, Iterable<TypeElement> seedModules) {
        TypeMirror objectType = elements.getTypeElement(TypeName.OBJECT).asType();
        ArrayDeque moduleQueue = new ArrayDeque();
        Iterables.addAll(moduleQueue, seedModules);
        LinkedHashSet moduleElements = Sets.newLinkedHashSet();
        for (TypeElement moduleElement : Iterables.consumingIterable(moduleQueue)) {
            ModuleAnnotation.moduleAnnotation(moduleElement).ifPresent(moduleAnnotation -> {
                ImmutableSet.Builder moduleDependenciesBuilder = ImmutableSet.builder();
                moduleDependenciesBuilder.addAll(moduleAnnotation.includes());
                ConfigurationAnnotations.addIncludesFromSuperclasses(types, moduleElement, (ImmutableSet.Builder<TypeElement>)moduleDependenciesBuilder, objectType);
                ImmutableSet moduleDependencies = moduleDependenciesBuilder.build();
                moduleElements.add(moduleElement);
                for (TypeElement dependencyType : moduleDependencies) {
                    if (moduleElements.contains(dependencyType)) continue;
                    moduleQueue.add(dependencyType);
                }
            });
        }
        return ImmutableSet.copyOf((Collection)moduleElements);
    }

    public static ImmutableSet<XTypeElement> enclosedAnnotatedTypes(XTypeElement typeElement2, ImmutableSet<ClassName> annotations2) {
        return (ImmutableSet)typeElement2.getEnclosedTypeElements().stream().filter(enclosedType -> XElements.hasAnyAnnotation(enclosedType, (Collection<ClassName>)annotations2)).collect(DaggerStreams.toImmutableSet());
    }

    private static void addIncludesFromSuperclasses(DaggerTypes types, TypeElement element, ImmutableSet.Builder<TypeElement> builder, TypeMirror objectType) {
        TypeMirror superclass = element.getSuperclass();
        while (!types.isSameType(objectType, superclass) && superclass.getKind().equals((Object)TypeKind.DECLARED)) {
            element = MoreElements.asType(types.asElement(superclass));
            ModuleAnnotation.moduleAnnotation(element).ifPresent(moduleAnnotation -> builder.addAll(moduleAnnotation.includes()));
            superclass = element.getSuperclass();
        }
    }

    private ConfigurationAnnotations() {
    }
}

