/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.binding.ModuleKind;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.EnumSet;
import java.util.Optional;

public enum ComponentKind {
    COMPONENT(TypeNames.COMPONENT, true, false),
    SUBCOMPONENT(TypeNames.SUBCOMPONENT, false, false),
    PRODUCTION_COMPONENT(TypeNames.PRODUCTION_COMPONENT, true, true),
    PRODUCTION_SUBCOMPONENT(TypeNames.PRODUCTION_SUBCOMPONENT, false, true),
    MODULE(TypeNames.MODULE, true, false),
    PRODUCER_MODULE(TypeNames.PRODUCER_MODULE, true, true);

    private static final ImmutableSet<ComponentKind> ROOT_COMPONENT_KINDS;
    private static final ImmutableSet<ComponentKind> SUBCOMPONENT_KINDS;
    private final ClassName annotation;
    private final boolean isRoot;
    private final boolean production;

    public static ImmutableSet<ComponentKind> rootComponentKinds() {
        return ROOT_COMPONENT_KINDS;
    }

    public static ImmutableSet<ComponentKind> subcomponentKinds() {
        return SUBCOMPONENT_KINDS;
    }

    public static ImmutableSet<ClassName> annotationsFor(Iterable<ComponentKind> kinds) {
        return (ImmutableSet)DaggerStreams.stream(kinds).map(ComponentKind::annotation).collect(DaggerStreams.toImmutableSet());
    }

    public static ImmutableSet<ComponentKind> getComponentKinds(XTypeElement element) {
        return (ImmutableSet)DaggerStreams.valuesOf(ComponentKind.class).filter(kind -> element.hasAnnotation(kind.annotation())).collect(DaggerStreams.toImmutableSet());
    }

    public static Optional<ComponentKind> forAnnotatedElement(XTypeElement element) {
        ImmutableSet<ComponentKind> kinds = ComponentKind.getComponentKinds(element);
        if (kinds.size() > 1) {
            throw new IllegalArgumentException(element + " cannot be annotated with more than one of " + ComponentKind.annotationsFor(kinds));
        }
        return kinds.stream().findAny();
    }

    private ComponentKind(ClassName annotation, boolean isRoot, boolean production) {
        this.annotation = annotation;
        this.isRoot = isRoot;
        this.production = production;
    }

    public ClassName annotation() {
        return this.annotation;
    }

    public ImmutableSet<ModuleKind> legalModuleKinds() {
        return this.isProducer() ? Sets.immutableEnumSet(EnumSet.allOf(ModuleKind.class)) : Sets.immutableEnumSet((Enum)ModuleKind.MODULE, (Enum[])new ModuleKind[0]);
    }

    public ImmutableSet<ComponentKind> legalSubcomponentKinds() {
        return this.isProducer() ? Sets.immutableEnumSet((Enum)PRODUCTION_SUBCOMPONENT, (Enum[])new ComponentKind[0]) : Sets.immutableEnumSet((Enum)SUBCOMPONENT, (Enum[])new ComponentKind[]{PRODUCTION_SUBCOMPONENT});
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public boolean isProducer() {
        return this.production;
    }

    public boolean isForModuleValidation() {
        switch (this) {
            case MODULE: 
            case PRODUCER_MODULE: {
                return true;
            }
        }
        return false;
    }

    static {
        ROOT_COMPONENT_KINDS = (ImmutableSet)DaggerStreams.valuesOf(ComponentKind.class).filter(kind -> !kind.isForModuleValidation()).filter(kind -> kind.isRoot()).collect(DaggerStreams.toImmutableSet());
        SUBCOMPONENT_KINDS = (ImmutableSet)DaggerStreams.valuesOf(ComponentKind.class).filter(kind -> !kind.isForModuleValidation()).filter(kind -> !kind.isRoot()).collect(DaggerStreams.toImmutableSet());
    }
}

