/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.base.ContributionType;
import dagger.internal.codegen.base.MapType;
import dagger.internal.codegen.base.MoreAnnotationMirrors;
import dagger.internal.codegen.base.Scopes;
import dagger.internal.codegen.base.SetType;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.BindingType;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.binding.ConfigurationAnnotations;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.DelegateDeclaration;
import dagger.internal.codegen.binding.DependencyRequestFactory;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.binding.InjectionSiteFactory;
import dagger.internal.codegen.binding.KeyFactory;
import dagger.internal.codegen.binding.MapKeys;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.binding.ProductionBinding;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.binding.SubcomponentDeclaration;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.kotlin.KotlinMetadataUtil;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.shaded.androidx.room.compiler.processing.XElement;
import dagger.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.shaded.androidx.room.compiler.processing.XVariableElement;
import dagger.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import dagger.spi.model.BindingKind;
import dagger.spi.model.DaggerType;
import dagger.spi.model.DependencyRequest;
import dagger.spi.model.Key;
import dagger.spi.model.RequestKind;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public final class BindingFactory {
    private final DaggerTypes types;
    private final KeyFactory keyFactory;
    private final DependencyRequestFactory dependencyRequestFactory;
    private final InjectionSiteFactory injectionSiteFactory;
    private final DaggerElements elements;
    private final InjectionAnnotations injectionAnnotations;
    private final KotlinMetadataUtil metadataUtil;

    @Inject
    BindingFactory(DaggerTypes types, DaggerElements elements, KeyFactory keyFactory, DependencyRequestFactory dependencyRequestFactory, InjectionSiteFactory injectionSiteFactory, InjectionAnnotations injectionAnnotations, KotlinMetadataUtil metadataUtil) {
        this.types = types;
        this.elements = elements;
        this.keyFactory = keyFactory;
        this.dependencyRequestFactory = dependencyRequestFactory;
        this.injectionSiteFactory = injectionSiteFactory;
        this.injectionAnnotations = injectionAnnotations;
        this.metadataUtil = metadataUtil;
    }

    public ProvisionBinding injectionBinding(ExecutableElement constructorElement, Optional<TypeMirror> resolvedType) {
        Preconditions.checkArgument((boolean)constructorElement.getKind().equals((Object)ElementKind.CONSTRUCTOR));
        Preconditions.checkArgument((MoreElements.isAnnotationPresent(constructorElement, Inject.class) || MoreElements.isAnnotationPresent(constructorElement, AssistedInject.class) ? 1 : 0) != 0);
        Preconditions.checkArgument((!this.injectionAnnotations.getQualifier(constructorElement).isPresent() ? 1 : 0) != 0);
        ExecutableType constructorType = MoreTypes.asExecutable(constructorElement.asType());
        DeclaredType constructedType = MoreTypes.asDeclared(constructorElement.getEnclosingElement().asType());
        if (!constructedType.getTypeArguments().isEmpty() && resolvedType.isPresent()) {
            DeclaredType resolved = MoreTypes.asDeclared(resolvedType.get());
            Preconditions.checkState((boolean)this.types.isSameType(this.types.erasure(resolved), this.types.erasure(constructedType)), (String)"erased expected type: %s, erased actual type: %s", (Object)this.types.erasure(resolved), (Object)this.types.erasure(constructedType));
            constructorType = MoreTypes.asExecutable(this.types.asMemberOf(resolved, constructorElement));
            constructedType = resolved;
        }
        ImmutableSet.Builder provisionDependencies = ImmutableSet.builder();
        for (int i = 0; i < constructorElement.getParameters().size(); ++i) {
            VariableElement parameter = constructorElement.getParameters().get(i);
            TypeMirror parameterType = constructorType.getParameterTypes().get(i);
            if (AssistedInjectionAnnotations.isAssistedParameter(parameter)) continue;
            provisionDependencies.add((Object)this.dependencyRequestFactory.forRequiredResolvedVariable(parameter, parameterType));
        }
        Key key = this.keyFactory.forInjectConstructorWithResolvedType(constructedType);
        ProvisionBinding.Builder builder = ((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)ProvisionBinding.builder().contributionType(ContributionType.UNIQUE)).bindingElement(constructorElement)).key(key)).provisionDependencies((Iterable<DependencyRequest>)provisionDependencies.build()).injectionSites(this.injectionSiteFactory.getInjectionSites(constructedType)).kind(MoreElements.isAnnotationPresent(constructorElement, AssistedInject.class) ? BindingKind.ASSISTED_INJECTION : BindingKind.INJECTION)).scope(Scopes.uniqueScopeOf(constructorElement.getEnclosingElement()));
        if (BindingFactory.hasNonDefaultTypeParameters(key.type().java(), this.types)) {
            builder.unresolved(this.injectionBinding(constructorElement, Optional.empty()));
        }
        return (ProvisionBinding)builder.build();
    }

    public ProvisionBinding assistedFactoryBinding(TypeElement factory, Optional<TypeMirror> resolvedType) {
        DeclaredType factoryType = MoreTypes.asDeclared(factory.asType());
        if (!factoryType.getTypeArguments().isEmpty() && resolvedType.isPresent()) {
            DeclaredType resolved = MoreTypes.asDeclared(resolvedType.get());
            Preconditions.checkState((boolean)this.types.isSameType(this.types.erasure(resolved), this.types.erasure(factoryType)), (String)"erased expected type: %s, erased actual type: %s", (Object)this.types.erasure(resolved), (Object)this.types.erasure(factoryType));
            factoryType = resolved;
        }
        ExecutableElement factoryMethod = AssistedInjectionAnnotations.assistedFactoryMethod(factory, this.elements);
        ExecutableType factoryMethodType = MoreTypes.asExecutable(this.types.asMemberOf(factoryType, factoryMethod));
        return (ProvisionBinding)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)ProvisionBinding.builder().contributionType(ContributionType.UNIQUE)).key(Key.builder((DaggerType)DaggerType.fromJava((TypeMirror)factoryType)).build())).bindingElement(factory)).provisionDependencies((Iterable<DependencyRequest>)ImmutableSet.of((Object)DependencyRequest.builder().key(Key.builder((DaggerType)DaggerType.fromJava((TypeMirror)factoryMethodType.getReturnType())).build()).kind(RequestKind.PROVIDER).build())).kind(BindingKind.ASSISTED_FACTORY)).build();
    }

    public ProvisionBinding providesMethodBinding(XMethodElement providesMethod, XTypeElement contributedBy) {
        return this.providesMethodBinding(XConverters.toJavac(providesMethod), XConverters.toJavac(contributedBy));
    }

    public ProvisionBinding providesMethodBinding(ExecutableElement providesMethod, TypeElement contributedBy) {
        return (ProvisionBinding)((ProvisionBinding.Builder)((ProvisionBinding.Builder)this.setMethodBindingProperties(ProvisionBinding.builder(), providesMethod, contributedBy, this.keyFactory.forProvidesMethod(providesMethod, contributedBy), this::providesMethodBinding).kind(BindingKind.PROVISION)).scope(Scopes.uniqueScopeOf(providesMethod)).nullableType(ConfigurationAnnotations.getNullableType(providesMethod))).build();
    }

    public ProductionBinding producesMethodBinding(XMethodElement producesMethod, XTypeElement contributedBy) {
        return this.producesMethodBinding(XConverters.toJavac(producesMethod), XConverters.toJavac(contributedBy));
    }

    public ProductionBinding producesMethodBinding(ExecutableElement producesMethod, TypeElement contributedBy) {
        ProductionBinding.Builder builder = ((ProductionBinding.Builder)this.setMethodBindingProperties(ProductionBinding.builder(), producesMethod, contributedBy, this.keyFactory.forProducesMethod(producesMethod, contributedBy), this::producesMethodBinding).kind(BindingKind.PRODUCTION)).productionKind(ProductionBinding.ProductionKind.fromProducesMethod(producesMethod)).thrownTypes(producesMethod.getThrownTypes()).executorRequest(this.dependencyRequestFactory.forProductionImplementationExecutor()).monitorRequest(this.dependencyRequestFactory.forProductionComponentMonitor());
        return (ProductionBinding)builder.build();
    }

    private <C extends ContributionBinding, B extends ContributionBinding.Builder<C, B>> B setMethodBindingProperties(B builder, ExecutableElement method, TypeElement contributedBy, Key key, BiFunction<ExecutableElement, TypeElement, C> create) {
        Preconditions.checkArgument((boolean)method.getKind().equals((Object)ElementKind.METHOD));
        ExecutableType methodType = MoreTypes.asExecutable(this.types.asMemberOf(MoreTypes.asDeclared(contributedBy.asType()), method));
        if (!this.types.isSameType(methodType, method.asType())) {
            builder.unresolved((ContributionBinding)((ContributionBinding)create.apply(method, MoreElements.asType(method.getEnclosingElement()))));
        }
        boolean isKotlinObject = this.metadataUtil.isObjectClass(contributedBy) || this.metadataUtil.isCompanionObjectClass(contributedBy);
        return ((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)builder.contributionType(ContributionType.fromBindingElement(method))).bindingElement(method)).contributingModule(contributedBy)).isContributingModuleKotlinObject(isKotlinObject)).key(key)).dependencies((Iterable<DependencyRequest>)this.dependencyRequestFactory.forRequiredResolvedVariables(method.getParameters(), methodType.getParameterTypes()))).wrappedMapKeyAnnotation(MoreAnnotationMirrors.wrapOptionalInEquivalence(MapKeys.getMapKey(method)));
    }

    public ContributionBinding syntheticMultibinding(Key key, Iterable<ContributionBinding> multibindingContributions) {
        ContributionBinding.Builder builder = this.multibindingRequiresProduction(key, multibindingContributions) ? ProductionBinding.builder() : ProvisionBinding.builder();
        return ((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)builder.contributionType(ContributionType.UNIQUE)).key(key)).dependencies((Iterable<DependencyRequest>)this.dependencyRequestFactory.forMultibindingContributions(key, multibindingContributions))).kind(BindingFactory.bindingKindForMultibindingKey(key))).build();
    }

    private static BindingKind bindingKindForMultibindingKey(Key key) {
        if (SetType.isSet(key)) {
            return BindingKind.MULTIBOUND_SET;
        }
        if (MapType.isMap(key)) {
            return BindingKind.MULTIBOUND_MAP;
        }
        throw new IllegalArgumentException(String.format("key is not for a set or map: %s", key));
    }

    private boolean multibindingRequiresProduction(Key key, Iterable<ContributionBinding> multibindingContributions) {
        MapType mapType;
        if (MapType.isMap(key) ? (mapType = MapType.from(key)).valuesAreTypeOf(TypeNames.PRODUCER) || mapType.valuesAreTypeOf(TypeNames.PRODUCED) : SetType.isSet(key) && SetType.from(key).elementsAreTypeOf(TypeNames.PRODUCED)) {
            return true;
        }
        return Iterables.any(multibindingContributions, binding -> binding.bindingType().equals((Object)BindingType.PRODUCTION));
    }

    public ProvisionBinding componentBinding(XTypeElement componentDefinitionType) {
        Preconditions.checkNotNull((Object)componentDefinitionType);
        return (ProvisionBinding)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)ProvisionBinding.builder().contributionType(ContributionType.UNIQUE)).bindingElement(XConverters.toJavac(componentDefinitionType))).key(this.keyFactory.forType(XConverters.toJavac(componentDefinitionType.getType())))).kind(BindingKind.COMPONENT)).build();
    }

    public ProvisionBinding componentDependencyBinding(ComponentRequirement dependency) {
        Preconditions.checkNotNull((Object)dependency);
        return (ProvisionBinding)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)ProvisionBinding.builder().contributionType(ContributionType.UNIQUE)).bindingElement(dependency.typeElement())).key(this.keyFactory.forType(dependency.type()))).kind(BindingKind.COMPONENT_DEPENDENCY)).build();
    }

    public ContributionBinding componentDependencyMethodBinding(ComponentDescriptor componentDescriptor, ExecutableElement dependencyMethod) {
        Preconditions.checkArgument((boolean)dependencyMethod.getKind().equals((Object)ElementKind.METHOD));
        Preconditions.checkArgument((boolean)dependencyMethod.getParameters().isEmpty());
        ContributionBinding.Builder builder = componentDescriptor.isProduction() && ComponentDescriptor.isComponentProductionMethod(dependencyMethod) ? ((ProductionBinding.Builder)((ProductionBinding.Builder)ProductionBinding.builder().key(this.keyFactory.forProductionComponentMethod(dependencyMethod))).kind(BindingKind.COMPONENT_PRODUCTION)).thrownTypes(dependencyMethod.getThrownTypes()) : ((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)ProvisionBinding.builder().key(this.keyFactory.forComponentMethod(dependencyMethod))).nullableType(ConfigurationAnnotations.getNullableType(dependencyMethod))).kind(BindingKind.COMPONENT_PROVISION)).scope(Scopes.uniqueScopeOf(dependencyMethod));
        return ((ContributionBinding.Builder)((ContributionBinding.Builder)builder.contributionType(ContributionType.UNIQUE)).bindingElement(dependencyMethod)).build();
    }

    ProvisionBinding boundInstanceBinding(ComponentRequirement requirement, XElement element) {
        Preconditions.checkArgument((XElementKt.isVariableElement(element) || XElementKt.isMethod(element) ? 1 : 0) != 0);
        XVariableElement parameterElement = XElementKt.isVariableElement(element) ? XElements.asVariable(element) : (XVariableElement)Iterables.getOnlyElement(XElements.asMethod(element).getParameters());
        return (ProvisionBinding)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)ProvisionBinding.builder().contributionType(ContributionType.UNIQUE)).bindingElement(XConverters.toJavac(element))).key(requirement.key().get())).nullableType(ConfigurationAnnotations.getNullableType(parameterElement).map(XConverters::toJavac).map(MoreTypes::asDeclared))).kind(BindingKind.BOUND_INSTANCE)).build();
    }

    ProvisionBinding subcomponentCreatorBinding(ExecutableElement subcomponentCreatorMethod, TypeElement component) {
        Preconditions.checkArgument((boolean)subcomponentCreatorMethod.getKind().equals((Object)ElementKind.METHOD));
        Preconditions.checkArgument((boolean)subcomponentCreatorMethod.getParameters().isEmpty());
        Key key = this.keyFactory.forSubcomponentCreatorMethod(subcomponentCreatorMethod, MoreTypes.asDeclared(component.asType()));
        return (ProvisionBinding)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)ProvisionBinding.builder().contributionType(ContributionType.UNIQUE)).bindingElement(subcomponentCreatorMethod)).key(key)).kind(BindingKind.SUBCOMPONENT_CREATOR)).build();
    }

    ProvisionBinding subcomponentCreatorBinding(ImmutableSet<SubcomponentDeclaration> subcomponentDeclarations) {
        SubcomponentDeclaration subcomponentDeclaration = (SubcomponentDeclaration)subcomponentDeclarations.iterator().next();
        return (ProvisionBinding)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)ProvisionBinding.builder().contributionType(ContributionType.UNIQUE)).key(subcomponentDeclaration.key())).kind(BindingKind.SUBCOMPONENT_CREATOR)).build();
    }

    ContributionBinding delegateBinding(DelegateDeclaration delegateDeclaration, ContributionBinding actualBinding) {
        switch (actualBinding.bindingType()) {
            case PRODUCTION: {
                return this.buildDelegateBinding((ContributionBinding.Builder<?, ?>)ProductionBinding.builder().nullableType(actualBinding.nullableType()), delegateDeclaration, TypeNames.PRODUCER);
            }
            case PROVISION: {
                return this.buildDelegateBinding((ContributionBinding.Builder<?, ?>)ProvisionBinding.builder().scope(Scopes.uniqueScopeOf(delegateDeclaration.bindingElement().get())).nullableType(actualBinding.nullableType()), delegateDeclaration, TypeNames.PROVIDER);
            }
        }
        throw new AssertionError((Object)("bindingType: " + actualBinding));
    }

    public ContributionBinding unresolvedDelegateBinding(DelegateDeclaration delegateDeclaration) {
        return this.buildDelegateBinding(ProvisionBinding.builder().scope(Scopes.uniqueScopeOf(delegateDeclaration.bindingElement().get())), delegateDeclaration, TypeNames.PROVIDER);
    }

    private ContributionBinding buildDelegateBinding(ContributionBinding.Builder<?, ?> builder, DelegateDeclaration delegateDeclaration, ClassName frameworkType) {
        boolean isKotlinObject = this.metadataUtil.isObjectClass(delegateDeclaration.contributingModule().get()) || this.metadataUtil.isCompanionObjectClass(delegateDeclaration.contributingModule().get());
        return ((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)builder.contributionType(delegateDeclaration.contributionType())).bindingElement(delegateDeclaration.bindingElement().get())).contributingModule(delegateDeclaration.contributingModule().get())).isContributingModuleKotlinObject(isKotlinObject)).key(this.keyFactory.forDelegateBinding(delegateDeclaration, frameworkType))).dependencies(delegateDeclaration.delegateRequest())).wrappedMapKeyAnnotation(delegateDeclaration.wrappedMapKey())).kind(BindingKind.DELEGATE)).build();
    }

    ContributionBinding syntheticOptionalBinding(Key key, RequestKind requestKind, ImmutableCollection<? extends Binding> underlyingKeyBindings) {
        if (underlyingKeyBindings.isEmpty()) {
            return ((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)ProvisionBinding.builder().contributionType(ContributionType.UNIQUE)).key(key)).kind(BindingKind.OPTIONAL)).build();
        }
        boolean requiresProduction = underlyingKeyBindings.stream().anyMatch(binding -> binding.bindingType() == BindingType.PRODUCTION) || requestKind.equals((Object)RequestKind.PRODUCER) || requestKind.equals((Object)RequestKind.PRODUCED);
        return ((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)(requiresProduction ? ProductionBinding.builder() : ProvisionBinding.builder()).contributionType(ContributionType.UNIQUE)).key(key)).kind(BindingKind.OPTIONAL)).dependencies(this.dependencyRequestFactory.forSyntheticPresentOptionalBinding(key, requestKind))).build();
    }

    public ProvisionBinding membersInjectorBinding(Key key, MembersInjectionBinding membersInjectionBinding) {
        return (ProvisionBinding)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)ProvisionBinding.builder().key(key)).contributionType(ContributionType.UNIQUE)).kind(BindingKind.MEMBERS_INJECTOR)).bindingElement(MoreTypes.asTypeElement(membersInjectionBinding.key().type().java()))).provisionDependencies((Iterable<DependencyRequest>)membersInjectionBinding.dependencies()).injectionSites(membersInjectionBinding.injectionSites()).build();
    }

    public MembersInjectionBinding membersInjectionBinding(DeclaredType declaredType, Optional<TypeMirror> resolvedType) {
        if (!declaredType.getTypeArguments().isEmpty() && resolvedType.isPresent()) {
            DeclaredType resolved = MoreTypes.asDeclared(resolvedType.get());
            Preconditions.checkState((boolean)this.types.isSameType(this.types.erasure(resolved), this.types.erasure(declaredType)), (String)"erased expected type: %s, erased actual type: %s", (Object)this.types.erasure(resolved), (Object)this.types.erasure(declaredType));
            declaredType = resolved;
        }
        ImmutableSortedSet<MembersInjectionBinding.InjectionSite> injectionSites = this.injectionSiteFactory.getInjectionSites(declaredType);
        ImmutableSet dependencies = (ImmutableSet)injectionSites.stream().flatMap(injectionSite -> injectionSite.dependencies().stream()).collect(DaggerStreams.toImmutableSet());
        Key key = this.keyFactory.forMembersInjectedType(declaredType);
        TypeElement typeElement2 = MoreTypes.asTypeElement(declaredType);
        return MembersInjectionBinding.create(key, (ImmutableSet<DependencyRequest>)dependencies, BindingFactory.hasNonDefaultTypeParameters(key.type().java(), this.types) ? Optional.of(this.membersInjectionBinding(MoreTypes.asDeclared(typeElement2.asType()), Optional.empty())) : Optional.empty(), injectionSites);
    }

    private static boolean hasNonDefaultTypeParameters(TypeMirror type2, DaggerTypes types) {
        ImmutableList actualTypes;
        if (type2.getKind() != TypeKind.DECLARED) {
            return false;
        }
        TypeElement element = MoreTypes.asTypeElement(type2);
        if (element.getTypeParameters().isEmpty()) {
            return false;
        }
        ImmutableList defaultTypes = (ImmutableList)element.getTypeParameters().stream().map(Element::asType).collect(DaggerStreams.toImmutableList());
        ImmutableList immutableList = actualTypes = type2.getKind() == TypeKind.DECLARED ? ImmutableList.copyOf(MoreTypes.asDeclared(type2).getTypeArguments()) : ImmutableList.of();
        if (defaultTypes.size() != actualTypes.size()) {
            return true;
        }
        for (int i = 0; i < defaultTypes.size(); ++i) {
            if (types.isSameType((TypeMirror)defaultTypes.get(i), (TypeMirror)actualTypes.get(i))) continue;
            return true;
        }
        return false;
    }
}

