/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.auto.value.AutoValue;
import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.base.MoreAnnotationValues;
import dagger.internal.codegen.binding.AutoValue_AssistedInjectionAnnotations_AssistedFactoryMetadata;
import dagger.internal.codegen.binding.AutoValue_AssistedInjectionAnnotations_AssistedParameter;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.shaded.androidx.room.compiler.processing.XElement;
import dagger.shaded.androidx.room.compiler.processing.XType;
import dagger.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import dagger.spi.model.BindingKind;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public final class AssistedInjectionAnnotations {
    public static ExecutableElement assistedFactoryMethod(XTypeElement factory, DaggerElements elements) {
        return AssistedInjectionAnnotations.assistedFactoryMethod(XConverters.toJavac(factory), elements);
    }

    public static ExecutableElement assistedFactoryMethod(TypeElement factory, DaggerElements elements) {
        return (ExecutableElement)Iterables.getOnlyElement(AssistedInjectionAnnotations.assistedFactoryMethods(factory, elements));
    }

    public static ImmutableSet<ExecutableElement> assistedFactoryMethods(XTypeElement factory, DaggerElements elements) {
        return AssistedInjectionAnnotations.assistedFactoryMethods(XConverters.toJavac(factory), elements);
    }

    public static ImmutableSet<ExecutableElement> assistedFactoryMethods(TypeElement factory, DaggerElements elements) {
        return (ImmutableSet)elements.getLocalAndInheritedMethods(factory).stream().filter(method -> method.getModifiers().contains((Object)Modifier.ABSTRACT)).filter(method -> !method.isDefault()).collect(DaggerStreams.toImmutableSet());
    }

    public static boolean isAssistedInjectionType(XTypeElement typeElement2) {
        return AssistedInjectionAnnotations.isAssistedInjectionType(XConverters.toJavac(typeElement2));
    }

    public static boolean isAssistedInjectionType(TypeElement typeElement2) {
        ImmutableSet<ExecutableElement> injectConstructors = AssistedInjectionAnnotations.assistedInjectedConstructors(typeElement2);
        return !injectConstructors.isEmpty() && MoreElements.isAnnotationPresent((Element)Iterables.getOnlyElement(injectConstructors), AssistedInject.class);
    }

    public static boolean isAssistedFactoryType(XElement element) {
        return AssistedInjectionAnnotations.isAssistedFactoryType(XConverters.toJavac(element));
    }

    public static boolean isAssistedFactoryType(Element element) {
        return MoreElements.isAnnotationPresent(element, AssistedFactory.class);
    }

    public static ImmutableList<ParameterSpec> assistedParameterSpecs(Binding binding, DaggerTypes types) {
        Preconditions.checkArgument((binding.kind() == BindingKind.ASSISTED_INJECTION ? 1 : 0) != 0);
        ExecutableElement constructor = MoreElements.asExecutable(binding.bindingElement().get());
        ExecutableType constructorType = MoreTypes.asExecutable(types.asMemberOf(MoreTypes.asDeclared(binding.key().type().java()), constructor));
        return AssistedInjectionAnnotations.assistedParameterSpecs(constructor.getParameters(), constructorType.getParameterTypes());
    }

    private static ImmutableList<ParameterSpec> assistedParameterSpecs(List<? extends VariableElement> paramElements, List<? extends TypeMirror> paramTypes) {
        ImmutableList.Builder assistedParameterSpecs = ImmutableList.builder();
        for (int i = 0; i < paramElements.size(); ++i) {
            VariableElement paramElement = paramElements.get(i);
            TypeMirror paramType = paramTypes.get(i);
            if (!AssistedInjectionAnnotations.isAssistedParameter(paramElement)) continue;
            assistedParameterSpecs.add((Object)ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)paramType), (String)paramElement.getSimpleName().toString(), (Modifier[])new Modifier[0]).build());
        }
        return assistedParameterSpecs.build();
    }

    public static ImmutableList<ParameterSpec> assistedFactoryParameterSpecs(Binding binding, DaggerElements elements, DaggerTypes types) {
        Preconditions.checkArgument((binding.kind() == BindingKind.ASSISTED_FACTORY ? 1 : 0) != 0);
        AssistedFactoryMetadata metadata = AssistedFactoryMetadata.create(binding.bindingElement().get().asType(), elements, types);
        ExecutableType factoryMethodType = MoreTypes.asExecutable(types.asMemberOf(MoreTypes.asDeclared(binding.key().type().java()), metadata.factoryMethod()));
        return AssistedInjectionAnnotations.assistedParameterSpecs((List)metadata.assistedFactoryAssistedParameters().stream().map(arg_0 -> metadata.assistedInjectAssistedParametersMap().get(arg_0)).collect(DaggerStreams.toImmutableList()), factoryMethodType.getParameterTypes());
    }

    public static ImmutableSet<ExecutableElement> assistedInjectedConstructors(TypeElement type2) {
        return (ImmutableSet)ElementFilter.constructorsIn(type2.getEnclosedElements()).stream().filter(constructor -> MoreElements.isAnnotationPresent(constructor, AssistedInject.class)).collect(DaggerStreams.toImmutableSet());
    }

    public static ImmutableList<VariableElement> assistedParameters(Binding binding) {
        return binding.kind() == BindingKind.ASSISTED_INJECTION ? AssistedInjectionAnnotations.assistedParameters(MoreElements.asExecutable(binding.bindingElement().get())) : ImmutableList.of();
    }

    private static ImmutableList<VariableElement> assistedParameters(ExecutableElement constructor) {
        return (ImmutableList)constructor.getParameters().stream().filter(AssistedInjectionAnnotations::isAssistedParameter).collect(DaggerStreams.toImmutableList());
    }

    public static boolean isAssistedParameter(VariableElement param) {
        return MoreElements.isAnnotationPresent(MoreElements.asVariable(param), Assisted.class);
    }

    public static ImmutableList<AssistedParameter> assistedInjectAssistedParameters(XType assistedInjectType, DaggerTypes types) {
        return AssistedInjectionAnnotations.assistedInjectAssistedParameters(MoreTypes.asDeclared(XConverters.toJavac(assistedInjectType)), types);
    }

    public static ImmutableList<AssistedParameter> assistedInjectAssistedParameters(DeclaredType assistedInjectType, DaggerTypes types) {
        ExecutableElement assistedInjectConstructor = (ExecutableElement)Iterables.getOnlyElement(AssistedInjectionAnnotations.assistedInjectedConstructors(MoreTypes.asTypeElement(assistedInjectType)));
        ExecutableType assistedInjectConstructorType = MoreTypes.asExecutable(types.asMemberOf(assistedInjectType, assistedInjectConstructor));
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < assistedInjectConstructor.getParameters().size(); ++i) {
            VariableElement parameter = assistedInjectConstructor.getParameters().get(i);
            TypeMirror parameterType = assistedInjectConstructorType.getParameterTypes().get(i);
            if (!MoreElements.isAnnotationPresent(parameter, Assisted.class)) continue;
            builder.add((Object)AssistedParameter.create(parameter, parameterType));
        }
        return builder.build();
    }

    public static ImmutableList<AssistedParameter> assistedFactoryAssistedParameters(ExecutableElement factoryMethod, ExecutableType factoryMethodType) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < factoryMethod.getParameters().size(); ++i) {
            VariableElement parameter = factoryMethod.getParameters().get(i);
            TypeMirror parameterType = factoryMethodType.getParameterTypes().get(i);
            builder.add((Object)AssistedParameter.create(parameter, parameterType));
        }
        return builder.build();
    }

    private AssistedInjectionAnnotations() {
    }

    @AutoValue
    public static abstract class AssistedParameter {
        private VariableElement variableElement;

        public static AssistedParameter create(VariableElement parameter, TypeMirror parameterType) {
            AutoValue_AssistedInjectionAnnotations_AssistedParameter assistedParameter = new AutoValue_AssistedInjectionAnnotations_AssistedParameter(DaggerElements.getAnnotationMirror(parameter, TypeNames.ASSISTED).map(assisted -> MoreAnnotationValues.getStringValue(assisted, "value")).orElse(""), (Equivalence.Wrapper<TypeMirror>)MoreTypes.equivalence().wrap((Object)parameterType));
            assistedParameter.variableElement = parameter;
            return assistedParameter;
        }

        public abstract String qualifier();

        public abstract Equivalence.Wrapper<TypeMirror> wrappedType();

        public final TypeMirror type() {
            return (TypeMirror)this.wrappedType().get();
        }

        public final VariableElement variableElement() {
            return this.variableElement;
        }

        public final String toString() {
            return this.qualifier().isEmpty() ? String.format("@Assisted %s", this.type()) : String.format("@Assisted(\"%s\") %s", this.qualifier(), this.type());
        }
    }

    @AutoValue
    public static abstract class AssistedFactoryMetadata {
        public static AssistedFactoryMetadata create(XType factory, DaggerElements elements, DaggerTypes types) {
            return AssistedFactoryMetadata.create(XConverters.toJavac(factory), elements, types);
        }

        public static AssistedFactoryMetadata create(TypeMirror factory, DaggerElements elements, DaggerTypes types) {
            DeclaredType factoryType = MoreTypes.asDeclared(factory);
            TypeElement factoryElement = MoreTypes.asTypeElement(factoryType);
            ExecutableElement factoryMethod = AssistedInjectionAnnotations.assistedFactoryMethod(factoryElement, elements);
            ExecutableType factoryMethodType = MoreTypes.asExecutable(types.asMemberOf(factoryType, factoryMethod));
            DeclaredType assistedInjectType = MoreTypes.asDeclared(factoryMethodType.getReturnType());
            return new AutoValue_AssistedInjectionAnnotations_AssistedFactoryMetadata(factoryElement, factoryType, factoryMethod, factoryMethodType, MoreTypes.asTypeElement(assistedInjectType), assistedInjectType, AssistedInjectionAnnotations.assistedInjectAssistedParameters(assistedInjectType, types), AssistedInjectionAnnotations.assistedFactoryAssistedParameters(factoryMethod, factoryMethodType));
        }

        public abstract TypeElement factory();

        public abstract DeclaredType factoryType();

        public abstract ExecutableElement factoryMethod();

        public abstract ExecutableType factoryMethodType();

        public abstract TypeElement assistedInjectElement();

        public abstract DeclaredType assistedInjectType();

        public abstract ImmutableList<AssistedParameter> assistedInjectAssistedParameters();

        public abstract ImmutableList<AssistedParameter> assistedFactoryAssistedParameters();

        public ImmutableMap<AssistedParameter, VariableElement> assistedInjectAssistedParametersMap() {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (AssistedParameter assistedParameter : this.assistedInjectAssistedParameters()) {
                builder.put((Object)assistedParameter, (Object)assistedParameter.variableElement);
            }
            return builder.build();
        }

        public ImmutableMap<AssistedParameter, VariableElement> assistedFactoryAssistedParametersMap() {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (AssistedParameter assistedParameter : this.assistedFactoryAssistedParameters()) {
                builder.put((Object)assistedParameter, (Object)assistedParameter.variableElement);
            }
            return builder.build();
        }
    }
}

