/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.shaded.auto.common.MoreTypes;
import dagger.spi.model.RequestKind;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public final class RequestKinds {
    private static final ImmutableMap<RequestKind, ClassName> FRAMEWORK_CLASSES = ImmutableMap.of((Object)RequestKind.PROVIDER, (Object)TypeNames.PROVIDER, (Object)RequestKind.LAZY, (Object)TypeNames.LAZY, (Object)RequestKind.PRODUCER, (Object)TypeNames.PRODUCER, (Object)RequestKind.PRODUCED, (Object)TypeNames.PRODUCED);

    public static TypeMirror requestType(RequestKind requestKind, TypeMirror type2, DaggerTypes types) {
        switch (requestKind) {
            case INSTANCE: {
                return type2;
            }
            case PROVIDER_OF_LAZY: {
                return types.wrapType(RequestKinds.requestType(RequestKind.LAZY, type2, types), TypeNames.PROVIDER);
            }
            case FUTURE: {
                return types.wrapType(type2, TypeNames.LISTENABLE_FUTURE);
            }
        }
        return types.wrapType(type2, RequestKinds.frameworkClassName(requestKind));
    }

    public static TypeName requestTypeName(RequestKind requestKind, TypeName keyType) {
        switch (requestKind) {
            case INSTANCE: {
                return keyType;
            }
            case PROVIDER: {
                return TypeNames.providerOf(keyType);
            }
            case LAZY: {
                return TypeNames.lazyOf(keyType);
            }
            case PROVIDER_OF_LAZY: {
                return TypeNames.providerOf((TypeName)TypeNames.lazyOf(keyType));
            }
            case PRODUCER: {
                return TypeNames.producerOf(keyType);
            }
            case PRODUCED: {
                return TypeNames.producedOf(keyType);
            }
            case FUTURE: {
                return TypeNames.listenableFutureOf(keyType);
            }
        }
        throw new AssertionError(requestKind);
    }

    public static RequestKind getRequestKind(TypeMirror type2) {
        DaggerTypes.checkTypePresent(type2);
        if (!MoreTypes.isType(type2) || !type2.getKind().equals((Object)TypeKind.DECLARED) || MoreTypes.asDeclared(type2).getTypeArguments().isEmpty()) {
            return RequestKind.INSTANCE;
        }
        for (RequestKind kind : FRAMEWORK_CLASSES.keySet()) {
            if (!DaggerTypes.isTypeOf((TypeName)RequestKinds.frameworkClassName(kind), type2)) continue;
            if (kind.equals((Object)RequestKind.PROVIDER) && RequestKinds.getRequestKind(DaggerTypes.unwrapType(type2)).equals((Object)RequestKind.LAZY)) {
                return RequestKind.PROVIDER_OF_LAZY;
            }
            return kind;
        }
        return RequestKind.INSTANCE;
    }

    public static TypeMirror extractKeyType(TypeMirror type2) {
        return RequestKinds.extractKeyType(RequestKinds.getRequestKind(type2), type2);
    }

    private static TypeMirror extractKeyType(RequestKind requestKind, TypeMirror type2) {
        switch (requestKind) {
            case INSTANCE: {
                return type2;
            }
            case PROVIDER_OF_LAZY: {
                return RequestKinds.extractKeyType(RequestKind.LAZY, RequestKinds.extractKeyType(RequestKind.PROVIDER, type2));
            }
        }
        Preconditions.checkArgument((boolean)MoreTypes.isType(type2));
        return DaggerTypes.unwrapType(type2);
    }

    public static ClassName frameworkClassName(RequestKind requestKind) {
        Preconditions.checkArgument((boolean)FRAMEWORK_CLASSES.containsKey((Object)requestKind), (String)"no framework class for %s", (Object)requestKind);
        return (ClassName)FRAMEWORK_CLASSES.get((Object)requestKind);
    }

    public static boolean canBeSatisfiedByProductionBinding(RequestKind requestKind) {
        switch (requestKind) {
            case INSTANCE: 
            case PROVIDER_OF_LAZY: 
            case PROVIDER: 
            case LAZY: 
            case MEMBERS_INJECTION: {
                return false;
            }
            case FUTURE: 
            case PRODUCER: 
            case PRODUCED: {
                return true;
            }
        }
        throw new AssertionError();
    }

    private RequestKinds() {
    }
}

