/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.auto.value.AutoValue;
import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.base.AutoValue_OptionalType;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.shaded.auto.common.MoreTypes;
import dagger.spi.model.Key;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

@AutoValue
public abstract class OptionalType {
    @Deprecated
    protected abstract Equivalence.Wrapper<DeclaredType> wrappedDeclaredOptionalType();

    private DeclaredType declaredOptionalType() {
        return (DeclaredType)this.wrappedDeclaredOptionalType().get();
    }

    public OptionalKind kind() {
        return OptionalKind.of(MoreTypes.asTypeElement(this.declaredOptionalType()));
    }

    public TypeMirror valueType() {
        return this.declaredOptionalType().getTypeArguments().get(0);
    }

    private static boolean isOptional(TypeMirror type2) {
        return type2.getKind() == TypeKind.DECLARED && OptionalKind.isOptionalKind(MoreTypes.asTypeElement(type2));
    }

    public static boolean isOptional(Key key) {
        return OptionalType.isOptional(key.type().java());
    }

    public static OptionalType from(TypeMirror type2) {
        Preconditions.checkArgument((boolean)OptionalType.isOptional(type2), (String)"%s must be an Optional", (Object)type2);
        return new AutoValue_OptionalType((Equivalence.Wrapper<DeclaredType>)MoreTypes.equivalence().wrap((Object)MoreTypes.asDeclared(type2)));
    }

    public static OptionalType from(Key key) {
        return OptionalType.from(key.type().java());
    }

    public static enum OptionalKind {
        GUAVA_OPTIONAL(TypeNames.GUAVA_OPTIONAL, "absent"),
        JDK_OPTIONAL(TypeNames.JDK_OPTIONAL, "empty");

        private static final ImmutableMap<ClassName, OptionalKind> OPTIONAL_KIND_BY_CLASS_NAME;
        private final ClassName className;
        private final String absentMethodName;

        private OptionalKind(ClassName className2, String absentMethodName) {
            this.className = className2;
            this.absentMethodName = absentMethodName;
        }

        private static boolean isOptionalKind(TypeElement type2) {
            return OPTIONAL_KIND_BY_CLASS_NAME.containsKey((Object)ClassName.get((TypeElement)type2));
        }

        private static OptionalKind of(TypeElement type2) {
            return (OptionalKind)((Object)OPTIONAL_KIND_BY_CLASS_NAME.get((Object)ClassName.get((TypeElement)type2)));
        }

        public ParameterizedTypeName of(TypeName valueType) {
            return ParameterizedTypeName.get((ClassName)this.className, (TypeName[])new TypeName[]{valueType});
        }

        public CodeBlock absentValueExpression() {
            return CodeBlock.of((String)"$T.$L()", (Object[])new Object[]{this.className, this.absentMethodName});
        }

        public CodeBlock parameterizedAbsentValueExpression(OptionalType optionalType) {
            return CodeBlock.of((String)"$T.<$T>$L()", (Object[])new Object[]{this.className, optionalType.valueType(), this.absentMethodName});
        }

        public CodeBlock presentExpression(CodeBlock value2) {
            return CodeBlock.of((String)"$T.of($L)", (Object[])new Object[]{this.className, value2});
        }

        public CodeBlock presentObjectExpression(CodeBlock value2) {
            return CodeBlock.of((String)"$T.<$T>of($L)", (Object[])new Object[]{this.className, TypeName.OBJECT, value2});
        }

        static {
            OPTIONAL_KIND_BY_CLASS_NAME = (ImmutableMap)DaggerStreams.valuesOf(OptionalKind.class).collect(DaggerStreams.toImmutableMap(value2 -> value2.className, value2 -> value2));
        }
    }
}

