/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.auto.value.AutoValue;
import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.base.AutoValue_MapType;
import dagger.internal.codegen.base.FrameworkTypes;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.shaded.androidx.room.compiler.processing.XType;
import dagger.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.shaded.auto.common.MoreTypes;
import dagger.spi.model.Key;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

@AutoValue
public abstract class MapType {
    protected abstract Equivalence.Wrapper<DeclaredType> wrappedDeclaredMapType();

    private DeclaredType declaredMapType() {
        return (DeclaredType)this.wrappedDeclaredMapType().get();
    }

    public boolean isRawType() {
        return this.declaredMapType().getTypeArguments().isEmpty();
    }

    public TypeMirror keyType() {
        Preconditions.checkState((!this.isRawType() ? 1 : 0) != 0);
        return this.declaredMapType().getTypeArguments().get(0);
    }

    public TypeMirror valueType() {
        Preconditions.checkState((!this.isRawType() ? 1 : 0) != 0);
        return this.declaredMapType().getTypeArguments().get(1);
    }

    public boolean valuesAreTypeOf(ClassName className2) {
        return MoreTypes.isType(this.valueType()) && DaggerTypes.isTypeOf((TypeName)className2, this.valueType());
    }

    public boolean valuesAreFrameworkType() {
        return FrameworkTypes.isFrameworkType(this.valueType());
    }

    public TypeMirror unwrappedFrameworkValueType() {
        Preconditions.checkState((boolean)this.valuesAreFrameworkType(), (String)"called unwrappedFrameworkValueType() on %s", (Object)this.declaredMapType());
        return this.uncheckedUnwrappedValueType();
    }

    public TypeMirror unwrappedValueType(ClassName wrappingClass) {
        Preconditions.checkState((boolean)this.valuesAreTypeOf(wrappingClass), (String)"expected values to be %s: %s", (Object)wrappingClass, (Object)this);
        return this.uncheckedUnwrappedValueType();
    }

    private TypeMirror uncheckedUnwrappedValueType() {
        return MoreTypes.asDeclared(this.valueType()).getTypeArguments().get(0);
    }

    public static boolean isMap(XType type2) {
        return MapType.isMap(XConverters.toJavac(type2));
    }

    public static boolean isMap(TypeMirror type2) {
        return MoreTypes.isType(type2) && DaggerTypes.isTypeOf((TypeName)TypeNames.MAP, type2);
    }

    public static boolean isMap(Key key) {
        return MapType.isMap(key.type().java());
    }

    public static MapType from(XType type2) {
        return MapType.from(XConverters.toJavac(type2));
    }

    public static MapType from(TypeMirror type2) {
        Preconditions.checkArgument((boolean)MapType.isMap(type2), (String)"%s is not a Map", (Object)type2);
        return new AutoValue_MapType((Equivalence.Wrapper<DeclaredType>)MoreTypes.equivalence().wrap((Object)MoreTypes.asDeclared(type2)));
    }

    public static MapType from(Key key) {
        return MapType.from(key.type().java());
    }
}

