/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.binding.MapKeys;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.validation.MapKeyValidator;
import dagger.internal.codegen.validation.TypeCheckingProcessingStep;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.internal.codegen.writing.AnnotationCreatorGenerator;
import dagger.internal.codegen.writing.UnwrappedMapKeyGenerator;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.shaded.androidx.room.compiler.processing.XMessager;
import dagger.shaded.androidx.room.compiler.processing.XType;
import dagger.shaded.androidx.room.compiler.processing.XTypeElement;
import javax.inject.Inject;

final class MapKeyProcessingStep
extends TypeCheckingProcessingStep<XTypeElement> {
    private final XMessager messager;
    private final MapKeyValidator mapKeyValidator;
    private final AnnotationCreatorGenerator annotationCreatorGenerator;
    private final UnwrappedMapKeyGenerator unwrappedMapKeyGenerator;

    @Inject
    MapKeyProcessingStep(XMessager messager2, MapKeyValidator mapKeyValidator, AnnotationCreatorGenerator annotationCreatorGenerator, UnwrappedMapKeyGenerator unwrappedMapKeyGenerator) {
        this.messager = messager2;
        this.mapKeyValidator = mapKeyValidator;
        this.annotationCreatorGenerator = annotationCreatorGenerator;
        this.unwrappedMapKeyGenerator = unwrappedMapKeyGenerator;
    }

    public ImmutableSet<ClassName> annotationClassNames() {
        return ImmutableSet.of((Object)TypeNames.MAP_KEY);
    }

    @Override
    protected void process(XTypeElement mapAnnotation, ImmutableSet<ClassName> annotations2) {
        ValidationReport mapKeyReport = this.mapKeyValidator.validate(mapAnnotation);
        mapKeyReport.printMessagesTo(this.messager);
        if (mapKeyReport.isClean()) {
            if (!mapAnnotation.getAnnotation(TypeNames.MAP_KEY).getAsBoolean("unwrapValue")) {
                this.annotationCreatorGenerator.generate(mapAnnotation, this.messager);
            } else if (this.isAnnotationType(MapKeys.getUnwrappedMapKeyType(mapAnnotation.getType()))) {
                this.unwrappedMapKeyGenerator.generate(mapAnnotation, this.messager);
            }
        }
    }

    private boolean isAnnotationType(XType type2) {
        return XTypes.isDeclared(type2) && type2.getTypeElement().isAnnotationClass();
    }
}

