/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.kotlin.KotlinMetadataUtil;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ComponentRequestRepresentations;
import dagger.internal.codegen.writing.ComponentRequirementExpressions;
import dagger.internal.codegen.writing.InjectionMethods;
import dagger.internal.codegen.writing.MembersInjectionMethods;
import dagger.internal.codegen.writing.RequestRepresentation;
import dagger.spi.model.DependencyRequest;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.spi.shaded.auto.common.MoreElements;
import dagger.spi.shaded.auto.common.MoreTypes;
import java.util.Optional;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

final class SimpleMethodRequestRepresentation
extends RequestRepresentation {
    private final CompilerOptions compilerOptions;
    private final ProvisionBinding provisionBinding;
    private final ComponentRequestRepresentations componentRequestRepresentations;
    private final MembersInjectionMethods membersInjectionMethods;
    private final ComponentRequirementExpressions componentRequirementExpressions;
    private final SourceVersion sourceVersion;
    private final KotlinMetadataUtil metadataUtil;
    private final ComponentImplementation.ShardImplementation shardImplementation;

    @AssistedInject
    SimpleMethodRequestRepresentation(@Assisted ProvisionBinding binding, MembersInjectionMethods membersInjectionMethods, CompilerOptions compilerOptions, ComponentRequestRepresentations componentRequestRepresentations, ComponentRequirementExpressions componentRequirementExpressions, SourceVersion sourceVersion, KotlinMetadataUtil metadataUtil, ComponentImplementation componentImplementation) {
        this.compilerOptions = compilerOptions;
        this.provisionBinding = binding;
        this.metadataUtil = metadataUtil;
        Preconditions.checkArgument((boolean)this.provisionBinding.implicitDependencies().isEmpty(), (Object)"framework deps are not currently supported");
        Preconditions.checkArgument((boolean)this.provisionBinding.bindingElement().isPresent());
        this.componentRequestRepresentations = componentRequestRepresentations;
        this.membersInjectionMethods = membersInjectionMethods;
        this.componentRequirementExpressions = componentRequirementExpressions;
        this.sourceVersion = sourceVersion;
        this.shardImplementation = componentImplementation.shardImplementation(binding);
    }

    @Override
    Expression getDependencyExpression(ClassName requestingClass) {
        return InjectionMethods.ProvisionMethod.requiresInjectionMethod(this.provisionBinding, this.compilerOptions, requestingClass) ? this.invokeInjectionMethod(requestingClass) : this.invokeMethod(requestingClass);
    }

    private Expression invokeMethod(ClassName requestingClass) {
        CodeBlock invocation;
        CodeBlock arguments = CodeBlocks.makeParametersCodeBlock(InjectionMethods.ProvisionMethod.invokeArguments(this.provisionBinding, request -> this.dependencyArgument((DependencyRequest)request, requestingClass).codeBlock(), this.shardImplementation::getUniqueFieldNameForAssistedParam));
        ExecutableElement method = MoreElements.asExecutable((Element)XConverters.toJavac((XElement)this.provisionBinding.bindingElement().get()));
        switch (method.getKind()) {
            case CONSTRUCTOR: {
                invocation = CodeBlock.of((String)"new $T($L)", (Object[])new Object[]{this.constructorTypeName(requestingClass), arguments});
                break;
            }
            case METHOD: {
                Optional<CodeBlock> requiredModuleInstance = this.moduleReference(requestingClass);
                CodeBlock module = requiredModuleInstance.isPresent() ? requiredModuleInstance.get() : (this.metadataUtil.isObjectClass(MoreElements.asType((Element)method.getEnclosingElement())) ? CodeBlock.of((String)"$T.INSTANCE", (Object[])new Object[]{this.provisionBinding.bindingTypeElement().get().getClassName()}) : CodeBlock.of((String)"$T", (Object[])new Object[]{this.provisionBinding.bindingTypeElement().get().getClassName()}));
                invocation = CodeBlock.of((String)"$L.$L($L)", (Object[])new Object[]{module, method.getSimpleName(), arguments});
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return Expression.create(this.simpleMethodReturnType(), invocation);
    }

    private TypeName constructorTypeName(ClassName requestingClass) {
        DeclaredType type = MoreTypes.asDeclared((TypeMirror)this.provisionBinding.key().type().java());
        TypeName typeName = TypeName.get((TypeMirror)type);
        if (type.getTypeArguments().stream().allMatch(t -> Accessibility.isTypeAccessibleFrom(t, requestingClass.packageName()))) {
            return typeName;
        }
        return TypeNames.rawTypeName(typeName);
    }

    private Expression invokeInjectionMethod(ClassName requestingClass) {
        return this.injectMembers(InjectionMethods.ProvisionMethod.invoke(this.provisionBinding, request -> this.dependencyArgument((DependencyRequest)request, requestingClass).codeBlock(), this.shardImplementation::getUniqueFieldNameForAssistedParam, requestingClass, this.moduleReference(requestingClass), this.compilerOptions, this.metadataUtil), requestingClass);
    }

    private Expression dependencyArgument(DependencyRequest dependency, ClassName requestingClass) {
        return this.componentRequestRepresentations.getDependencyArgumentExpression(dependency, requestingClass);
    }

    private Expression injectMembers(CodeBlock instance, ClassName requestingClass) {
        if (this.provisionBinding.injectionSites().isEmpty()) {
            return Expression.create(this.simpleMethodReturnType(), instance);
        }
        if (this.sourceVersion.compareTo(SourceVersion.RELEASE_7) <= 0 && !MoreTypes.asDeclared((TypeMirror)this.provisionBinding.key().type().java()).getTypeArguments().isEmpty()) {
            TypeName keyType = TypeName.get((TypeMirror)this.provisionBinding.key().type().java());
            instance = CodeBlock.of((String)"($T) ($T) $L", (Object[])new Object[]{keyType, TypeNames.rawTypeName(keyType), instance});
        }
        return this.membersInjectionMethods.getInjectExpression(this.provisionBinding.key(), instance, requestingClass);
    }

    private Optional<CodeBlock> moduleReference(ClassName requestingClass) {
        return this.provisionBinding.requiresModuleInstance() ? this.provisionBinding.contributingModule().map(XTypeElement::getType).map(ComponentRequirement::forModule).map(module -> this.componentRequirementExpressions.getExpression((ComponentRequirement)module, requestingClass)) : Optional.empty();
    }

    private TypeMirror simpleMethodReturnType() {
        return this.provisionBinding.contributedPrimitiveType().orElse(this.provisionBinding.key().type().java());
    }

    @AssistedFactory
    static interface Factory {
        public SimpleMethodRequestRepresentation create(ProvisionBinding var1);
    }
}

