/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.base.Equivalence;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.spi.shaded.auto.common.MoreTypes;
import dagger.spi.shaded.auto.common.SuperficialValidation;
import java.util.ArrayDeque;
import java.util.HashSet;
import javax.lang.model.type.TypeMirror;

final class TypeHierarchyValidator {
    private TypeHierarchyValidator() {
    }

    public static void validateTypeHierarchy(XType type, DaggerTypes types) {
        TypeHierarchyValidator.validateTypeHierarchy(XConverters.toJavac((XType)type), types);
    }

    public static void validateTypeHierarchy(TypeMirror type, DaggerTypes types) {
        ArrayDeque<TypeMirror> queue = new ArrayDeque<TypeMirror>();
        HashSet<Equivalence.Wrapper> queued = new HashSet<Equivalence.Wrapper>();
        queue.add(type);
        queued.add(MoreTypes.equivalence().wrap((Object)type));
        while (!queue.isEmpty()) {
            TypeMirror currType = (TypeMirror)queue.remove();
            if (!SuperficialValidation.validateType((TypeMirror)currType)) {
                throw new TypeNotPresentException(currType.toString(), null);
            }
            for (TypeMirror typeMirror : types.directSupertypes(currType)) {
                if (!queued.add(MoreTypes.equivalence().wrap((Object)typeMirror))) continue;
                queue.add(typeMirror);
            }
        }
    }
}

