/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import dagger.internal.codegen.base.ClearableCache;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.validation.DaggerSuperficialValidation;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.lang.model.element.TypeElement;

@Singleton
public final class SuperficialInjectValidator
implements ClearableCache {
    private final Map<XTypeElement, Boolean> validatedTypeElements = new HashMap<XTypeElement, Boolean>();

    @Inject
    SuperficialInjectValidator() {
    }

    public void throwIfNotValid(XTypeElement injectTypeElement) {
        if (!this.validatedTypeElements.computeIfAbsent(injectTypeElement, this::validate).booleanValue()) {
            throw new TypeNotPresentException(injectTypeElement.toString(), null);
        }
    }

    private boolean validate(XTypeElement xInjectTypeElement) {
        TypeElement injectTypeElement = XConverters.toJavac((XTypeElement)xInjectTypeElement);
        return DaggerSuperficialValidation.validateType(injectTypeElement.asType()) && DaggerSuperficialValidation.validateAnnotations(injectTypeElement.getAnnotationMirrors()) && DaggerSuperficialValidation.validateType(injectTypeElement.getSuperclass()) && injectTypeElement.getEnclosedElements().stream().filter(element -> DaggerElements.isAnnotationPresent(element, TypeNames.INJECT)).allMatch(DaggerSuperficialValidation::validateElement);
    }

    @Override
    public void clearCache() {
        this.validatedTypeElements.clear();
    }
}

