/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.base.Keys;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.validation.BindingElementValidator;
import dagger.internal.codegen.validation.BindingMethodValidator;
import dagger.internal.codegen.validation.DependencyRequestValidator;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import javax.inject.Inject;

final class BindsOptionalOfMethodValidator
extends BindingMethodValidator {
    private final DaggerTypes types;
    private final InjectionAnnotations injectionAnnotations;

    @Inject
    BindsOptionalOfMethodValidator(DaggerTypes types, DependencyRequestValidator dependencyRequestValidator, InjectionAnnotations injectionAnnotations) {
        super(types, TypeNames.BINDS_OPTIONAL_OF, (Iterable<ClassName>)ImmutableSet.of((Object)TypeNames.MODULE, (Object)TypeNames.PRODUCER_MODULE), dependencyRequestValidator, BindingMethodValidator.Abstractness.MUST_BE_ABSTRACT, BindingMethodValidator.ExceptionSuperclass.NO_EXCEPTIONS, BindingElementValidator.AllowsMultibindings.NO_MULTIBINDINGS, BindingElementValidator.AllowsScoping.NO_SCOPING, injectionAnnotations);
        this.types = types;
        this.injectionAnnotations = injectionAnnotations;
    }

    @Override
    protected BindingElementValidator.ElementValidator elementValidator(XMethodElement method) {
        return new Validator(method);
    }

    private class Validator
    extends BindingMethodValidator.MethodValidator {
        private final XMethodElement method;

        Validator(XMethodElement method) {
            super(BindsOptionalOfMethodValidator.this, method);
            this.method = method;
        }

        @Override
        protected void checkKeyType(XType keyType) {
            super.checkKeyType(keyType);
            if (Keys.isValidImplicitProvisionKey(BindsOptionalOfMethodValidator.this.injectionAnnotations.getQualifiers((XElement)this.method).stream().findFirst(), keyType, BindsOptionalOfMethodValidator.this.types) && !InjectionAnnotations.injectedConstructors(keyType.getTypeElement()).isEmpty()) {
                this.report.addError("@BindsOptionalOf methods cannot return unqualified types that have an @Inject-annotated constructor because those are always present");
            }
        }

        @Override
        protected void checkParameters() {
            if (!this.method.getParameters().isEmpty()) {
                this.report.addError("@BindsOptionalOf methods cannot have parameters");
            }
        }
    }
}

