/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dagger.MembersInjector;
import dagger.internal.codegen.base.Keys;
import dagger.internal.codegen.base.SourceFileGenerationException;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.BindingDeclaration;
import dagger.internal.codegen.binding.BindingFactory;
import dagger.internal.codegen.binding.InjectBindingRegistry;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.binding.KeyFactory;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.validation.InjectValidator;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.shaded.androidx.room.compiler.processing.XConstructorElement;
import dagger.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.shaded.androidx.room.compiler.processing.XFieldElement;
import dagger.shaded.androidx.room.compiler.processing.XMessager;
import dagger.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.shaded.androidx.room.compiler.processing.XType;
import dagger.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import dagger.spi.model.Key;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

@Singleton
final class InjectBindingRegistryImpl
implements InjectBindingRegistry {
    private final XProcessingEnv processingEnv;
    private final DaggerElements elements;
    private final DaggerTypes types;
    private final XMessager messager;
    private final InjectValidator injectValidator;
    private final InjectValidator injectValidatorWhenGeneratingCode;
    private final KeyFactory keyFactory;
    private final BindingFactory bindingFactory;
    private final CompilerOptions compilerOptions;
    private final BindingsCollection<ProvisionBinding> provisionBindings = new BindingsCollection(Provider.class);
    private final BindingsCollection<MembersInjectionBinding> membersInjectionBindings = new BindingsCollection(MembersInjector.class);

    @Inject
    InjectBindingRegistryImpl(XProcessingEnv processingEnv, DaggerElements elements, DaggerTypes types, XMessager messager2, InjectValidator injectValidator, KeyFactory keyFactory, BindingFactory bindingFactory, CompilerOptions compilerOptions) {
        this.processingEnv = processingEnv;
        this.elements = elements;
        this.types = types;
        this.messager = messager2;
        this.injectValidator = injectValidator;
        this.injectValidatorWhenGeneratingCode = injectValidator.whenGeneratingCode();
        this.keyFactory = keyFactory;
        this.bindingFactory = bindingFactory;
        this.compilerOptions = compilerOptions;
    }

    @Override
    public void generateSourcesForRequiredBindings(SourceFileGenerator<ProvisionBinding> factoryGenerator, SourceFileGenerator<MembersInjectionBinding> membersInjectorGenerator) throws SourceFileGenerationException {
        this.provisionBindings.generateBindings(factoryGenerator);
        this.membersInjectionBindings.generateBindings(membersInjectorGenerator);
    }

    private void registerBinding(ProvisionBinding binding, boolean warnIfNotAlreadyGenerated) {
        this.provisionBindings.tryRegisterBinding(binding, warnIfNotAlreadyGenerated);
    }

    private void registerBinding(MembersInjectionBinding binding, boolean warnIfNotAlreadyGenerated) {
        if (warnIfNotAlreadyGenerated) {
            boolean hasInjectConstructor;
            boolean bl = hasInjectConstructor = !InjectionAnnotations.injectedConstructors(binding.membersInjectedType()).isEmpty() || !AssistedInjectionAnnotations.assistedInjectedConstructors(binding.membersInjectedType()).isEmpty();
            warnIfNotAlreadyGenerated = hasInjectConstructor ? !binding.injectionSites().isEmpty() : binding.hasLocalInjectionSites();
        }
        this.membersInjectionBindings.tryRegisterBinding(binding, warnIfNotAlreadyGenerated);
    }

    @Override
    public Optional<ProvisionBinding> tryRegisterInjectConstructor(XConstructorElement constructorElement) {
        return this.tryRegisterConstructor(constructorElement, Optional.empty(), false);
    }

    @CanIgnoreReturnValue
    private Optional<ProvisionBinding> tryRegisterConstructor(XConstructorElement constructorElement, Optional<TypeMirror> resolvedType, boolean warnIfNotAlreadyGenerated) {
        XTypeElement typeElement2 = constructorElement.getEnclosingElement();
        XType type2 = typeElement2.getType();
        Key key = this.keyFactory.forInjectConstructorWithResolvedType(type2);
        ProvisionBinding cachedBinding = this.provisionBindings.getBinding(key);
        if (cachedBinding != null) {
            return Optional.of(cachedBinding);
        }
        ValidationReport report = this.injectValidator.validateConstructor(constructorElement);
        report.printMessagesTo(this.messager);
        if (!report.isClean()) {
            return Optional.empty();
        }
        ProvisionBinding binding = this.bindingFactory.injectionBinding(constructorElement, resolvedType);
        this.registerBinding(binding, warnIfNotAlreadyGenerated);
        if (!binding.injectionSites().isEmpty()) {
            this.tryRegisterMembersInjectedType(typeElement2, resolvedType, warnIfNotAlreadyGenerated);
        }
        return Optional.of(binding);
    }

    @Override
    public Optional<MembersInjectionBinding> tryRegisterInjectField(XFieldElement fieldElement) {
        if (!XElementKt.isTypeElement(fieldElement.getEnclosingElement())) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "@Inject fields must be enclosed in a type.", fieldElement);
        }
        return this.tryRegisterMembersInjectedType(XElements.asTypeElement(fieldElement.getEnclosingElement()), Optional.empty(), false);
    }

    @Override
    public Optional<MembersInjectionBinding> tryRegisterInjectMethod(XMethodElement methodElement) {
        if (!XElementKt.isTypeElement(methodElement.getEnclosingElement())) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "@Inject methods must be enclosed in a type.", methodElement);
        }
        return this.tryRegisterMembersInjectedType(XElements.asTypeElement(methodElement.getEnclosingElement()), Optional.empty(), false);
    }

    @CanIgnoreReturnValue
    private Optional<MembersInjectionBinding> tryRegisterMembersInjectedType(XTypeElement typeElement2, Optional<TypeMirror> resolvedType, boolean warnIfNotAlreadyGenerated) {
        XType type2 = typeElement2.getType();
        Key key = this.keyFactory.forInjectConstructorWithResolvedType(type2);
        MembersInjectionBinding cachedBinding = this.membersInjectionBindings.getBinding(key);
        if (cachedBinding != null) {
            return Optional.of(cachedBinding);
        }
        ValidationReport report = this.injectValidator.validateMembersInjectionType(typeElement2);
        report.printMessagesTo(this.messager);
        if (!report.isClean()) {
            return Optional.empty();
        }
        MembersInjectionBinding binding = this.bindingFactory.membersInjectionBinding(type2, resolvedType);
        this.registerBinding(binding, warnIfNotAlreadyGenerated);
        Optional<DeclaredType> supertype = this.types.nonObjectSuperclass(type2);
        while (supertype.isPresent()) {
            this.getOrFindMembersInjectionBinding(this.keyFactory.forMembersInjectedType(supertype.get()));
            supertype = this.types.nonObjectSuperclass(supertype.get());
        }
        return Optional.of(binding);
    }

    @Override
    @CanIgnoreReturnValue
    public Optional<ProvisionBinding> getOrFindProvisionBinding(Key key) {
        Preconditions.checkNotNull((Object)key);
        if (!Keys.isValidImplicitProvisionKey(key, this.types)) {
            return Optional.empty();
        }
        ProvisionBinding binding = this.provisionBindings.getBinding(key);
        if (binding != null) {
            return Optional.of(binding);
        }
        XTypeElement element = XConverters.toXProcessing(MoreElements.asType(this.types.asElement(key.type().java())), this.processingEnv);
        ImmutableSet injectConstructors = ImmutableSet.builder().addAll(InjectionAnnotations.injectedConstructors(element)).addAll(AssistedInjectionAnnotations.assistedInjectedConstructors(element)).build();
        switch (injectConstructors.size()) {
            case 0: {
                return Optional.empty();
            }
            case 1: {
                return this.tryRegisterConstructor((XConstructorElement)Iterables.getOnlyElement((Iterable)injectConstructors), Optional.of(key.type().java()), true);
            }
        }
        throw new IllegalStateException("Found multiple @Inject constructors: " + injectConstructors);
    }

    @Override
    @CanIgnoreReturnValue
    public Optional<MembersInjectionBinding> getOrFindMembersInjectionBinding(Key key) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkArgument((boolean)Keys.isValidMembersInjectionKey(key));
        MembersInjectionBinding binding = this.membersInjectionBindings.getBinding(key);
        if (binding != null) {
            return Optional.of(binding);
        }
        return this.tryRegisterMembersInjectedType(XConverters.toXProcessing(MoreTypes.asTypeElement(key.type().java()), this.processingEnv), Optional.of(key.type().java()), true);
    }

    @Override
    public Optional<ProvisionBinding> getOrFindMembersInjectorProvisionBinding(Key key) {
        if (!Keys.isValidMembersInjectionKey(key)) {
            return Optional.empty();
        }
        Key membersInjectionKey = this.keyFactory.forMembersInjectedType(DaggerTypes.unwrapType(key.type().java()));
        return this.getOrFindMembersInjectionBinding(membersInjectionKey).map(binding -> this.bindingFactory.membersInjectorBinding(key, (MembersInjectionBinding)binding));
    }

    final class BindingsCollection<B extends Binding> {
        private final Class<?> factoryClass;
        private final Map<Key, B> bindingsByKey = Maps.newLinkedHashMap();
        private final Deque<B> bindingsRequiringGeneration = new ArrayDeque<B>();
        private final Set<Key> materializedBindingKeys = Sets.newLinkedHashSet();

        BindingsCollection(Class<?> factoryClass) {
            this.factoryClass = factoryClass;
        }

        void generateBindings(SourceFileGenerator<B> generator) throws SourceFileGenerationException {
            Binding binding = (Binding)this.bindingsRequiringGeneration.poll();
            while (binding != null) {
                Preconditions.checkState((!binding.unresolved().isPresent() ? 1 : 0) != 0);
                TypeMirror type2 = binding.key().type().java();
                if (!type2.getKind().equals((Object)TypeKind.DECLARED) || InjectBindingRegistryImpl.this.injectValidatorWhenGeneratingCode.validateType(XConverters.toXProcessing(MoreTypes.asTypeElement(type2), InjectBindingRegistryImpl.this.processingEnv)).isClean()) {
                    generator.generate(binding);
                }
                this.materializedBindingKeys.add(binding.key());
                binding = (Binding)this.bindingsRequiringGeneration.poll();
            }
            this.bindingsByKey.clear();
        }

        B getBinding(Key key) {
            return (B)((Binding)this.bindingsByKey.get(key));
        }

        void tryRegisterBinding(B binding, boolean warnIfNotAlreadyGenerated) {
            this.tryToCacheBinding(binding);
            B maybeUnresolved = ((Binding)binding).unresolved().isPresent() ? ((Binding)binding).unresolved().get() : binding;
            this.tryToGenerateBinding(maybeUnresolved, warnIfNotAlreadyGenerated);
        }

        void tryToGenerateBinding(B binding, boolean warnIfNotAlreadyGenerated) {
            if (this.shouldGenerateBinding(binding)) {
                this.bindingsRequiringGeneration.offer(binding);
                if (InjectBindingRegistryImpl.this.compilerOptions.warnIfInjectionFactoryNotGeneratedUpstream() && warnIfNotAlreadyGenerated) {
                    InjectBindingRegistryImpl.this.messager.printMessage(Diagnostic.Kind.NOTE, String.format("Generating a %s for %s. Prefer to run the dagger processor over that class instead.", this.factoryClass.getSimpleName(), InjectBindingRegistryImpl.this.types.erasure(((BindingDeclaration)binding).key().type().java())));
                }
            }
        }

        private boolean shouldGenerateBinding(B binding) {
            return !((Binding)binding).unresolved().isPresent() && !this.materializedBindingKeys.contains(((BindingDeclaration)binding).key()) && !this.bindingsRequiringGeneration.contains(binding) && InjectBindingRegistryImpl.this.elements.getTypeElement(SourceFiles.generatedClassNameForBinding(binding)) == null;
        }

        private void tryToCacheBinding(B binding) {
            if (((Binding)binding).unresolved().isPresent() || ((BindingDeclaration)binding).bindingTypeElement().get().getTypeParameters().isEmpty()) {
                Key key = ((BindingDeclaration)binding).key();
                Binding previousValue = (Binding)this.bindingsByKey.put(key, binding);
                Preconditions.checkState((previousValue == null || binding.equals(previousValue) ? 1 : 0) != 0, (String)"couldn't register %s. %s was already registered for %s", binding, (Object)previousValue, (Object)key);
            }
        }
    }
}

