/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dagger.internal.codegen.base.ContributionType;
import dagger.internal.codegen.base.SetType;
import dagger.internal.codegen.binding.;
import dagger.internal.codegen.binding.BindingType;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.spi.model.DependencyRequest;
import java.util.Optional;
import java.util.stream.Stream;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;

@AutoValue
public abstract class ProductionBinding
extends ContributionBinding {
    @Override
    public BindingType bindingType() {
        return BindingType.PRODUCTION;
    }

    public abstract Optional<ProductionBinding> unresolved();

    @Override
    public ImmutableSet<DependencyRequest> implicitDependencies() {
        return (ImmutableSet)Stream.of(this.executorRequest(), this.monitorRequest()).filter(Optional::isPresent).map(Optional::get).collect(DaggerStreams.toImmutableSet());
    }

    public abstract Optional<ProductionKind> productionKind();

    public abstract ImmutableList<? extends TypeMirror> thrownTypes();

    abstract Optional<DependencyRequest> executorRequest();

    abstract Optional<DependencyRequest> monitorRequest();

    @Override
    public boolean requiresModuleInstance() {
        return super.requiresModuleInstance();
    }

    public static Builder builder() {
        return new .AutoValue_ProductionBinding.Builder().explicitDependencies((Iterable<DependencyRequest>)ImmutableList.of()).thrownTypes((Iterable<? extends TypeMirror>)ImmutableList.of());
    }

    public abstract Builder toBuilder();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    @AutoValue.Builder
    @CanIgnoreReturnValue
    public static abstract class Builder
    extends ContributionBinding.Builder<ProductionBinding, Builder> {
        @Override
        public Builder dependencies(Iterable<DependencyRequest> dependencies) {
            return this.explicitDependencies(dependencies);
        }

        abstract Builder explicitDependencies(Iterable<DependencyRequest> var1);

        abstract Builder productionKind(ProductionKind var1);

        @Override
        public abstract Builder unresolved(ProductionBinding var1);

        abstract Builder thrownTypes(Iterable<? extends TypeMirror> var1);

        abstract Builder executorRequest(DependencyRequest var1);

        abstract Builder monitorRequest(DependencyRequest var1);
    }

    public static enum ProductionKind {
        IMMEDIATE,
        FUTURE,
        SET_OF_FUTURE;


        public static ProductionKind fromProducesMethod(ExecutableElement producesMethod) {
            if (DaggerTypes.isFutureType(producesMethod.getReturnType())) {
                return FUTURE;
            }
            if (ContributionType.fromBindingElement(producesMethod).equals((Object)ContributionType.SET_VALUES) && DaggerTypes.isFutureType(SetType.from(producesMethod.getReturnType()).elementType())) {
                return SET_OF_FUTURE;
            }
            return IMMEDIATE;
        }
    }
}

