/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import dagger.MapKey;
import dagger.internal.codegen.base.MapKeyAccessibility;
import dagger.internal.codegen.binding.AnnotationExpression;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.shaded.androidx.room.compiler.processing.XElement;
import dagger.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.shaded.androidx.room.compiler.processing.XType;
import dagger.shaded.androidx.room.compiler.processing.XTypeKt;
import dagger.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public final class MapKeys {
    static Optional<AnnotationMirror> getMapKey(Element bindingElement) {
        ImmutableSet<? extends AnnotationMirror> mapKeys = MapKeys.getMapKeys(bindingElement);
        return mapKeys.isEmpty() ? Optional.empty() : Optional.of((AnnotationMirror)Iterables.getOnlyElement(mapKeys));
    }

    public static ImmutableSet<? extends AnnotationMirror> getMapKeys(Element bindingElement) {
        return AnnotationMirrors.getAnnotatedAnnotations(bindingElement, MapKey.class);
    }

    public static ImmutableSet<XAnnotation> getMapKeys(XElement bindingElement) {
        return XElements.getAnnotatedAnnotations(bindingElement, TypeNames.MAP_KEY);
    }

    static Optional<? extends AnnotationValue> unwrapValue(AnnotationMirror mapKey) {
        MapKey mapKeyAnnotation = mapKey.getAnnotationType().asElement().getAnnotation(MapKey.class);
        Preconditions.checkArgument((mapKeyAnnotation != null ? 1 : 0) != 0, (String)"%s is not annotated with @MapKey", (Object)mapKey.getAnnotationType());
        return mapKeyAnnotation.unwrapValue() ? Optional.of((AnnotationValue)Iterables.getOnlyElement((Iterable)AnnotationMirrors.getAnnotationValuesWithDefaults(mapKey).values())) : Optional.empty();
    }

    static TypeMirror mapKeyType(XAnnotation mapKeyAnnotation) {
        return MapKeys.unwrapValue(XConverters.toJavac(mapKeyAnnotation)).isPresent() ? XConverters.toJavac(MapKeys.getUnwrappedMapKeyType(mapKeyAnnotation.getType())) : XConverters.toJavac(mapKeyAnnotation.getType());
    }

    public static XType getUnwrappedMapKeyType(XType mapKeyAnnotationType) {
        Preconditions.checkArgument((XTypes.isDeclared(mapKeyAnnotationType) && mapKeyAnnotationType.getTypeElement().isAnnotationClass() ? 1 : 0) != 0, (String)"%s is not an annotation type", (Object)mapKeyAnnotationType);
        XMethodElement annotationValueMethod = (XMethodElement)Iterables.getOnlyElement(mapKeyAnnotationType.getTypeElement().getDeclaredMethods());
        XType annotationValueType = annotationValueMethod.getReturnType();
        if (XTypeKt.isArray(annotationValueType)) {
            throw new IllegalArgumentException(mapKeyAnnotationType + "." + annotationValueMethod.getName() + " cannot be an array");
        }
        return XTypes.isPrimitive(annotationValueType) ? annotationValueType.boxed() : annotationValueType;
    }

    public static CodeBlock getMapKeyExpression(ContributionBinding binding, ClassName requestingClass, DaggerElements elements) {
        AnnotationMirror mapKeyAnnotation = binding.mapKeyAnnotation().get();
        return MapKeyAccessibility.isMapKeyAccessibleFrom(mapKeyAnnotation, requestingClass.packageName()) ? MapKeys.directMapKeyExpression(mapKeyAnnotation, elements) : CodeBlock.of((String)"$T.create()", (Object[])new Object[]{MapKeys.mapKeyProxyClassName(binding)});
    }

    private static CodeBlock directMapKeyExpression(AnnotationMirror mapKey, DaggerElements elements) {
        Optional<? extends AnnotationValue> unwrappedValue = MapKeys.unwrapValue(mapKey);
        AnnotationExpression annotationExpression = new AnnotationExpression(mapKey);
        if (MoreTypes.asTypeElement(mapKey.getAnnotationType()).getQualifiedName().contentEquals("dagger.android.AndroidInjectionKey")) {
            TypeElement unwrappedType = elements.checkTypePresent((String)unwrappedValue.get().getValue());
            return CodeBlock.of((String)"$T.of($S)", (Object[])new Object[]{ClassName.get((String)"dagger.android.internal", (String)"AndroidInjectionKeys", (String[])new String[0]), ClassName.get((TypeElement)unwrappedType).reflectionName()});
        }
        if (unwrappedValue.isPresent()) {
            TypeMirror unwrappedValueType = ((ExecutableElement)Iterables.getOnlyElement((Iterable)AnnotationMirrors.getAnnotationValuesWithDefaults(mapKey).keySet())).getReturnType();
            return annotationExpression.getValueExpression(unwrappedValueType, unwrappedValue.get());
        }
        return annotationExpression.getAnnotationInstanceExpression();
    }

    public static ClassName mapKeyProxyClassName(ContributionBinding binding) {
        return SourceFiles.elementBasedClassName(MoreElements.asExecutable(binding.bindingElement().get()), "MapKey");
    }

    public static Optional<MethodSpec> mapKeyFactoryMethod(ContributionBinding binding, XProcessingEnv processingEnv, DaggerElements elements) {
        return binding.mapKeyAnnotation().filter(mapKey -> !MapKeyAccessibility.isMapKeyPubliclyAccessible(mapKey)).map(mapKey -> MethodSpec.methodBuilder((String)"create").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(TypeName.get((TypeMirror)MapKeys.mapKeyType(XConverters.toXProcessing(mapKey, processingEnv)))).addStatement("return $L", new Object[]{MapKeys.directMapKeyExpression(mapKey, elements)}).build());
    }

    private MapKeys() {
    }
}

