/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.base.AutoValue_ModuleAnnotation;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.shaded.androidx.room.compiler.processing.XAnnotated;
import dagger.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.shaded.androidx.room.compiler.processing.XElement;
import dagger.shaded.androidx.room.compiler.processing.XType;
import dagger.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.Optional;

@AutoValue
public abstract class ModuleAnnotation {
    private static final ImmutableSet<ClassName> MODULE_ANNOTATIONS = ImmutableSet.of((Object)TypeNames.MODULE, (Object)TypeNames.PRODUCER_MODULE);
    private XAnnotation annotation;

    public final XAnnotation annotation() {
        return this.annotation;
    }

    public abstract ClassName className();

    public String simpleName() {
        return this.className().simpleName();
    }

    public ImmutableList<XTypeElement> includes() {
        return (ImmutableList)this.annotation.getAsTypeList("includes").stream().map(XType::getTypeElement).collect(DaggerStreams.toImmutableList());
    }

    public ImmutableList<XTypeElement> subcomponents() {
        return (ImmutableList)this.annotation.getAsTypeList("subcomponents").stream().map(XType::getTypeElement).collect(DaggerStreams.toImmutableList());
    }

    public static boolean isModuleAnnotation(XAnnotation annotation) {
        return MODULE_ANNOTATIONS.contains((Object)XAnnotations.getClassName(annotation));
    }

    public static ImmutableSet<ClassName> moduleAnnotations() {
        return MODULE_ANNOTATIONS;
    }

    public static ModuleAnnotation moduleAnnotation(XAnnotation annotation) {
        Preconditions.checkArgument((boolean)ModuleAnnotation.isModuleAnnotation(annotation), (String)"%s is not a Module or ProducerModule annotation", (Object)annotation);
        AutoValue_ModuleAnnotation moduleAnnotation = new AutoValue_ModuleAnnotation(XAnnotations.getClassName(annotation));
        moduleAnnotation.annotation = annotation;
        return moduleAnnotation;
    }

    public static Optional<ModuleAnnotation> moduleAnnotation(XElement element) {
        return XElements.getAnyAnnotation((XAnnotated)element, TypeNames.MODULE, TypeNames.PRODUCER_MODULE).map(ModuleAnnotation::moduleAnnotation);
    }
}

