/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.base.UniqueNameSet;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.FrameworkField;
import dagger.internal.codegen.binding.KeyFactory;
import dagger.internal.codegen.binding.ProductionBinding;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.AnnotationSpecs;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.writing.GwtCompatibility;
import dagger.producers.internal.AbstractProducesMethodProducer;
import dagger.producers.internal.Producers;
import dagger.shaded.androidx.room.compiler.processing.XFiler;
import dagger.spi.model.DaggerElement;
import dagger.spi.model.DependencyRequest;
import dagger.spi.model.Key;
import dagger.spi.model.RequestKind;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public final class ProducerFactoryGenerator
extends SourceFileGenerator<ProductionBinding> {
    private final CompilerOptions compilerOptions;
    private final KeyFactory keyFactory;

    @Inject
    ProducerFactoryGenerator(XFiler filer, DaggerElements elements, SourceVersion sourceVersion, CompilerOptions compilerOptions, KeyFactory keyFactory) {
        super(filer, elements, sourceVersion);
        this.compilerOptions = compilerOptions;
        this.keyFactory = keyFactory;
    }

    @Override
    public Element originatingElement(ProductionBinding binding) {
        return binding.bindingElement().get();
    }

    @Override
    public ImmutableList<TypeSpec.Builder> topLevelTypes(ProductionBinding binding) {
        Preconditions.checkArgument((!binding.unresolved().isPresent() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)binding.bindingElement().isPresent());
        TypeName providedTypeName = TypeName.get((TypeMirror)binding.contributedType());
        ParameterizedTypeName futureTypeName = TypeNames.listenableFutureOf(providedTypeName);
        ClassName generatedTypeName = SourceFiles.generatedClassNameForBinding(binding);
        TypeSpec.Builder factoryBuilder = TypeSpec.classBuilder((ClassName)generatedTypeName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addTypeVariables(SourceFiles.bindingTypeElementTypeVariableNames(binding));
        UniqueNameSet uniqueFieldNames = new UniqueNameSet();
        ImmutableMap.Builder fieldsBuilder = ImmutableMap.builder();
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE});
        Optional moduleField = binding.requiresModuleInstance() ? Optional.of(ProducerFactoryGenerator.addFieldAndConstructorParameter(factoryBuilder, constructorBuilder, uniqueFieldNames.getUniqueName("module"), TypeName.get((TypeMirror)binding.bindingTypeElement().get().asType()))) : Optional.empty();
        ArrayList<CodeBlock> frameworkFieldAssignments = new ArrayList<CodeBlock>();
        String executorParameterName = null;
        String monitorParameterName = null;
        ImmutableMap<DependencyRequest, FrameworkField> bindingFieldsForDependencies = SourceFiles.generateBindingFieldsForDependencies(binding);
        for (Map.Entry entry : bindingFieldsForDependencies.entrySet()) {
            DependencyRequest dependency = (DependencyRequest)entry.getKey();
            Key key = dependency.key();
            FrameworkField bindingField = (FrameworkField)entry.getValue();
            String fieldName = uniqueFieldNames.getUniqueName(bindingField.name());
            if (key.equals((Object)this.keyFactory.forProductionImplementationExecutor())) {
                executorParameterName = fieldName;
                constructorBuilder.addParameter((TypeName)bindingField.type(), executorParameterName, new Modifier[0]);
                continue;
            }
            if (key.equals((Object)this.keyFactory.forProductionComponentMonitor())) {
                monitorParameterName = fieldName;
                constructorBuilder.addParameter((TypeName)bindingField.type(), monitorParameterName, new Modifier[0]);
                continue;
            }
            FieldSpec field = ProducerFactoryGenerator.addFieldAndConstructorParameter(factoryBuilder, constructorBuilder, fieldName, (TypeName)bindingField.type());
            fieldsBuilder.put((Object)dependency, (Object)field);
            frameworkFieldAssignments.add(ProducerFactoryGenerator.fieldAssignment(field, bindingField.type()));
        }
        ImmutableMap fields = fieldsBuilder.build();
        constructorBuilder.addStatement("super($N, $L, $N)", new Object[]{Verify.verifyNotNull(monitorParameterName), this.producerTokenConstruction(generatedTypeName, binding), Verify.verifyNotNull(executorParameterName)});
        if (binding.requiresModuleInstance()) {
            ProducerFactoryGenerator.assignField(constructorBuilder, (FieldSpec)moduleField.get(), null);
        }
        constructorBuilder.addCode(CodeBlock.join(frameworkFieldAssignments, (String)"\n"));
        MethodSpec.Builder collectDependenciesBuilder = MethodSpec.methodBuilder((String)"collectDependencies").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED});
        ImmutableList<DependencyRequest> asyncDependencies = ProducerFactoryGenerator.asyncDependencies(binding);
        for (DependencyRequest dependency : asyncDependencies) {
            ParameterizedTypeName futureType = TypeNames.listenableFutureOf(ProducerFactoryGenerator.asyncDependencyType(dependency));
            CodeBlock futureAccess = CodeBlock.of((String)"$N.get()", (Object[])new Object[]{fields.get((Object)dependency)});
            collectDependenciesBuilder.addStatement("$T $L = $L", new Object[]{futureType, ProducerFactoryGenerator.dependencyFutureName(dependency), dependency.kind().equals((Object)RequestKind.PRODUCED) ? CodeBlock.of((String)"$T.createFutureProduced($L)", (Object[])new Object[]{TypeNames.PRODUCERS, futureAccess}) : futureAccess});
        }
        FutureTransform futureTransform = FutureTransform.create((ImmutableMap<DependencyRequest, FieldSpec>)fields, binding, asyncDependencies);
        collectDependenciesBuilder.returns((TypeName)TypeNames.listenableFutureOf(futureTransform.applyArgType())).addStatement("return $L", new Object[]{futureTransform.futureCodeBlock()});
        MethodSpec.Builder callProducesMethod = MethodSpec.methodBuilder((String)"callProducesMethod").returns((TypeName)futureTypeName).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(futureTransform.applyArgType(), futureTransform.applyArgName(), new Modifier[0]).addExceptions(this.getThrownTypeNames((Iterable<? extends TypeMirror>)binding.thrownTypes())).addCode(this.getInvocationCodeBlock(binding, providedTypeName, futureTransform.parameterCodeBlocks()));
        if (futureTransform.hasUncheckedCast()) {
            callProducesMethod.addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.UNCHECKED, new AnnotationSpecs.Suppression[0]));
        }
        MethodSpec constructor = constructorBuilder.build();
        factoryBuilder.superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(AbstractProducesMethodProducer.class), (TypeName[])new TypeName[]{futureTransform.applyArgType(), providedTypeName})).addMethod(constructor).addMethod(this.staticFactoryMethod(binding, constructor)).addMethod(collectDependenciesBuilder.build()).addMethod(callProducesMethod.build());
        GwtCompatibility.gwtIncompatibleAnnotation(binding).ifPresent(arg_0 -> ((TypeSpec.Builder)factoryBuilder).addAnnotation(arg_0));
        return ImmutableList.of((Object)factoryBuilder);
    }

    private MethodSpec staticFactoryMethod(ProductionBinding binding, MethodSpec constructor) {
        return MethodSpec.methodBuilder((String)"create").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(SourceFiles.parameterizedGeneratedTypeNameForBinding(binding)).addTypeVariables(SourceFiles.bindingTypeElementTypeVariableNames(binding)).addParameters((Iterable)constructor.parameters).addStatement("return new $T($L)", new Object[]{SourceFiles.parameterizedGeneratedTypeNameForBinding(binding), constructor.parameters.stream().map(p -> CodeBlock.of((String)"$N", (Object[])new Object[]{p.name})).collect(CodeBlocks.toParametersCodeBlock())}).build();
    }

    private static FieldSpec addFieldAndConstructorParameter(TypeSpec.Builder typeBuilder, MethodSpec.Builder constructorBuilder, String variableName, TypeName variableType) {
        FieldSpec field = FieldSpec.builder((TypeName)variableType, (String)variableName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
        typeBuilder.addField(field);
        constructorBuilder.addParameter(field.type, field.name, new Modifier[0]);
        return field;
    }

    private static CodeBlock fieldAssignment(FieldSpec field, ParameterizedTypeName type2) {
        CodeBlock.Builder statement = CodeBlock.builder();
        if (type2 != null && type2.rawType.equals((Object)TypeNames.PRODUCER)) {
            statement.addStatement("this.$1N = $2T.nonCancellationPropagatingViewOf($1N)", new Object[]{field, Producers.class});
        } else {
            statement.addStatement("this.$1N = $1N", new Object[]{field});
        }
        return statement.build();
    }

    private static void assignField(MethodSpec.Builder constructorBuilder, FieldSpec field, ParameterizedTypeName type2) {
        if (type2 != null && type2.rawType.equals((Object)TypeNames.PRODUCER)) {
            constructorBuilder.addStatement("this.$1N = $2T.nonCancellationPropagatingViewOf($1N)", new Object[]{field, Producers.class});
        } else {
            constructorBuilder.addStatement("this.$1N = $1N", new Object[]{field});
        }
    }

    private static ImmutableList<DependencyRequest> asyncDependencies(Binding binding) {
        return (ImmutableList)binding.dependencies().stream().filter(ProducerFactoryGenerator::isAsyncDependency).collect(DaggerStreams.toImmutableList());
    }

    private CodeBlock producerTokenConstruction(ClassName generatedTypeName, ProductionBinding binding) {
        CodeBlock producerTokenArgs = this.compilerOptions.writeProducerNameInToken() ? CodeBlock.of((String)"$S", (Object[])new Object[]{String.format("%s#%s", ClassName.get((TypeElement)binding.bindingTypeElement().get()), binding.bindingElement().get().getSimpleName())}) : CodeBlock.of((String)"$T.class", (Object[])new Object[]{generatedTypeName});
        return CodeBlock.of((String)"$T.create($L)", (Object[])new Object[]{TypeNames.PRODUCER_TOKEN, producerTokenArgs});
    }

    private static String dependencyFutureName(DependencyRequest dependency) {
        return ((DaggerElement)dependency.requestElement().get()).java().getSimpleName() + "Future";
    }

    private static boolean isAsyncDependency(DependencyRequest dependency) {
        switch (dependency.kind()) {
            case INSTANCE: 
            case PRODUCED: {
                return true;
            }
        }
        return false;
    }

    private static TypeName asyncDependencyType(DependencyRequest dependency) {
        TypeName keyName = TypeName.get((TypeMirror)dependency.key().type().java());
        switch (dependency.kind()) {
            case INSTANCE: {
                return keyName;
            }
            case PRODUCED: {
                return TypeNames.producedOf(keyName);
            }
        }
        throw new AssertionError();
    }

    private CodeBlock getInvocationCodeBlock(ProductionBinding binding, TypeName providedTypeName, ImmutableList<CodeBlock> parameterCodeBlocks) {
        CodeBlock returnCodeBlock;
        CodeBlock moduleCodeBlock = CodeBlock.of((String)"$L.$L($L)", (Object[])new Object[]{binding.requiresModuleInstance() ? "module" : CodeBlock.of((String)"$T", (Object[])new Object[]{ClassName.get((TypeElement)binding.bindingTypeElement().get())}), binding.bindingElement().get().getSimpleName(), CodeBlocks.makeParametersCodeBlock(parameterCodeBlocks)});
        switch (binding.productionKind().get()) {
            case IMMEDIATE: {
                returnCodeBlock = CodeBlock.of((String)"$T.<$T>immediateFuture($L)", (Object[])new Object[]{TypeNames.FUTURES, providedTypeName, moduleCodeBlock});
                break;
            }
            case FUTURE: {
                returnCodeBlock = moduleCodeBlock;
                break;
            }
            case SET_OF_FUTURE: {
                returnCodeBlock = CodeBlock.of((String)"$T.allAsSet($L)", (Object[])new Object[]{TypeNames.PRODUCERS, moduleCodeBlock});
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return CodeBlock.of((String)"return $L;", (Object[])new Object[]{returnCodeBlock});
    }

    private FluentIterable<? extends TypeName> getThrownTypeNames(Iterable<? extends TypeMirror> thrownTypes2) {
        return FluentIterable.from(thrownTypes2).transform(TypeName::get);
    }

    @Override
    protected ImmutableSet<AnnotationSpecs.Suppression> warningSuppressions() {
        return ImmutableSet.of((Object)((Object)AnnotationSpecs.Suppression.FUTURE_RETURN_VALUE_IGNORED));
    }

    static final class MultiArgFutureTransform
    extends FutureTransform {
        private final ImmutableList<DependencyRequest> asyncDependencies;

        MultiArgFutureTransform(ImmutableMap<DependencyRequest, FieldSpec> fields, ProductionBinding binding, ImmutableList<DependencyRequest> asyncDependencies) {
            super(fields, binding);
            this.asyncDependencies = asyncDependencies;
        }

        @Override
        CodeBlock futureCodeBlock() {
            return CodeBlock.of((String)"$T.<$T>allAsList($L)", (Object[])new Object[]{TypeNames.FUTURES, ClassName.OBJECT, this.asyncDependencies.stream().map(x$0 -> ProducerFactoryGenerator.dependencyFutureName(x$0)).collect(Collectors.joining(", "))});
        }

        @Override
        TypeName applyArgType() {
            return TypeNames.listOf((TypeName)ClassName.OBJECT);
        }

        @Override
        String applyArgName() {
            return "args";
        }

        @Override
        ImmutableList<CodeBlock> parameterCodeBlocks() {
            int argIndex = 0;
            ImmutableList.Builder codeBlocks = ImmutableList.builder();
            for (DependencyRequest dependency : this.binding.explicitDependencies()) {
                if (ProducerFactoryGenerator.isAsyncDependency(dependency)) {
                    codeBlocks.add((Object)CodeBlock.of((String)"($T) $L.get($L)", (Object[])new Object[]{ProducerFactoryGenerator.asyncDependencyType(dependency), this.applyArgName(), argIndex}));
                    ++argIndex;
                    continue;
                }
                codeBlocks.add((Object)this.frameworkTypeUsageStatement(dependency));
            }
            return codeBlocks.build();
        }

        @Override
        boolean hasUncheckedCast() {
            return true;
        }
    }

    static final class SingleArgFutureTransform
    extends FutureTransform {
        private final DependencyRequest asyncDependency;

        SingleArgFutureTransform(ImmutableMap<DependencyRequest, FieldSpec> fields, ProductionBinding binding, DependencyRequest asyncDependency) {
            super(fields, binding);
            this.asyncDependency = asyncDependency;
        }

        @Override
        CodeBlock futureCodeBlock() {
            return CodeBlock.of((String)"$L", (Object[])new Object[]{ProducerFactoryGenerator.dependencyFutureName(this.asyncDependency)});
        }

        @Override
        TypeName applyArgType() {
            return ProducerFactoryGenerator.asyncDependencyType(this.asyncDependency);
        }

        @Override
        String applyArgName() {
            String argName = ((DaggerElement)this.asyncDependency.requestElement().get()).java().getSimpleName().toString();
            if (argName.equals("module")) {
                return "moduleArg";
            }
            return argName;
        }

        @Override
        ImmutableList<CodeBlock> parameterCodeBlocks() {
            ImmutableList.Builder parameterCodeBlocks = ImmutableList.builder();
            for (DependencyRequest dependency : this.binding.explicitDependencies()) {
                if (dependency == this.asyncDependency) {
                    parameterCodeBlocks.add((Object)CodeBlock.of((String)"$L", (Object[])new Object[]{this.applyArgName()}));
                    continue;
                }
                parameterCodeBlocks.add((Object)this.frameworkTypeUsageStatement(dependency));
            }
            return parameterCodeBlocks.build();
        }
    }

    static final class NoArgFutureTransform
    extends FutureTransform {
        NoArgFutureTransform(ImmutableMap<DependencyRequest, FieldSpec> fields, ProductionBinding binding) {
            super(fields, binding);
        }

        @Override
        CodeBlock futureCodeBlock() {
            return CodeBlock.of((String)"$T.<$T>immediateFuture(null)", (Object[])new Object[]{TypeNames.FUTURES, TypeNames.VOID_CLASS});
        }

        @Override
        TypeName applyArgType() {
            return TypeNames.VOID_CLASS;
        }

        @Override
        String applyArgName() {
            return "ignoredVoidArg";
        }

        @Override
        ImmutableList<CodeBlock> parameterCodeBlocks() {
            return (ImmutableList)this.binding.explicitDependencies().stream().map(this::frameworkTypeUsageStatement).collect(DaggerStreams.toImmutableList());
        }
    }

    static abstract class FutureTransform {
        protected final ImmutableMap<DependencyRequest, FieldSpec> fields;
        protected final ProductionBinding binding;

        FutureTransform(ImmutableMap<DependencyRequest, FieldSpec> fields, ProductionBinding binding) {
            this.fields = fields;
            this.binding = binding;
        }

        abstract CodeBlock futureCodeBlock();

        abstract TypeName applyArgType();

        abstract String applyArgName();

        abstract ImmutableList<CodeBlock> parameterCodeBlocks();

        boolean hasUncheckedCast() {
            return false;
        }

        CodeBlock frameworkTypeUsageStatement(DependencyRequest dependency) {
            return SourceFiles.frameworkTypeUsageStatement(CodeBlock.of((String)"$N", (Object[])new Object[]{this.fields.get((Object)dependency)}), dependency.kind());
        }

        static FutureTransform create(ImmutableMap<DependencyRequest, FieldSpec> fields, ProductionBinding binding, ImmutableList<DependencyRequest> asyncDependencies) {
            if (asyncDependencies.isEmpty()) {
                return new NoArgFutureTransform(fields, binding);
            }
            if (asyncDependencies.size() == 1) {
                return new SingleArgFutureTransform(fields, binding, (DependencyRequest)Iterables.getOnlyElement(asyncDependencies));
            }
            return new MultiArgFutureTransform(fields, binding, asyncDependencies);
        }
    }
}

