/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.base.Util;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.kotlin.KotlinMetadataUtil;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ComponentRequestRepresentations;
import dagger.internal.codegen.writing.InjectionMethods;
import dagger.internal.codegen.writing.PerComponentImplementation;
import dagger.spi.model.DependencyRequest;
import dagger.spi.model.Key;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

@PerComponentImplementation
final class MembersInjectionMethods {
    private final Map<Key, Expression> injectMethodExpressions = new LinkedHashMap<Key, Expression>();
    private final ComponentImplementation componentImplementation;
    private final ComponentRequestRepresentations bindingExpressions;
    private final BindingGraph graph;
    private final DaggerElements elements;
    private final DaggerTypes types;
    private final KotlinMetadataUtil metadataUtil;

    @Inject
    MembersInjectionMethods(ComponentImplementation componentImplementation, ComponentRequestRepresentations bindingExpressions, BindingGraph graph, DaggerElements elements, DaggerTypes types, KotlinMetadataUtil metadataUtil) {
        this.componentImplementation = (ComponentImplementation)Preconditions.checkNotNull((Object)componentImplementation);
        this.bindingExpressions = (ComponentRequestRepresentations)Preconditions.checkNotNull((Object)bindingExpressions);
        this.graph = (BindingGraph)Preconditions.checkNotNull((Object)graph);
        this.elements = (DaggerElements)Preconditions.checkNotNull((Object)elements);
        this.types = (DaggerTypes)Preconditions.checkNotNull((Object)types);
        this.metadataUtil = metadataUtil;
    }

    Expression getInjectExpression(Key key, CodeBlock instance, ClassName requestingClass) {
        ContributionBinding binding = this.graph.membersInjectionBinding(key).isPresent() ? (Binding)this.graph.membersInjectionBinding(key).get() : this.graph.contributionBinding(key);
        Expression expression = Util.reentrantComputeIfAbsent(this.injectMethodExpressions, key, k -> this.injectMethodExpression(binding, requestingClass));
        ComponentImplementation.ShardImplementation shardImplementation = this.componentImplementation.shardImplementation(binding);
        return Expression.create(expression.type(), shardImplementation.name().equals((Object)requestingClass) ? CodeBlock.of((String)"$L($L)", (Object[])new Object[]{expression.codeBlock(), instance}) : CodeBlock.of((String)"$L.$L($L)", (Object[])new Object[]{shardImplementation.shardFieldReference(), expression.codeBlock(), instance}));
    }

    private Expression injectMethodExpression(Binding binding, ClassName requestingClass) {
        ComponentImplementation.ShardImplementation shardImplementation = this.componentImplementation.shardImplementation(binding);
        TypeMirror keyType = binding.key().type().java();
        TypeMirror membersInjectedType = Accessibility.isTypeAccessibleFrom(keyType, shardImplementation.name().packageName()) ? keyType : this.elements.getTypeElement(Object.class).asType();
        TypeName membersInjectedTypeName = TypeName.get((TypeMirror)membersInjectedType);
        Name bindingTypeName = binding.bindingTypeElement().get().getSimpleName();
        String methodName = shardImplementation.getUniqueMethodName("inject" + bindingTypeName);
        ParameterSpec parameter = ParameterSpec.builder((TypeName)membersInjectedTypeName, (String)"instance", (Modifier[])new Modifier[0]).build();
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PRIVATE}).returns(membersInjectedTypeName).addParameter(parameter);
        TypeElement canIgnoreReturnValue = this.elements.getTypeElement("com.google.errorprone.annotations.CanIgnoreReturnValue");
        if (canIgnoreReturnValue != null) {
            methodBuilder.addAnnotation(ClassName.get((TypeElement)canIgnoreReturnValue));
        }
        CodeBlock instance = CodeBlock.of((String)"$N", (Object[])new Object[]{parameter});
        methodBuilder.addCode(InjectionMethods.InjectionSiteMethod.invokeAll(MembersInjectionMethods.injectionSites(binding), shardImplementation.name(), instance, membersInjectedType, request -> this.bindingExpressions.getDependencyArgumentExpression((DependencyRequest)request, shardImplementation.name()).codeBlock(), this.types, this.metadataUtil));
        methodBuilder.addStatement("return $L", new Object[]{instance});
        MethodSpec method = methodBuilder.build();
        shardImplementation.addMethod(ComponentImplementation.MethodSpecKind.MEMBERS_INJECTION_METHOD, method);
        return Expression.create(membersInjectedType, CodeBlock.of((String)"$N", (Object[])new Object[]{method}));
    }

    private static ImmutableSet<MembersInjectionBinding.InjectionSite> injectionSites(Binding binding) {
        if (binding instanceof ProvisionBinding) {
            return ((ProvisionBinding)binding).injectionSites();
        }
        if (binding instanceof MembersInjectionBinding) {
            return ((MembersInjectionBinding)binding).injectionSites();
        }
        throw new IllegalArgumentException(binding.key().toString());
    }
}

