/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.validation.BindsInstanceMethodValidator;
import dagger.internal.codegen.validation.BindsInstanceParameterValidator;
import dagger.internal.codegen.validation.TypeCheckingProcessingStep;
import dagger.shaded.androidx.room.compiler.processing.XElement;
import dagger.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.shaded.androidx.room.compiler.processing.XMessager;
import dagger.shaded.androidx.room.compiler.processing.XVariableElement;
import dagger.shaded.androidx.room.compiler.processing.compat.XConverters;
import javax.inject.Inject;
import javax.lang.model.element.Element;

public final class BindsInstanceProcessingStep
extends TypeCheckingProcessingStep<XElement> {
    private final BindsInstanceMethodValidator methodValidator;
    private final BindsInstanceParameterValidator parameterValidator;
    private final XMessager messager;

    @Inject
    BindsInstanceProcessingStep(BindsInstanceMethodValidator methodValidator, BindsInstanceParameterValidator parameterValidator, XMessager messager2) {
        this.methodValidator = methodValidator;
        this.parameterValidator = parameterValidator;
        this.messager = messager2;
    }

    public ImmutableSet<ClassName> annotationClassNames() {
        return ImmutableSet.of((Object)TypeNames.BINDS_INSTANCE);
    }

    @Override
    protected void process(XElement xElement, ImmutableSet<ClassName> annotations2) {
        Element element = XConverters.toJavac(xElement);
        switch (element.getKind()) {
            case PARAMETER: {
                this.parameterValidator.validate((XVariableElement)xElement).printMessagesTo(this.messager);
                break;
            }
            case METHOD: {
                this.methodValidator.validate((XExecutableElement)xElement).printMessagesTo(this.messager);
                break;
            }
            default: {
                throw new AssertionError(xElement);
            }
        }
    }
}

