/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.validation.BindingElementValidator;
import dagger.internal.codegen.validation.BindsInstanceElementValidator;
import dagger.shaded.androidx.room.compiler.processing.XElement;
import dagger.shaded.androidx.room.compiler.processing.XVariableElement;
import dagger.shaded.auto.common.MoreElements;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

final class BindsInstanceParameterValidator
extends BindsInstanceElementValidator<XVariableElement> {
    @Inject
    BindsInstanceParameterValidator(InjectionAnnotations injectionAnnotations) {
        super(injectionAnnotations);
    }

    @Override
    protected BindingElementValidator.ElementValidator elementValidator(XVariableElement xElement) {
        return new Validator(xElement);
    }

    private class Validator
    extends BindingElementValidator.ElementValidator {
        Validator(XVariableElement xElement) {
            super((BindingElementValidator)BindsInstanceParameterValidator.this, (XElement)xElement);
        }

        @Override
        protected void checkAdditionalProperties() {
            TypeKind returnKind;
            Element enclosing = this.element.getEnclosingElement();
            if (!enclosing.getKind().equals((Object)ElementKind.METHOD)) {
                this.report.addError("@BindsInstance should only be applied to methods or parameters of methods");
                return;
            }
            ExecutableElement method = MoreElements.asExecutable(enclosing);
            if (!method.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                this.report.addError("@BindsInstance parameters may only be used in abstract methods");
            }
            if (!(returnKind = method.getReturnType().getKind()).equals((Object)TypeKind.DECLARED) && !returnKind.equals((Object)TypeKind.TYPEVAR)) {
                this.report.addError("@BindsInstance parameters may not be used in methods with a void, array or primitive return type");
            }
        }

        @Override
        protected Optional<TypeMirror> bindingElementType() {
            return Optional.of(this.element.asType());
        }
    }
}

